/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.client.cloth;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;

public class ClothDropdownSelectEntry<V>
extends TooltipListEntry<V> {
    private static final int MAX_VISIBLE_LINES = 5;
    private V value;
    private final V originalValue;
    private final Supplier<V> defaultValue;
    private final Consumer<V> saveConsumer;
    private final Function<V, class_2561> valueConverter;
    private final V[] options;
    private final class_4185 mainButton;
    private final class_4185 resetButton;
    private boolean optionsVisible = false;
    private int scrollOffset = 0;

    public ClothDropdownSelectEntry(class_2561 fieldName, V originalValue, class_2561 resetButtonText, Supplier<Optional<class_2561[]>> tooltipSupplier, boolean requiresRestart, Supplier<V> defaultValue, Consumer<V> saveConsumer, List<V> options, Function<V, class_2561> valueConverter) {
        super(fieldName, tooltipSupplier, requiresRestart);
        this.originalValue = originalValue;
        this.defaultValue = defaultValue;
        this.saveConsumer = saveConsumer;
        this.options = options.toArray();
        this.valueConverter = valueConverter;
        this.mainButton = new class_4185(0, 0, 150, 20, resetButtonText, button -> {
            this.optionsVisible = !this.optionsVisible;
            this.scrollOffset = 0;
        });
        this.resetButton = new class_4185(0, 0, class_310.method_1551().field_1772.method_27525((class_5348)resetButtonText) + 6, 20, resetButtonText, button -> this.setValue(this.getDefaultValue().orElse(null)));
        this.setValue(originalValue);
    }

    public void setValue(V value) {
        this.value = value;
        if (value == null) {
            this.mainButton.method_25355((class_2561)new class_2588("tweed.cloth.dropdown.empty"));
        } else {
            this.mainButton.method_25355(this.valueConverter.apply(value));
        }
    }

    public V getValue() {
        return this.value;
    }

    public Optional<V> getDefaultValue() {
        return this.defaultValue == null ? Optional.empty() : Optional.ofNullable(this.defaultValue.get());
    }

    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    public List<? extends class_364> method_25396() {
        return ImmutableList.of((Object)this.mainButton, (Object)this.resetButton);
    }

    public boolean isEdited() {
        return super.isEdited() || !Objects.equals(this.value, this.originalValue);
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        if (mouseY >= (double)(this.mainButton.field_22761 + this.mainButton.method_25364()) && mouseY < (double)(this.mainButton.field_22761 + this.mainButton.method_25364() + this.getOptionsVisibleLength() * 14) && mouseX >= (double)this.mainButton.field_22760 && mouseX < (double)(this.mainButton.field_22760 + this.mainButton.method_25368())) {
            this.scrollOffset = class_3532.method_15340((int)(this.scrollOffset - (int)amount), (int)0, (int)Math.max(0, this.options.length - 5 - 1));
            return true;
        }
        return false;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (mouseY >= (double)this.mainButton.field_22761 && mouseY < (double)(this.mainButton.field_22761 + this.getItemHeight())) {
            int pos;
            if (this.optionsVisible && mouseX >= (double)this.mainButton.field_22760 && mouseX < (double)(this.mainButton.field_22760 + this.mainButton.method_25368()) && (pos = (int)((mouseY - (double)this.getOptionsTop()) / 14.0)) >= 0 && pos < 5) {
                this.setValue(this.options[pos += this.scrollOffset]);
                this.optionsVisible = false;
                return true;
            }
        } else {
            this.optionsVisible = false;
            return false;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public int getOptionsVisibleLength() {
        return Math.min(5, this.options.length);
    }

    public int getItemHeight() {
        return super.getItemHeight() + (this.optionsVisible ? this.getOptionsVisibleLength() * 14 + 5 : 0);
    }

    private int getOptionsTop() {
        return this.mainButton.field_22761 + this.mainButton.method_25364() + 3;
    }

    public void render(class_4587 matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        super.render(matrices, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        class_1041 window = class_310.method_1551().method_22683();
        this.mainButton.field_22763 = this.isEditable();
        this.resetButton.field_22763 = this.isEditable() && this.getDefaultValue().map(def -> !def.equals(this.value)).orElse(false) != false;
        this.mainButton.field_22761 = y;
        this.resetButton.field_22761 = y;
        class_2561 displayedFieldName = this.getDisplayedFieldName();
        if (class_310.method_1551().field_1772.method_1726()) {
            class_310.method_1551().field_1772.method_30881(matrices, displayedFieldName, (float)(window.method_4486() - x - class_310.method_1551().field_1772.method_27525((class_5348)displayedFieldName)), (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_22760 = x;
            this.mainButton.field_22760 = x + this.resetButton.method_25368() + 1;
        } else {
            class_310.method_1551().field_1772.method_30881(matrices, displayedFieldName, (float)x, (float)(y + 6), this.getPreferredTextColor());
            this.resetButton.field_22760 = x + entryWidth - this.resetButton.method_25368();
            this.mainButton.field_22760 = x + entryWidth - 150 + 1;
        }
        this.mainButton.method_25358(150 - this.resetButton.method_25368() - 4);
        this.mainButton.method_25394(matrices, mouseX, mouseY, delta);
        this.resetButton.method_25394(matrices, mouseX, mouseY, delta);
        if (this.optionsVisible) {
            int length = this.getOptionsVisibleLength();
            int top = this.mainButton.field_22761 + this.mainButton.method_25364();
            int right = this.mainButton.field_22760 + this.mainButton.method_25368();
            int height = length * 14;
            int mousePos = -1;
            if (mouseX >= this.mainButton.field_22760 && mouseX < right) {
                mousePos = (mouseY - top - 3) / 14 + this.scrollOffset;
            }
            ClothDropdownSelectEntry.method_25294((class_4587)matrices, (int)this.mainButton.field_22760, (int)top, (int)(this.mainButton.field_22760 + this.mainButton.method_25368()), (int)(top + height), (int)-16777216);
            if (this.options.length > length) {
                int l = this.options.length - 1;
                ClothDropdownSelectEntry.method_25294((class_4587)matrices, (int)(right - 3), (int)(top + this.scrollOffset * height / l), (int)right, (int)(top + (5 + this.scrollOffset) * height / l), (int)-4473925);
            }
            for (int i = this.scrollOffset; i < this.scrollOffset + length; ++i) {
                class_310.method_1551().field_1772.method_30883(matrices, this.valueConverter.apply(this.options[i]), (float)this.mainButton.field_22760 + 3.0f, (float)(top + (i - this.scrollOffset) * 14 + 3), mousePos == i ? -1 : -4473925);
            }
        }
    }
}

