/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.reflect;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.optifine.Log;
import net.optifine.reflect.Reflector;
import net.optifine.reflect.ReflectorClass;
import net.optifine.reflect.ReflectorConstructor;
import net.optifine.reflect.ReflectorField;
import net.optifine.util.StrUtils;

public class ReflectorForge {
    public static Object EVENT_RESULT_ALLOW = Reflector.getFieldValue(Reflector.Event_Result_ALLOW);
    public static Object EVENT_RESULT_DENY = Reflector.getFieldValue(Reflector.Event_Result_DENY);
    public static Object EVENT_RESULT_DEFAULT = Reflector.getFieldValue(Reflector.Event_Result_DEFAULT);
    public static final boolean FORGE_BLOCKSTATE_HAS_TILE_ENTITY = Reflector.IForgeBlockState_hasTileEntity.exists();
    public static final boolean FORGE_ENTITY_CAN_UPDATE = Reflector.IForgeEntity_canUpdate.exists();

    public static void putLaunchBlackboard(String key, Object value) {
        Map blackboard = (Map)Reflector.getFieldValue(Reflector.Launch_blackboard);
        if (blackboard == null) {
            return;
        }
        blackboard.put(key, value);
    }

    public static InputStream getOptiFineResourceStream(String path) {
        if (!Reflector.OptiFineResourceLocator.exists()) {
            return null;
        }
        path = StrUtils.removePrefix(path, "/");
        InputStream in = (InputStream)Reflector.call(Reflector.OptiFineResourceLocator_getOptiFineResourceStream, path);
        return in;
    }

    public static ReflectorClass getReflectorClassOptiFineResourceLocator() {
        String className = "optifine.OptiFineResourceLocator";
        Object ofrlClass = System.getProperties().get(className + ".class");
        if (ofrlClass instanceof Class) {
            Class cls = (Class)ofrlClass;
            return new ReflectorClass(cls);
        }
        return new ReflectorClass(className);
    }

    public static boolean isBarVisible(class_1799 stack) {
        if (Reflector.IForgeItem_showDurabilityBar.exists()) {
            return Reflector.callBoolean(stack.method_7909(), Reflector.IForgeItem_showDurabilityBar, stack);
        }
        return stack.method_31578();
    }

    public static int getLightValue(class_2680 stateIn, class_1920 worldIn, class_2338 posIn) {
        if (Reflector.IForgeBlockState_getLightValue2.exists()) {
            return Reflector.callInt(stateIn, Reflector.IForgeBlockState_getLightValue2, worldIn, posIn);
        }
        return stateIn.method_26213();
    }

    public static class_22 getMapData(class_1799 stack, class_1937 world) {
        if (Reflector.ForgeHooksClient.exists()) {
            class_1806 cfr_ignored_0 = (class_1806)stack.method_7909();
            return class_1806.method_8001((class_1799)stack, (class_1937)world);
        }
        return class_1806.method_8001((class_1799)stack, (class_1937)world);
    }

    public static String[] getForgeModIds() {
        if (!Reflector.Loader.exists()) {
            return new String[0];
        }
        Object loader = Reflector.call(Reflector.Loader_instance, new Object[0]);
        List listActiveMods = (List)Reflector.call(loader, Reflector.Loader_getActiveModList, new Object[0]);
        if (listActiveMods == null) {
            return new String[0];
        }
        ArrayList<String> listModIds = new ArrayList<String>();
        for (Object modContainer : listActiveMods) {
            String modId;
            if (!Reflector.ModContainer.isInstance(modContainer) || (modId = Reflector.callString(modContainer, Reflector.ModContainer_getModId, new Object[0])) == null) continue;
            listModIds.add(modId);
        }
        String[] modIds = listModIds.toArray(new String[listModIds.size()]);
        return modIds;
    }

    public static boolean canDisableShield(class_1799 itemstack, class_1799 itemstack1, class_1657 entityplayer, class_1308 entityLiving) {
        if (Reflector.IForgeItemStack_canDisableShield.exists()) {
            return Reflector.callBoolean(itemstack, Reflector.IForgeItemStack_canDisableShield, itemstack1, entityplayer, entityLiving);
        }
        return itemstack.method_7909() instanceof class_1743;
    }

    public static boolean isShield(class_1799 itemstack, class_1657 entityplayer) {
        if (Reflector.IForgeItemStack_isShield.exists()) {
            return Reflector.callBoolean(itemstack, Reflector.IForgeItemStack_isShield, entityplayer);
        }
        return itemstack.method_7909() == class_1802.field_8255;
    }

    public static class_4185 makeButtonMods(class_442 guiMainMenu, int yIn, int rowHeightIn) {
        if (!Reflector.ModListScreen_Constructor.exists()) {
            return null;
        }
        class_4185 btn = new class_4185(guiMainMenu.field_22789 / 2 - 100, yIn + rowHeightIn * 2, 98, 20, (class_2561)new class_2588("fml.menu.mods"), button -> {
            class_437 guiMods = (class_437)Reflector.ModListScreen_Constructor.newInstance(guiMainMenu);
            class_310.method_1551().method_1507(guiMods);
        });
        return btn;
    }

    public static void setForgeLightPipelineEnabled(boolean value) {
        if (Reflector.ForgeConfig_Client_forgeLightPipelineEnabled.exists()) {
            ReflectorForge.setConfigClientBoolean(Reflector.ForgeConfig_Client_forgeLightPipelineEnabled, value);
        }
    }

    public static boolean getForgeUseCombinedDepthStencilAttachment() {
        if (Reflector.ForgeConfig_Client_useCombinedDepthStencilAttachment.exists()) {
            return ReflectorForge.getConfigClientBoolean(Reflector.ForgeConfig_Client_useCombinedDepthStencilAttachment, false);
        }
        return false;
    }

    public static boolean getConfigClientBoolean(ReflectorField configField, boolean def) {
        if (!configField.exists()) {
            return def;
        }
        Object client = Reflector.ForgeConfig_CLIENT.getValue();
        if (client == null) {
            return def;
        }
        Object configValue = Reflector.getFieldValue(client, configField);
        if (configValue == null) {
            return def;
        }
        boolean value = Reflector.callBoolean(configValue, Reflector.ForgeConfigSpec_ConfigValue_get, new Object[0]);
        return value;
    }

    private static void setConfigClientBoolean(ReflectorField clientField, final boolean value) {
        if (!clientField.exists()) {
            return;
        }
        Object client = Reflector.ForgeConfig_CLIENT.getValue();
        if (client == null) {
            return;
        }
        Object configValue = Reflector.getFieldValue(client, clientField);
        if (configValue == null) {
            return;
        }
        Supplier<Boolean> bs = new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return value;
            }
        };
        Reflector.setFieldValue(configValue, Reflector.ForgeConfigSpec_ConfigValue_defaultSupplier, bs);
        Object spec = Reflector.getFieldValue(configValue, Reflector.ForgeConfigSpec_ConfigValue_spec);
        if (spec != null) {
            Reflector.setFieldValue(spec, Reflector.ForgeConfigSpec_childConfig, null);
        }
        Log.dbg("Set ForgeConfig.CLIENT." + clientField.getTargetField().getName() + "=" + value);
    }

    public static boolean canUpdate(class_1297 entity) {
        if (FORGE_ENTITY_CAN_UPDATE) {
            return Reflector.callBoolean(entity, Reflector.IForgeEntity_canUpdate, new Object[0]);
        }
        return true;
    }

    public static boolean isDamageable(class_1792 item, class_1799 stack) {
        if (Reflector.IForgeItem_isDamageable1.exists()) {
            return Reflector.callBoolean(item, Reflector.IForgeItem_isDamageable1, stack);
        }
        return item.method_7846();
    }

    public static void fillNormal(int[] faceData, class_2350 facing) {
        class_1160 v1 = ReflectorForge.getVertexPos(faceData, 3);
        class_1160 t1 = ReflectorForge.getVertexPos(faceData, 1);
        class_1160 v2 = ReflectorForge.getVertexPos(faceData, 2);
        class_1160 t2 = ReflectorForge.getVertexPos(faceData, 0);
        v1.method_4944(t1);
        v2.method_4944(t2);
        v2.method_4951(v1);
        v2.method_4952();
        int x = (byte)Math.round(v2.method_4943() * 127.0f) & 0xFF;
        int y = (byte)Math.round(v2.method_4945() * 127.0f) & 0xFF;
        int z = (byte)Math.round(v2.method_4947() * 127.0f) & 0xFF;
        int normal = x | y << 8 | z << 16;
        int step = faceData.length / 4;
        for (int i = 0; i < 4; ++i) {
            faceData[i * step + 7] = normal;
        }
    }

    private static class_1160 getVertexPos(int[] data, int vertex) {
        int step = data.length / 4;
        int idx = vertex * step;
        float x = Float.intBitsToFloat(data[idx]);
        float y = Float.intBitsToFloat(data[idx + 1]);
        float z = Float.intBitsToFloat(data[idx + 2]);
        return new class_1160(x, y, z);
    }

    public static void postModLoaderEvent(ReflectorConstructor constr, Object ... params) {
        Object event = Reflector.newInstance(constr, params);
        if (event == null) {
            return;
        }
        ReflectorForge.postModLoaderEvent(event);
    }

    public static void postModLoaderEvent(Object event) {
        if (event == null) {
            return;
        }
        Object modLoader = Reflector.ModLoader_get.call(new Object[0]);
        if (modLoader == null) {
            return;
        }
        Reflector.callVoid(modLoader, Reflector.ModLoader_postEvent, event);
    }
}

