/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_155;
import net.minecraft.class_156;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import oshi.SystemInfo;
import oshi.hardware.CentralProcessor;
import oshi.hardware.GlobalMemory;
import oshi.hardware.GraphicsCard;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.PhysicalMemory;
import oshi.hardware.VirtualMemory;

public class class_6396 {
    public static final long field_33852 = 0x100000L;
    private static final long field_33853 = 1000000000L;
    private static final Logger field_33854 = LogManager.getLogger();
    private static final String field_33855 = System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version");
    private static final String field_33856 = System.getProperty("java.version") + ", " + System.getProperty("java.vendor");
    private static final String field_33857 = System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor");
    private final Map<String, String> field_33858 = Maps.newLinkedHashMap();

    public class_6396() {
        this.method_37122("Minecraft Version", class_155.method_16673().getName());
        this.method_37122("Minecraft Version ID", class_155.method_16673().getId());
        this.method_37122("Operating System", field_33855);
        this.method_37122("Java Version", field_33856);
        this.method_37122("Java VM Version", field_33857);
        this.method_37123("Memory", () -> {
            Runtime runtime = Runtime.getRuntime();
            long \u00e2\u02dc\u01922 = runtime.maxMemory();
            long \u00e2\u02dc\u01923 = runtime.totalMemory();
            long \u00e2\u02dc\u01924 = runtime.freeMemory();
            long \u00e2\u02dc\u01925 = \u00e2\u02dc\u01922 / 0x100000L;
            long \u00e2\u02dc\u01926 = \u00e2\u02dc\u01923 / 0x100000L;
            long \u00e2\u02dc\u01927 = \u00e2\u02dc\u01924 / 0x100000L;
            return \u00e2\u02dc\u01924 + " bytes (" + \u00e2\u02dc\u01927 + " MiB) / " + \u00e2\u02dc\u01923 + " bytes (" + \u00e2\u02dc\u01926 + " MiB) up to " + \u00e2\u02dc\u01922 + " bytes (" + \u00e2\u02dc\u01925 + " MiB)";
        });
        this.method_37123("CPUs", () -> String.valueOf(Runtime.getRuntime().availableProcessors()));
        this.method_37121("hardware", () -> this.method_37128(new SystemInfo()));
        this.method_37123("JVM Flags", () -> {
            List list = class_156.method_651().collect(Collectors.toList());
            return String.format("%d total; %s", list.size(), String.join((CharSequence)" ", list));
        });
    }

    public void method_37122(String string, String string2) {
        this.field_33858.put(string, string2);
    }

    public void method_37123(String string, Supplier<String> supplier) {
        try {
            this.method_37122(string, supplier.get());
        }
        catch (Exception exception) {
            field_33854.warn("Failed to get system info for {}", (Object)string, (Object)exception);
            this.method_37122(string, "ERR");
        }
    }

    private void method_37128(SystemInfo systemInfo) {
        HardwareAbstractionLayer hardwareAbstractionLayer = systemInfo.getHardware();
        this.method_37121("processor", () -> this.method_37130(hardwareAbstractionLayer.getProcessor()));
        this.method_37121("graphics", () -> this.method_37137(hardwareAbstractionLayer.getGraphicsCards()));
        this.method_37121("memory", () -> this.method_37131(hardwareAbstractionLayer.getMemory()));
    }

    private void method_37121(String string, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            field_33854.warn("Failed retrieving info for group {}", (Object)string, (Object)throwable);
        }
    }

    private void method_37126(List<PhysicalMemory> list) {
        int n = 0;
        for (PhysicalMemory physicalMemory : list) {
            String string = String.format("Memory slot #%d ", n++);
            this.method_37123(string + "capacity (MB)", () -> String.format("%.2f", Float.valueOf((float)physicalMemory.getCapacity() / 1048576.0f)));
            this.method_37123(string + "clockSpeed (GHz)", () -> String.format("%.2f", Float.valueOf((float)physicalMemory.getClockSpeed() / 1.0E9f)));
            this.method_37123(string + "type", () -> ((PhysicalMemory)physicalMemory).getMemoryType());
        }
    }

    private void method_37135(VirtualMemory virtualMemory) {
        this.method_37123("Virtual memory max (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getVirtualMax() / 1048576.0f)));
        this.method_37123("Virtual memory used (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getVirtualInUse() / 1048576.0f)));
        this.method_37123("Swap memory total (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getSwapTotal() / 1048576.0f)));
        this.method_37123("Swap memory used (MB)", () -> String.format("%.2f", Float.valueOf((float)virtualMemory.getSwapUsed() / 1048576.0f)));
    }

    private void method_37131(GlobalMemory globalMemory) {
        this.method_37121("physical memory", () -> this.method_37126(globalMemory.getPhysicalMemory()));
        this.method_37121("virtual memory", () -> this.method_37135(globalMemory.getVirtualMemory()));
    }

    private void method_37137(List<GraphicsCard> list) {
        int n = 0;
        for (GraphicsCard graphicsCard : list) {
            String string = String.format("Graphics card #%d ", n++);
            this.method_37123(string + "name", () -> ((GraphicsCard)graphicsCard).getName());
            this.method_37123(string + "vendor", () -> ((GraphicsCard)graphicsCard).getVendor());
            this.method_37123(string + "VRAM (MB)", () -> String.format("%.2f", Float.valueOf((float)graphicsCard.getVRam() / 1048576.0f)));
            this.method_37123(string + "deviceId", () -> ((GraphicsCard)graphicsCard).getDeviceId());
            this.method_37123(string + "versionInfo", () -> ((GraphicsCard)graphicsCard).getVersionInfo());
        }
    }

    private void method_37130(CentralProcessor centralProcessor) {
        CentralProcessor.ProcessorIdentifier processorIdentifier = centralProcessor.getProcessorIdentifier();
        this.method_37123("Processor Vendor", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getVendor());
        this.method_37123("Processor Name", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getName());
        this.method_37123("Identifier", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getIdentifier());
        this.method_37123("Microarchitecture", () -> ((CentralProcessor.ProcessorIdentifier)processorIdentifier).getMicroarchitecture());
        this.method_37123("Frequency (GHz)", () -> String.format("%.2f", Float.valueOf((float)processorIdentifier.getVendorFreq() / 1.0E9f)));
        this.method_37123("Number of physical packages", () -> String.valueOf(centralProcessor.getPhysicalPackageCount()));
        this.method_37123("Number of physical CPUs", () -> String.valueOf(centralProcessor.getPhysicalProcessorCount()));
        this.method_37123("Number of logical CPUs", () -> String.valueOf(centralProcessor.getLogicalProcessorCount()));
    }

    public void method_37124(StringBuilder stringBuilder) {
        stringBuilder.append("-- ").append("System Details").append(" --\n");
        stringBuilder.append("Details:");
        this.field_33858.forEach((string, string2) -> {
            stringBuilder.append("\n\t");
            stringBuilder.append((String)string);
            stringBuilder.append(": ");
            stringBuilder.append((String)string2);
        });
    }

    public String method_37120() {
        return this.field_33858.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining(System.lineSeparator()));
    }
}

