/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.base.Charsets;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1162;
import net.minecraft.class_6177;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL30;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@class_6177
public class GlStateManager {
    public static final int TEXTURE_COUNT = 12;
    private static final class_1017 BLEND = new class_1017();
    private static final class_1026 DEPTH = new class_1026();
    private static final class_1025 CULL = new class_1025();
    private static final class_1031 POLY_OFFSET = new class_1031();
    private static final class_1021 COLOR_LOGIC = new class_1021();
    private static final class_1035 STENCIL = new class_1035();
    private static final class_5518 SCISSOR = new class_5518();
    private static int activeTexture;
    private static final class_1039[] TEXTURES;
    private static final class_1022 COLOR_MASK;

    public static void _disableScissorTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.SCISSOR.field_26840.method_4469();
    }

    public static void _enableScissorTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.SCISSOR.field_26840.method_4471();
    }

    public static void _scissorBox(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL20.glScissor((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static void _disableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.DEPTH.field_5074.method_4469();
    }

    public static void _enableDepthTest() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.DEPTH.field_5074.method_4471();
    }

    public static void _depthFunc(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (n != GlStateManager.DEPTH.field_5075) {
            GlStateManager.DEPTH.field_5075 = n;
            GL11.glDepthFunc((int)n);
        }
    }

    public static void _depthMask(boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (bl != GlStateManager.DEPTH.field_5076) {
            GlStateManager.DEPTH.field_5076 = bl;
            GL11.glDepthMask((boolean)bl);
        }
    }

    public static void _disableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.BLEND.field_5045.method_4469();
    }

    public static void _enableBlend() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.BLEND.field_5045.method_4471();
    }

    public static void _blendFunc(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n != GlStateManager.BLEND.field_5049 || n2 != GlStateManager.BLEND.field_5048) {
            GlStateManager.BLEND.field_5049 = n;
            GlStateManager.BLEND.field_5048 = n2;
            GL11.glBlendFunc((int)n, (int)n2);
        }
    }

    public static void _blendFuncSeparate(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n != GlStateManager.BLEND.field_5049 || n2 != GlStateManager.BLEND.field_5048 || n3 != GlStateManager.BLEND.field_5047 || n4 != GlStateManager.BLEND.field_5046) {
            GlStateManager.BLEND.field_5049 = n;
            GlStateManager.BLEND.field_5048 = n2;
            GlStateManager.BLEND.field_5047 = n3;
            GlStateManager.BLEND.field_5046 = n4;
            GlStateManager.glBlendFuncSeparate(n, n2, n3, n4);
        }
    }

    public static void _blendEquation(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL14.glBlendEquation((int)n);
    }

    public static int glGetProgrami(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetProgrami((int)n, (int)n2);
    }

    public static void glAttachShader(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glAttachShader((int)n, (int)n2);
    }

    public static void glDeleteShader(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glDeleteShader((int)n);
    }

    public static int glCreateShader(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glCreateShader((int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glShaderSource(int n, List<String> list) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : list) {
            stringBuilder.append(string);
        }
        byte[] \u00e2\u02dc\u01922 = stringBuilder.toString().getBytes(Charsets.UTF_8);
        ByteBuffer byteBuffer = MemoryUtil.memAlloc((int)(\u00e2\u02dc\u01922.length + 1));
        byteBuffer.put(\u00e2\u02dc\u01922);
        byteBuffer.put((byte)0);
        byteBuffer.flip();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer pointerBuffer = memoryStack.mallocPointer(1);
            pointerBuffer.put(byteBuffer);
            GL20C.nglShaderSource((int)n, (int)1, (long)pointerBuffer.address0(), (long)0L);
        }
        finally {
            MemoryUtil.memFree((Buffer)byteBuffer);
        }
    }

    public static void glCompileShader(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glCompileShader((int)n);
    }

    public static int glGetShaderi(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetShaderi((int)n, (int)n2);
    }

    public static void _glUseProgram(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUseProgram((int)n);
    }

    public static int glCreateProgram() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glCreateProgram();
    }

    public static void glDeleteProgram(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glDeleteProgram((int)n);
    }

    public static void glLinkProgram(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glLinkProgram((int)n);
    }

    public static int _glGetUniformLocation(int n, CharSequence charSequence) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetUniformLocation((int)n, (CharSequence)charSequence);
    }

    public static void _glUniform1(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform1iv((int)n, (IntBuffer)intBuffer);
    }

    public static void _glUniform1i(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform1i((int)n, (int)n2);
    }

    public static void _glUniform1(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform1fv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void _glUniform2(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform2iv((int)n, (IntBuffer)intBuffer);
    }

    public static void _glUniform2(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform2fv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void _glUniform3(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform3iv((int)n, (IntBuffer)intBuffer);
    }

    public static void _glUniform3(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform3fv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void _glUniform4(int n, IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform4iv((int)n, (IntBuffer)intBuffer);
    }

    public static void _glUniform4(int n, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniform4fv((int)n, (FloatBuffer)floatBuffer);
    }

    public static void _glUniformMatrix2(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniformMatrix2fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public static void _glUniformMatrix3(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniformMatrix3fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public static void _glUniformMatrix4(int n, boolean bl, FloatBuffer floatBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glUniformMatrix4fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
    }

    public static int _glGetAttribLocation(int n, CharSequence charSequence) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetAttribLocation((int)n, (CharSequence)charSequence);
    }

    public static void _glBindAttribLocation(int n, int n2, CharSequence charSequence) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glBindAttribLocation((int)n, (int)n2, (CharSequence)charSequence);
    }

    public static int _glGenBuffers() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL15.glGenBuffers();
    }

    public static int _glGenVertexArrays() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glGenVertexArrays();
    }

    public static void _glBindBuffer(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glBindBuffer((int)n, (int)n2);
    }

    public static void _glBindVertexArray(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBindVertexArray((int)n);
    }

    public static void _glBufferData(int n, ByteBuffer byteBuffer, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glBufferData((int)n, (ByteBuffer)byteBuffer, (int)n2);
    }

    public static void _glBufferData(int n, long l, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glBufferData((int)n, (long)l, (int)n2);
    }

    @Nullable
    public static ByteBuffer _glMapBuffer(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL15.glMapBuffer((int)n, (int)n2);
    }

    public static void _glUnmapBuffer(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL15.glUnmapBuffer((int)n);
    }

    public static void _glDeleteBuffers(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL15.glDeleteBuffers((int)n);
    }

    public static void _glCopyTexSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL20.glCopyTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8);
    }

    public static void _glDeleteVertexArrays(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL30.glDeleteVertexArrays((int)n);
    }

    public static void _glBindFramebuffer(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBindFramebuffer((int)n, (int)n2);
    }

    public static void _glBlitFrameBuffer(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBlitFramebuffer((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (int)n9, (int)n10);
    }

    public static void _glBindRenderbuffer(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glBindRenderbuffer((int)n, (int)n2);
    }

    public static void _glDeleteRenderbuffers(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glDeleteRenderbuffers((int)n);
    }

    public static void _glDeleteFramebuffers(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glDeleteFramebuffers((int)n);
    }

    public static int glGenFramebuffers() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glGenFramebuffers();
    }

    public static int glGenRenderbuffers() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glGenRenderbuffers();
    }

    public static void _glRenderbufferStorage(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static void _glFramebufferRenderbuffer(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static int glCheckFramebufferStatus(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL30.glCheckFramebufferStatus((int)n);
    }

    public static void _glFramebufferTexture2D(int n, int n2, int n3, int n4, int n5) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL30.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
    }

    public static int getBoundFramebuffer() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GlStateManager._getInteger(36006);
    }

    public static void glActiveTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL13.glActiveTexture((int)n);
    }

    public static void glBlendFuncSeparate(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL14.glBlendFuncSeparate((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static String glGetShaderInfoLog(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetShaderInfoLog((int)n, (int)n2);
    }

    public static String glGetProgramInfoLog(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL20.glGetProgramInfoLog((int)n, (int)n2);
    }

    public static void setupLevelDiffuseLighting(class_1160 class_11602, class_1160 class_11603, class_1159 class_11592) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        class_1162 class_11622 = new class_1162(class_11602);
        class_11622.method_22674(class_11592);
        \u00e2\u02dc\u0192 = new class_1162(class_11603);
        \u00e2\u02dc\u0192.method_22674(class_11592);
        RenderSystem.setShaderLights(new class_1160(class_11622), new class_1160(\u00e2\u02dc\u0192));
    }

    public static void setupGuiFlatDiffuseLighting(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        class_1159 class_11592 = new class_1159();
        class_11592.method_22668();
        class_11592.method_22672(class_1159.method_24019(1.0f, -1.0f, 1.0f));
        class_11592.method_22670(class_1160.field_20705.method_23214(-22.5f));
        class_11592.method_22670(class_1160.field_20703.method_23214(135.0f));
        GlStateManager.setupLevelDiffuseLighting(class_11602, class_11603, class_11592);
    }

    public static void setupGui3DDiffuseLighting(class_1160 class_11602, class_1160 class_11603) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        class_1159 class_11592 = new class_1159();
        class_11592.method_22668();
        class_11592.method_22670(class_1160.field_20705.method_23214(62.0f));
        class_11592.method_22670(class_1160.field_20703.method_23214(185.5f));
        class_11592.method_22670(class_1160.field_20705.method_23214(-22.5f));
        class_11592.method_22670(class_1160.field_20703.method_23214(135.0f));
        GlStateManager.setupLevelDiffuseLighting(class_11602, class_11603, class_11592);
    }

    public static void _enableCull() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.CULL.field_5072.method_4471();
    }

    public static void _disableCull() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.CULL.field_5072.method_4469();
    }

    public static void _polygonMode(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glPolygonMode((int)n, (int)n2);
    }

    public static void _enablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.POLY_OFFSET.field_5123.method_4471();
    }

    public static void _disablePolygonOffset() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.POLY_OFFSET.field_5123.method_4469();
    }

    public static void _polygonOffset(float f, float f2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (f != GlStateManager.POLY_OFFSET.field_5124 || f2 != GlStateManager.POLY_OFFSET.field_5122) {
            GlStateManager.POLY_OFFSET.field_5124 = f;
            GlStateManager.POLY_OFFSET.field_5122 = f2;
            GL11.glPolygonOffset((float)f, (float)f2);
        }
    }

    public static void _enableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.COLOR_LOGIC.field_5058.method_4471();
    }

    public static void _disableColorLogicOp() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.COLOR_LOGIC.field_5058.method_4469();
    }

    public static void _logicOp(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n != GlStateManager.COLOR_LOGIC.field_5059) {
            GlStateManager.COLOR_LOGIC.field_5059 = n;
            GL11.glLogicOp((int)n);
        }
    }

    public static void _activeTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (activeTexture != n - 33984) {
            activeTexture = n - 33984;
            GlStateManager.glActiveTexture(n);
        }
    }

    public static void _enableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5166 = true;
    }

    public static void _disableTexture() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5166 = false;
    }

    public static void _texParameter(int n, int n2, float f) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexParameterf((int)n, (int)n2, (float)f);
    }

    public static void _texParameter(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexParameteri((int)n, (int)n2, (int)n3);
    }

    public static int _getTexLevelParameter(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isInInitPhase);
        return GL11.glGetTexLevelParameteri((int)n, (int)n2, (int)n3);
    }

    public static int _genTexture() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL11.glGenTextures();
    }

    public static void _genTextures(int[] nArray) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glGenTextures((int[])nArray);
    }

    public static void _deleteTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glDeleteTextures((int)n);
        for (class_1039 class_10392 : TEXTURES) {
            if (class_10392.field_5167 != n) continue;
            class_10392.field_5167 = -1;
        }
    }

    public static void _deleteTextures(int[] nArray2) {
        int[] nArray2;
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        for (class_1039 class_10392 : TEXTURES) {
            for (int n : nArray2) {
                if (class_10392.field_5167 != n) continue;
                class_10392.field_5167 = -1;
            }
        }
        GL11.glDeleteTextures((int[])nArray2);
    }

    public static void _bindTexture(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        if (n != GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5167) {
            GlStateManager.TEXTURES[GlStateManager.activeTexture].field_5167 = n;
            GL11.glBindTexture((int)3553, (int)n);
        }
    }

    public static int _getTextureId(int n) {
        if (n >= 0 && n < 12 && GlStateManager.TEXTURES[n].field_5166) {
            return GlStateManager.TEXTURES[n].field_5167;
        }
        return 0;
    }

    public static int _getActiveTexture() {
        return activeTexture + 33984;
    }

    public static void _texImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, @Nullable IntBuffer intBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (IntBuffer)intBuffer);
    }

    public static void _texSubImage2D(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glTexSubImage2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (int)n7, (int)n8, (long)l);
    }

    public static void _getTexImage(int n, int n2, int n3, int n4, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glGetTexImage((int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    public static void _viewport(int n, int n2, int n3, int n4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        class_1040.field_5169.field_5172 = n;
        class_1040.field_5169.field_5171 = n2;
        class_1040.field_5169.field_5170 = n3;
        class_1040.field_5169.field_5168 = n4;
        GL11.glViewport((int)n, (int)n2, (int)n3, (int)n4);
    }

    public static void _colorMask(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (bl != GlStateManager.COLOR_MASK.field_5063 || bl2 != GlStateManager.COLOR_MASK.field_5062 || bl3 != GlStateManager.COLOR_MASK.field_5061 || bl4 != GlStateManager.COLOR_MASK.field_5060) {
            GlStateManager.COLOR_MASK.field_5063 = bl;
            GlStateManager.COLOR_MASK.field_5062 = bl2;
            GlStateManager.COLOR_MASK.field_5061 = bl3;
            GlStateManager.COLOR_MASK.field_5060 = bl4;
            GL11.glColorMask((boolean)bl, (boolean)bl2, (boolean)bl3, (boolean)bl4);
        }
    }

    public static void _stencilFunc(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n != GlStateManager.STENCIL.field_5149.field_5148 || n != GlStateManager.STENCIL.field_5149.field_16203 || n != GlStateManager.STENCIL.field_5149.field_5147) {
            GlStateManager.STENCIL.field_5149.field_5148 = n;
            GlStateManager.STENCIL.field_5149.field_16203 = n2;
            GlStateManager.STENCIL.field_5149.field_5147 = n3;
            GL11.glStencilFunc((int)n, (int)n2, (int)n3);
        }
    }

    public static void _stencilMask(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n != GlStateManager.STENCIL.field_5153) {
            GlStateManager.STENCIL.field_5153 = n;
            GL11.glStencilMask((int)n);
        }
    }

    public static void _stencilOp(int n, int n2, int n3) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        if (n != GlStateManager.STENCIL.field_5152 || n2 != GlStateManager.STENCIL.field_5151 || n3 != GlStateManager.STENCIL.field_5150) {
            GlStateManager.STENCIL.field_5152 = n;
            GlStateManager.STENCIL.field_5151 = n2;
            GlStateManager.STENCIL.field_5150 = n3;
            GL11.glStencilOp((int)n, (int)n2, (int)n3);
        }
    }

    public static void _clearDepth(double d) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glClearDepth((double)d);
    }

    public static void _clearColor(float f, float f2, float f3, float f4) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glClearColor((float)f, (float)f2, (float)f3, (float)f4);
    }

    public static void _clearStencil(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glClearStencil((int)n);
    }

    public static void _clear(int n, boolean bl) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glClear((int)n);
        if (bl) {
            GlStateManager._getError();
        }
    }

    public static void _glDrawPixels(int n, int n2, int n3, int n4, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glDrawPixels((int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    public static void _vertexAttribPointer(int n, int n2, int n3, boolean bl, int n4, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glVertexAttribPointer((int)n, (int)n2, (int)n3, (boolean)bl, (int)n4, (long)l);
    }

    public static void _vertexAttribIPointer(int n, int n2, int n3, int n4, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL30.glVertexAttribIPointer((int)n, (int)n2, (int)n3, (int)n4, (long)l);
    }

    public static void _enableVertexAttribArray(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glEnableVertexAttribArray((int)n);
    }

    public static void _disableVertexAttribArray(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL20.glDisableVertexAttribArray((int)n);
    }

    public static void _drawElements(int n, int n2, int n3, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glDrawElements((int)n, (int)n2, (int)n3, (long)l);
    }

    public static void _pixelStore(int n, int n2) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        GL11.glPixelStorei((int)n, (int)n2);
    }

    public static void _readPixels(int n, int n2, int n3, int n4, int n5, int n6, ByteBuffer byteBuffer) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (ByteBuffer)byteBuffer);
    }

    public static void _readPixels(int n, int n2, int n3, int n4, int n5, int n6, long l) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        GL11.glReadPixels((int)n, (int)n2, (int)n3, (int)n4, (int)n5, (int)n6, (long)l);
    }

    public static int _getError() {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL11.glGetError();
    }

    public static String _getString(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThread);
        return GL11.glGetString((int)n);
    }

    public static int _getInteger(int n) {
        RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
        return GL11.glGetInteger((int)n);
    }

    static {
        TEXTURES = (class_1039[])IntStream.range(0, 12).mapToObj(n -> new class_1039()).toArray(class_1039[]::new);
        COLOR_MASK = new class_1022();
    }

    static class class_5518 {
        public final class_1018 field_26840 = new class_1018(3089);

        class_5518() {
        }
    }

    static class class_1018 {
        private final int field_5050;
        private boolean field_5051;

        public class_1018(int n) {
            this.field_5050 = n;
        }

        public void method_4469() {
            this.method_4470(false);
        }

        public void method_4471() {
            this.method_4470(true);
        }

        public void method_4470(boolean bl) {
            RenderSystem.assertThread(RenderSystem::isOnRenderThreadOrInit);
            if (bl != this.field_5051) {
                this.field_5051 = bl;
                if (bl) {
                    GL11.glEnable((int)this.field_5050);
                } else {
                    GL11.glDisable((int)this.field_5050);
                }
            }
        }
    }

    static class class_1026 {
        public final class_1018 field_5074 = new class_1018(2929);
        public boolean field_5076 = true;
        public int field_5075 = 513;

        class_1026() {
        }
    }

    static class class_1017 {
        public final class_1018 field_5045 = new class_1018(3042);
        public int field_5049 = 1;
        public int field_5048 = 0;
        public int field_5047 = 1;
        public int field_5046 = 0;

        class_1017() {
        }
    }

    static class class_1025 {
        public final class_1018 field_5072 = new class_1018(2884);
        public int field_5073 = 1029;

        class_1025() {
        }
    }

    static class class_1031 {
        public final class_1018 field_5123 = new class_1018(32823);
        public final class_1018 field_5121 = new class_1018(10754);
        public float field_5124;
        public float field_5122;

        class_1031() {
        }
    }

    static class class_1021 {
        public final class_1018 field_5058 = new class_1018(3058);
        public int field_5059 = 5379;

        class_1021() {
        }
    }

    static class class_1039 {
        public boolean field_5166;
        public int field_5167;

        class_1039() {
        }
    }

    public static final class class_1040
    extends Enum<class_1040> {
        public static final /* enum */ class_1040 field_5169 = new class_1040();
        protected int field_5172;
        protected int field_5171;
        protected int field_5170;
        protected int field_5168;
        private static final /* synthetic */ class_1040[] field_5173;

        public static class_1040[] values() {
            return (class_1040[])field_5173.clone();
        }

        public static class_1040 valueOf(String string) {
            return Enum.valueOf(class_1040.class, string);
        }

        public static int method_35330() {
            return class_1040.field_5169.field_5172;
        }

        public static int method_35331() {
            return class_1040.field_5169.field_5171;
        }

        public static int method_35332() {
            return class_1040.field_5169.field_5170;
        }

        public static int method_35333() {
            return class_1040.field_5169.field_5168;
        }

        private static /* synthetic */ class_1040[] method_36749() {
            return new class_1040[]{field_5169};
        }

        static {
            field_5173 = class_1040.method_36749();
        }
    }

    static class class_1022 {
        public boolean field_5063 = true;
        public boolean field_5062 = true;
        public boolean field_5061 = true;
        public boolean field_5060 = true;

        class_1022() {
        }
    }

    static class class_1035 {
        public final class_1034 field_5149 = new class_1034();
        public int field_5153 = -1;
        public int field_5152 = 7680;
        public int field_5151 = 7680;
        public int field_5150 = 7680;

        class_1035() {
        }
    }

    static class class_1034 {
        public int field_5148 = 519;
        public int field_16203;
        public int field_5147 = -1;

        class_1034() {
        }
    }

    @class_6177
    public static enum class_4534 {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private class_4534(int n2) {
            this.value = n2;
        }
    }

    @class_6177
    public static enum class_4535 {
        CONSTANT_ALPHA(32771),
        CONSTANT_COLOR(32769),
        DST_ALPHA(772),
        DST_COLOR(774),
        ONE(1),
        ONE_MINUS_CONSTANT_ALPHA(32772),
        ONE_MINUS_CONSTANT_COLOR(32770),
        ONE_MINUS_DST_ALPHA(773),
        ONE_MINUS_DST_COLOR(775),
        ONE_MINUS_SRC_ALPHA(771),
        ONE_MINUS_SRC_COLOR(769),
        SRC_ALPHA(770),
        SRC_ALPHA_SATURATE(776),
        SRC_COLOR(768),
        ZERO(0);

        public final int value;

        private class_4535(int n2) {
            this.value = n2;
        }
    }

    public static final class class_1030
    extends Enum<class_1030> {
        public static final /* enum */ class_1030 field_5120 = new class_1030(5377);
        public static final /* enum */ class_1030 field_5112 = new class_1030(5380);
        public static final /* enum */ class_1030 field_5117 = new class_1030(5378);
        public static final /* enum */ class_1030 field_5103 = new class_1030(5376);
        public static final /* enum */ class_1030 field_5118 = new class_1030(5379);
        public static final /* enum */ class_1030 field_5113 = new class_1030(5388);
        public static final /* enum */ class_1030 field_5119 = new class_1030(5385);
        public static final /* enum */ class_1030 field_5109 = new class_1030(5386);
        public static final /* enum */ class_1030 field_5114 = new class_1030(5390);
        public static final /* enum */ class_1030 field_5115 = new class_1030(5381);
        public static final /* enum */ class_1030 field_5104 = new class_1030(5384);
        public static final /* enum */ class_1030 field_5105 = new class_1030(5383);
        public static final /* enum */ class_1030 field_5116 = new class_1030(5389);
        public static final /* enum */ class_1030 field_5110 = new class_1030(5387);
        public static final /* enum */ class_1030 field_5107 = new class_1030(5391);
        public static final /* enum */ class_1030 field_5111 = new class_1030(5382);
        public final int field_5108;
        private static final /* synthetic */ class_1030[] field_5106;

        public static class_1030[] values() {
            return (class_1030[])field_5106.clone();
        }

        public static class_1030 valueOf(String string) {
            return Enum.valueOf(class_1030.class, string);
        }

        private class_1030(int n2) {
            this.field_5108 = n2;
        }

        private static /* synthetic */ class_1030[] method_36748() {
            return new class_1030[]{field_5120, field_5112, field_5117, field_5103, field_5118, field_5113, field_5119, field_5109, field_5114, field_5115, field_5104, field_5105, field_5116, field_5110, field_5107, field_5111};
        }

        static {
            field_5106 = class_1030.method_36748();
        }
    }
}

