#include <Arduino.h>

#define DCSBIOS_ESP32_WIFI
#define DCSBIOS_ESP32_WIFI_NEOPIXEL 48
#define DCSBIOS_ESP32_WIFI_SSID "SWIC"
#define DCSBIOS_ESP32_WIFI_PASSWORD "sW-6CxFJXc.pwG8nsW3!"
#define DCSBIOS_ESP32_WIFI_ID "test-slave"
#include <DcsBios.h>

void setup() {
  DcsBios::setup();
}

unsigned int count = 0;
unsigned int state = 0;

void loop() {
  DcsBios::loop();
  
  count++;
  if (count >= 100000) {
    count = 0;
    state = !state;
    sendDcsBiosMessage("UFC_MASTER_CAUTION", state ? "1" : "0");
  }
}

void onMasterCautionChange(unsigned int newValue) {
  printf("Master caution: %d\n", newValue);
  DcsBios::wifiSlave.led.setPixelColor(0, DcsBios::wifiSlave.led.Color(4*newValue, 4*newValue, 0));
  DcsBios::wifiSlave.led.show();
}
DcsBios::IntegerBuffer masterCautionBuffer(0x1012, 0x0800, 11, onMasterCautionChange);

void onCduLine0Change(char* newValue) {
  printf("CDU line 0: %s\n", newValue);
}
DcsBios::StringBuffer<24> cduLine0Buffer(0x11c0, onCduLine0Change);