/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3302;
import net.minecraft.class_3694;
import net.minecraft.class_3695;
import net.minecraft.class_378;
import net.optifine.Config;
import net.optifine.reflect.Reflector;
import net.optifine.util.PropertiesOrdered;

public class FontUtils {
    public static Properties readFontProperties(class_2960 locationFontTexture) {
        String fontFileName = locationFontTexture.method_12832();
        PropertiesOrdered props = new PropertiesOrdered();
        String suffix = ".png";
        if (!fontFileName.endsWith(suffix)) {
            return props;
        }
        String fileName = fontFileName.substring(0, fontFileName.length() - suffix.length()) + ".properties";
        try {
            class_2960 locProp = new class_2960(locationFontTexture.method_12836(), fileName);
            InputStream in = Config.getResourceStream(Config.getResourceManager(), locProp);
            if (in == null) {
                return props;
            }
            Config.log("Loading " + fileName);
            props.load(in);
            in.close();
        }
        catch (FileNotFoundException locProp) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return props;
    }

    public static Int2ObjectMap<Float> readCustomCharWidths(Properties props) {
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        Set<Object> keySet = props.keySet();
        for (String string : keySet) {
            String value;
            float width;
            String numStr;
            int num;
            String prefix;
            if (!string.startsWith(prefix = "width.") || (num = Config.parseInt(numStr = string.substring(prefix.length()), -1)) < 0 || !((width = Config.parseFloat(value = props.getProperty(string), -1.0f)) >= 0.0f)) continue;
            char ch = (char)num;
            map.put((int)ch, (Object)new Float(width));
        }
        return map;
    }

    public static float readFloat(Properties props, String key, float defOffset) {
        String str = props.getProperty(key);
        if (str == null) {
            return defOffset;
        }
        float offset = Config.parseFloat(str, Float.MIN_VALUE);
        if (offset == Float.MIN_VALUE) {
            Config.warn("Invalid value for " + key + ": " + str);
            return defOffset;
        }
        return offset;
    }

    public static boolean readBoolean(Properties props, String key, boolean defVal) {
        String str = props.getProperty(key);
        if (str == null) {
            return defVal;
        }
        String strLow = str.toLowerCase().trim();
        if (strLow.equals("true") || strLow.equals("on")) {
            return true;
        }
        if (strLow.equals("false") || strLow.equals("off")) {
            return false;
        }
        Config.warn("Invalid value for " + key + ": " + str);
        return defVal;
    }

    public static class_2960 getHdFontLocation(class_2960 fontLoc) {
        if (!Config.isCustomFonts()) {
            return fontLoc;
        }
        if (fontLoc == null) {
            return fontLoc;
        }
        if (!Config.isMinecraftThread()) {
            return fontLoc;
        }
        String fontName = fontLoc.method_12832();
        String texturesStr = "textures/";
        String optifineStr = "optifine/";
        if (!fontName.startsWith(texturesStr)) {
            return fontLoc;
        }
        fontName = fontName.substring(texturesStr.length());
        fontName = optifineStr + fontName;
        class_2960 fontLocHD = new class_2960(fontLoc.method_12836(), fontName);
        if (Config.hasResource(Config.getResourceManager(), fontLocHD)) {
            return fontLocHD;
        }
        return fontLoc;
    }

    public static void reloadFonts() {
        class_3302.class_4045 stage = new class_3302.class_4045(){

            public <T> CompletableFuture<T> method_18352(T x) {
                return CompletableFuture.completedFuture(x);
            }
        };
        Executor ex = class_156.method_18349();
        class_310 mc = class_310.method_1551();
        class_378 frm = (class_378)Reflector.getFieldValue(mc, Reflector.Minecraft_fontResourceManager);
        if (frm == null) {
            return;
        }
        frm.method_18627().method_25931(stage, Config.getResourceManager(), (class_3695)class_3694.field_16280, (class_3695)class_3694.field_16280, ex, (Executor)mc);
    }
}

