/*
 * Decompiled with CFR 0.152.
 */
package net.optifine.util;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import net.minecraft.class_287;
import net.minecraft.class_293;
import net.minecraft.class_296;
import net.minecraft.class_311;

public class BufferUtil {
    public static String getBufferHex(class_287 bb) {
        class_293.class_5596 drawMode = bb.getDrawMode();
        String primitiveName = "";
        int vertexPerPrimitive = -1;
        if (drawMode == class_293.class_5596.field_27382) {
            primitiveName = "quad";
            vertexPerPrimitive = 4;
        } else if (drawMode == class_293.class_5596.field_27379) {
            primitiveName = "triangle";
            vertexPerPrimitive = 3;
        } else {
            return "Invalid draw mode: " + drawMode;
        }
        StringBuffer sb = new StringBuffer();
        int vertexCount = bb.getVertexCount();
        for (int v = 0; v < vertexCount; ++v) {
            if (v % vertexPerPrimitive == 0) {
                sb.append(primitiveName + " " + v / vertexPerPrimitive + "\n");
            }
            String vs = BufferUtil.getVertexHex(v, bb);
            sb.append(vs);
            sb.append("\n");
        }
        return sb.toString();
    }

    private static String getVertexHex(int vertex, class_287 bb) {
        StringBuffer sb = new StringBuffer();
        ByteBuffer buf = bb.getByteBuffer();
        class_293 vf = bb.getVertexFormat();
        int pos = bb.getStartPosition() + vertex * vf.method_1362();
        for (class_296 vfe : vf.method_1357()) {
            if (vfe.getElementCount() > 0) {
                sb.append("(");
            }
            for (int i = 0; i < vfe.getElementCount(); ++i) {
                if (i > 0) {
                    sb.append(" ");
                }
                switch (vfe.method_1386()) {
                    case field_1623: {
                        sb.append(buf.getFloat(pos));
                        break;
                    }
                    case field_1624: 
                    case field_1621: {
                        sb.append(buf.get(pos));
                        break;
                    }
                    case field_1622: 
                    case field_1625: {
                        sb.append(buf.getShort(pos));
                        break;
                    }
                    case field_1619: 
                    case field_1617: {
                        sb.append(buf.getShort(pos));
                        break;
                    }
                    default: {
                        sb.append("??");
                    }
                }
                pos += vfe.method_1386().method_1391();
            }
            if (vfe.getElementCount() <= 0) continue;
            sb.append(")");
        }
        return sb.toString();
    }

    public static String getBufferString(IntBuffer buf) {
        if (buf == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer();
        sb.append("(pos=" + buf.position() + " lim=" + buf.limit() + " cap=" + buf.capacity() + ")");
        sb.append("[");
        int len = Math.min(buf.limit(), 1024);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(buf.get(i));
        }
        sb.append("]");
        return sb.toString();
    }

    public static int[] toArray(IntBuffer buf) {
        int[] arr = new int[buf.limit()];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = buf.get(i);
        }
        return arr;
    }

    public static FloatBuffer createDirectFloatBuffer(int capacity) {
        return class_311.method_1596((int)(capacity << 2)).asFloatBuffer();
    }

    public static void fill(FloatBuffer buf, float val) {
        buf.clear();
        for (int i = 0; i < buf.capacity(); ++i) {
            buf.put(i, val);
        }
        buf.clear();
    }
}

