/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1088;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1812;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_583;
import net.minecraft.class_801;
import net.minecraft.class_918;
import net.optifine.Config;
import net.optifine.CustomItemProperties;
import net.optifine.CustomItemsComparator;
import net.optifine.config.NbtTagValue;
import net.optifine.shaders.Shaders;
import net.optifine.util.EnchantmentUtils;
import net.optifine.util.PropertiesOrdered;
import net.optifine.util.ResUtils;
import net.optifine.util.StrUtils;

public class CustomItems {
    private static CustomItemProperties[][] itemProperties = null;
    private static CustomItemProperties[][] enchantmentProperties = null;
    private static Map mapPotionIds = null;
    private static class_801 itemModelGenerator = new class_801();
    private static boolean useGlint = true;
    private static boolean renderOffHand = false;
    public static final int MASK_POTION_SPLASH = 16384;
    public static final int MASK_POTION_NAME = 63;
    public static final int MASK_POTION_EXTENDED = 64;
    public static final String KEY_TEXTURE_OVERLAY = "texture.potion_overlay";
    public static final String KEY_TEXTURE_SPLASH = "texture.potion_bottle_splash";
    public static final String KEY_TEXTURE_DRINKABLE = "texture.potion_bottle_drinkable";
    public static final String DEFAULT_TEXTURE_OVERLAY = "item/potion_overlay";
    public static final String DEFAULT_TEXTURE_SPLASH = "item/potion_bottle_splash";
    public static final String DEFAULT_TEXTURE_DRINKABLE = "item/potion_bottle_drinkable";
    private static final int[][] EMPTY_INT2_ARRAY = new int[0][];
    private static final Map<String, Integer> mapPotionDamages = CustomItems.makeMapPotionDamages();
    private static final String TYPE_POTION_NORMAL = "normal";
    private static final String TYPE_POTION_SPLASH = "splash";
    private static final String TYPE_POTION_LINGER = "linger";

    public static void update() {
        itemProperties = null;
        enchantmentProperties = null;
        useGlint = true;
        if (!Config.isCustomItems()) {
            return;
        }
        CustomItems.readCitProperties("optifine/cit.properties");
        class_3262[] rps = Config.getResourcePacks();
        for (int i = rps.length - 1; i >= 0; --i) {
            class_3262 rp = rps[i];
            CustomItems.update(rp);
        }
        CustomItems.update(Config.getDefaultResourcePack());
        if (itemProperties.length <= 0) {
            itemProperties = null;
        }
        if (enchantmentProperties.length <= 0) {
            enchantmentProperties = null;
        }
    }

    private static void readCitProperties(String fileName) {
        try {
            class_2960 loc = new class_2960(fileName);
            InputStream in = Config.getResourceStream(loc);
            if (in == null) {
                return;
            }
            Config.dbg("CustomItems: Loading " + fileName);
            PropertiesOrdered props = new PropertiesOrdered();
            props.load(in);
            in.close();
            useGlint = Config.parseBoolean(props.getProperty("useGlint"), true);
        }
        catch (FileNotFoundException e) {
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void update(class_3262 rp) {
        CustomItemProperties[] cips;
        int i;
        Object[] names = ResUtils.collectFiles(rp, "optifine/cit/", ".properties", null);
        Map<String, CustomItemProperties> mapAutoProperties = CustomItems.makeAutoImageProperties(rp);
        if (mapAutoProperties.size() > 0) {
            Set<String> keySetAuto = mapAutoProperties.keySet();
            Object[] keysAuto = keySetAuto.toArray(new String[keySetAuto.size()]);
            names = (String[])Config.addObjectsToArray(names, keysAuto);
        }
        Arrays.sort(names);
        List<List<CustomItemProperties>> itemList = CustomItems.makePropertyList(itemProperties);
        List<List<CustomItemProperties>> enchantmentList = CustomItems.makePropertyList(enchantmentProperties);
        for (int i2 = 0; i2 < names.length; ++i2) {
            Object name = names[i2];
            Config.dbg("CustomItems: " + (String)name);
            try {
                CustomItemProperties cip = null;
                if (mapAutoProperties.containsKey(name)) {
                    cip = mapAutoProperties.get(name);
                }
                if (cip == null) {
                    class_2960 locFile = new class_2960((String)name);
                    InputStream in = rp.method_14405(class_3264.field_14188, locFile);
                    if (in == null) {
                        Config.warn("CustomItems file not found: " + (String)name);
                        continue;
                    }
                    PropertiesOrdered props = new PropertiesOrdered();
                    props.load(in);
                    in.close();
                    cip = new CustomItemProperties(props, (String)name);
                }
                if (!cip.isValid((String)name)) continue;
                CustomItems.addToItemList(cip, itemList);
                CustomItems.addToEnchantmentList(cip, enchantmentList);
                continue;
            }
            catch (FileNotFoundException e) {
                Config.warn("CustomItems file not found: " + (String)name);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        itemProperties = CustomItems.propertyListToArray(itemList);
        enchantmentProperties = CustomItems.propertyListToArray(enchantmentList);
        Comparator comp = CustomItems.getPropertiesComparator();
        for (i = 0; i < itemProperties.length; ++i) {
            cips = itemProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
        for (i = 0; i < enchantmentProperties.length; ++i) {
            cips = enchantmentProperties[i];
            if (cips == null) continue;
            Arrays.sort(cips, comp);
        }
    }

    private static Comparator getPropertiesComparator() {
        Comparator comp = new Comparator(){

            public int compare(Object o1, Object o2) {
                CustomItemProperties cip1 = (CustomItemProperties)o1;
                CustomItemProperties cip2 = (CustomItemProperties)o2;
                if (cip1.layer != cip2.layer) {
                    return cip1.layer - cip2.layer;
                }
                if (cip1.weight != cip2.weight) {
                    return cip2.weight - cip1.weight;
                }
                if (!cip1.basePath.equals(cip2.basePath)) {
                    return cip1.basePath.compareTo(cip2.basePath);
                }
                return cip1.name.compareTo(cip2.name);
            }
        };
        return comp;
    }

    public static void updateIcons(class_1059 textureMap) {
        List<CustomItemProperties> cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.updateIcons(textureMap);
        }
    }

    public static void refreshIcons(class_1059 textureMap) {
        List<CustomItemProperties> cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.refreshIcons(textureMap);
        }
    }

    public static void loadModels(class_1088 modelBakery) {
        List<CustomItemProperties> cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            cip.loadModels(modelBakery);
        }
    }

    public static void updateModels() {
        List<CustomItemProperties> cips = CustomItems.getAllProperties();
        for (CustomItemProperties cip : cips) {
            if (cip.type != 1) continue;
            class_1059 textureMap = Config.getTextureMap();
            cip.updateModelTexture(textureMap, itemModelGenerator);
            cip.updateModelsFull();
        }
    }

    private static List<CustomItemProperties> getAllProperties() {
        ArrayList<CustomItemProperties> list = new ArrayList<CustomItemProperties>();
        CustomItems.addAll(itemProperties, list);
        CustomItems.addAll(enchantmentProperties, list);
        return list;
    }

    private static void addAll(CustomItemProperties[][] cipsArr, List<CustomItemProperties> list) {
        if (cipsArr == null) {
            return;
        }
        for (int i = 0; i < cipsArr.length; ++i) {
            CustomItemProperties[] cips = cipsArr[i];
            if (cips == null) continue;
            for (int k = 0; k < cips.length; ++k) {
                CustomItemProperties cip = cips[k];
                if (cip == null) continue;
                list.add(cip);
            }
        }
    }

    private static Map<String, CustomItemProperties> makeAutoImageProperties(class_3262 rp) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        map.putAll(CustomItems.makePotionImageProperties(rp, TYPE_POTION_NORMAL, class_2378.field_11142.method_10221(class_1802.field_8574)));
        map.putAll(CustomItems.makePotionImageProperties(rp, TYPE_POTION_SPLASH, class_2378.field_11142.method_10221(class_1802.field_8436)));
        map.putAll(CustomItems.makePotionImageProperties(rp, TYPE_POTION_LINGER, class_2378.field_11142.method_10221(class_1802.field_8150)));
        return map;
    }

    private static Map<String, CustomItemProperties> makePotionImageProperties(class_3262 rp, String type, class_2960 itemId) {
        HashMap<String, CustomItemProperties> map = new HashMap<String, CustomItemProperties>();
        String typePrefix = type + "/";
        String[] prefixes = new String[]{"optifine/cit/potion/" + typePrefix, "optifine/cit/Potion/" + typePrefix};
        String[] suffixes = new String[]{".png"};
        String[] names = ResUtils.collectFiles(rp, prefixes, suffixes);
        for (int i = 0; i < names.length; ++i) {
            String path;
            String name = path = names[i];
            Properties props = CustomItems.makePotionProperties(name = StrUtils.removePrefixSuffix(name, prefixes, suffixes), type, itemId, path);
            if (props == null) continue;
            String pathProp = StrUtils.removeSuffix(path, suffixes) + ".properties";
            CustomItemProperties cip = new CustomItemProperties(props, pathProp);
            map.put(pathProp, cip);
        }
        return map;
    }

    private static Properties makePotionProperties(String name, String type, class_2960 itemId, String path) {
        if (StrUtils.endsWith(name, new String[]{"_n", "_s"})) {
            return null;
        }
        if (name.equals("empty") && type.equals(TYPE_POTION_NORMAL)) {
            itemId = class_2378.field_11142.method_10221(class_1802.field_8469);
            PropertiesOrdered props = new PropertiesOrdered();
            ((Properties)props).put("type", "item");
            ((Properties)props).put("items", itemId.toString());
            return props;
        }
        class_2960 potionItemId = itemId;
        int[] damages = (int[])CustomItems.getMapPotionIds().get(name);
        if (damages == null) {
            Config.warn("Potion not found for image: " + path);
            return null;
        }
        StringBuffer bufDamage = new StringBuffer();
        for (int i = 0; i < damages.length; ++i) {
            int damage = damages[i];
            if (type.equals(TYPE_POTION_SPLASH)) {
                damage |= 0x4000;
            }
            if (i > 0) {
                bufDamage.append(" ");
            }
            bufDamage.append(damage);
        }
        int damageMask = 16447;
        if (name.equals("water") || name.equals("mundane")) {
            damageMask |= 0x40;
        }
        PropertiesOrdered props = new PropertiesOrdered();
        ((Properties)props).put("type", "item");
        ((Properties)props).put("items", potionItemId.toString());
        ((Properties)props).put("damage", bufDamage.toString());
        ((Properties)props).put("damageMask", "" + damageMask);
        if (type.equals(TYPE_POTION_SPLASH)) {
            ((Properties)props).put(KEY_TEXTURE_SPLASH, name);
        } else {
            ((Properties)props).put(KEY_TEXTURE_DRINKABLE, name);
        }
        return props;
    }

    private static Map getMapPotionIds() {
        if (mapPotionIds == null) {
            mapPotionIds = new LinkedHashMap();
            mapPotionIds.put("water", CustomItems.getPotionId(0, 0));
            mapPotionIds.put("awkward", CustomItems.getPotionId(0, 1));
            mapPotionIds.put("thick", CustomItems.getPotionId(0, 2));
            mapPotionIds.put("potent", CustomItems.getPotionId(0, 3));
            mapPotionIds.put("regeneration", CustomItems.getPotionIds(1));
            mapPotionIds.put("movespeed", CustomItems.getPotionIds(2));
            mapPotionIds.put("fireresistance", CustomItems.getPotionIds(3));
            mapPotionIds.put("poison", CustomItems.getPotionIds(4));
            mapPotionIds.put("heal", CustomItems.getPotionIds(5));
            mapPotionIds.put("nightvision", CustomItems.getPotionIds(6));
            mapPotionIds.put("clear", CustomItems.getPotionId(7, 0));
            mapPotionIds.put("bungling", CustomItems.getPotionId(7, 1));
            mapPotionIds.put("charming", CustomItems.getPotionId(7, 2));
            mapPotionIds.put("rank", CustomItems.getPotionId(7, 3));
            mapPotionIds.put("weakness", CustomItems.getPotionIds(8));
            mapPotionIds.put("damageboost", CustomItems.getPotionIds(9));
            mapPotionIds.put("moveslowdown", CustomItems.getPotionIds(10));
            mapPotionIds.put("leaping", CustomItems.getPotionIds(11));
            mapPotionIds.put("harm", CustomItems.getPotionIds(12));
            mapPotionIds.put("waterbreathing", CustomItems.getPotionIds(13));
            mapPotionIds.put("invisibility", CustomItems.getPotionIds(14));
            mapPotionIds.put("thin", CustomItems.getPotionId(15, 0));
            mapPotionIds.put("debonair", CustomItems.getPotionId(15, 1));
            mapPotionIds.put("sparkling", CustomItems.getPotionId(15, 2));
            mapPotionIds.put("stinky", CustomItems.getPotionId(15, 3));
            mapPotionIds.put("mundane", CustomItems.getPotionId(0, 4));
            mapPotionIds.put("speed", mapPotionIds.get("movespeed"));
            mapPotionIds.put("fire_resistance", mapPotionIds.get("fireresistance"));
            mapPotionIds.put("instant_health", mapPotionIds.get("heal"));
            mapPotionIds.put("night_vision", mapPotionIds.get("nightvision"));
            mapPotionIds.put("strength", mapPotionIds.get("damageboost"));
            mapPotionIds.put("slowness", mapPotionIds.get("moveslowdown"));
            mapPotionIds.put("instant_damage", mapPotionIds.get("harm"));
            mapPotionIds.put("water_breathing", mapPotionIds.get("waterbreathing"));
        }
        return mapPotionIds;
    }

    private static int[] getPotionIds(int baseId) {
        return new int[]{baseId, baseId + 16, baseId + 32, baseId + 48};
    }

    private static int[] getPotionId(int baseId, int subId) {
        return new int[]{baseId + subId * 16};
    }

    private static int getPotionNameDamage(String name) {
        String fullName = "effect." + name;
        Set<class_2960> keys = class_2378.field_11159.method_10235();
        for (class_2960 rl : keys) {
            class_1291 potion;
            String potionName;
            if (!class_2378.field_11159.method_10250(rl) || !fullName.equals(potionName = (potion = class_2378.field_11159.method_10223(rl)).method_5567())) continue;
            return class_1291.method_5554(potion);
        }
        return -1;
    }

    private static List<List<CustomItemProperties>> makePropertyList(CustomItemProperties[][] propsArr) {
        ArrayList<List<CustomItemProperties>> list = new ArrayList<List<CustomItemProperties>>();
        if (propsArr != null) {
            for (int i = 0; i < propsArr.length; ++i) {
                CustomItemProperties[] props = propsArr[i];
                ArrayList<CustomItemProperties> propList = null;
                if (props != null) {
                    propList = new ArrayList<CustomItemProperties>(Arrays.asList(props));
                }
                list.add(propList);
            }
        }
        return list;
    }

    private static CustomItemProperties[][] propertyListToArray(List list) {
        CustomItemProperties[][] propArr = new CustomItemProperties[list.size()][];
        for (int i = 0; i < list.size(); ++i) {
            List subList = (List)list.get(i);
            if (subList == null) continue;
            CustomItemProperties[] subArr = subList.toArray(new CustomItemProperties[subList.size()]);
            Arrays.sort(subArr, new CustomItemsComparator());
            propArr[i] = subArr;
        }
        return propArr;
    }

    private static void addToItemList(CustomItemProperties cp, List<List<CustomItemProperties>> itemList) {
        if (cp.items == null) {
            return;
        }
        for (int i = 0; i < cp.items.length; ++i) {
            int itemId = cp.items[i];
            if (itemId <= 0) {
                Config.warn("Invalid item ID: " + itemId);
                continue;
            }
            CustomItems.addToList(cp, itemList, itemId);
        }
    }

    private static void addToEnchantmentList(CustomItemProperties cp, List<List<CustomItemProperties>> enchantmentList) {
        if (cp.type != 2) {
            return;
        }
        if (cp.enchantmentIds == null) {
            return;
        }
        int countIds = CustomItems.getMaxEnchantmentId() + 1;
        for (int i = 0; i < countIds; ++i) {
            int id = i;
            if (!Config.equalsOne(id, cp.enchantmentIds)) continue;
            CustomItems.addToList(cp, enchantmentList, id);
        }
    }

    private static int getMaxEnchantmentId() {
        int maxId = 0;
        class_1887 enchantment;
        while ((enchantment = (class_1887)class_2378.field_11160.method_10200(maxId)) != null) {
            ++maxId;
        }
        return maxId;
    }

    private static void addToList(CustomItemProperties cp, List<List<CustomItemProperties>> list, int id) {
        while (id >= list.size()) {
            list.add(null);
        }
        List<CustomItemProperties> subList = list.get(id);
        if (subList == null) {
            subList = new ArrayList<CustomItemProperties>();
            list.set(id, subList);
        }
        subList.add(cp);
    }

    public static class_1087 getCustomItemModel(class_1799 itemStack, class_1087 model, class_2960 modelLocation, boolean fullModel) {
        if (!fullModel && model.method_4712()) {
            return model;
        }
        if (itemProperties == null) {
            return model;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 1);
        if (props == null) {
            return model;
        }
        class_1087 customModel = props.getBakedModel(modelLocation, fullModel);
        if (customModel != null) {
            return customModel;
        }
        return model;
    }

    public static class_2960 getCustomArmorTexture(class_1799 itemStack, class_1304 slot, String overlay, class_2960 locArmor) {
        if (itemProperties == null) {
            return locArmor;
        }
        class_2960 loc = CustomItems.getCustomArmorLocation(itemStack, slot, overlay);
        if (loc == null) {
            return locArmor;
        }
        return loc;
    }

    private static class_2960 getCustomArmorLocation(class_1799 itemStack, class_1304 slot, String overlay) {
        String key;
        class_2960 loc;
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 3);
        if (props == null) {
            return null;
        }
        if (props.mapTextureLocations == null) {
            return props.textureLocation;
        }
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof class_1738)) {
            return null;
        }
        class_1738 itemArmor = (class_1738)item;
        String material = itemArmor.method_7686().method_7694();
        int layer = slot == class_1304.field_6172 ? 2 : 1;
        StringBuffer sb = new StringBuffer();
        sb.append("texture.");
        sb.append(material);
        sb.append("_layer_");
        sb.append(layer);
        if (overlay != null) {
            sb.append("_");
            sb.append(overlay);
        }
        if ((loc = (class_2960)props.mapTextureLocations.get(key = sb.toString())) == null) {
            return props.textureLocation;
        }
        return loc;
    }

    public static class_2960 getCustomElytraTexture(class_1799 itemStack, class_2960 locElytra) {
        if (itemProperties == null) {
            return locElytra;
        }
        CustomItemProperties props = CustomItems.getCustomItemProperties(itemStack, 4);
        if (props == null) {
            return locElytra;
        }
        if (props.textureLocation == null) {
            return locElytra;
        }
        return props.textureLocation;
    }

    private static CustomItemProperties getCustomItemProperties(class_1799 itemStack, int type) {
        CustomItemProperties[] cips;
        CustomItemProperties[][] propertiesLocal = itemProperties;
        if (propertiesLocal == null) {
            return null;
        }
        if (itemStack == null) {
            return null;
        }
        class_1792 item = itemStack.method_7909();
        int itemId = class_1792.method_7880(item);
        if (itemId >= 0 && itemId < propertiesLocal.length && (cips = propertiesLocal[itemId]) != null) {
            for (int i = 0; i < cips.length; ++i) {
                CustomItemProperties cip = cips[i];
                if (cip.type != type || !CustomItems.matchesProperties(cip, itemStack, null)) continue;
                return cip;
            }
        }
        return null;
    }

    private static boolean matchesProperties(CustomItemProperties cip, class_1799 itemStack, int[][] enchantmentIdLevels) {
        int i;
        class_1792 item = itemStack.method_7909();
        if (cip.damage != null) {
            int damage = CustomItems.getItemStackDamage(itemStack);
            if (damage < 0) {
                return false;
            }
            if (cip.damageMask != 0) {
                damage &= cip.damageMask;
            }
            if (cip.damagePercent) {
                int damageMax = item.method_7841();
                damage = (int)((double)(damage * 100) / (double)damageMax);
            }
            if (!cip.damage.isInRange(damage)) {
                return false;
            }
        }
        if (cip.stackSize != null && !cip.stackSize.isInRange(itemStack.method_7947())) {
            return false;
        }
        int[][] idLevels = enchantmentIdLevels;
        if (cip.enchantmentIds != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean idMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int id = idLevels[i][0];
                if (!Config.equalsOne(id, cip.enchantmentIds)) continue;
                idMatch = true;
                break;
            }
            if (!idMatch) {
                return false;
            }
        }
        if (cip.enchantmentLevels != null) {
            if (idLevels == null) {
                idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
            }
            boolean levelMatch = false;
            for (i = 0; i < idLevels.length; ++i) {
                int level = idLevels[i][1];
                if (!cip.enchantmentLevels.isInRange(level)) continue;
                levelMatch = true;
                break;
            }
            if (!levelMatch) {
                return false;
            }
        }
        if (cip.nbtTagValues != null) {
            class_2487 nbt = itemStack.method_7969();
            for (i = 0; i < cip.nbtTagValues.length; ++i) {
                NbtTagValue ntv = cip.nbtTagValues[i];
                if (ntv.matches(nbt)) continue;
                return false;
            }
        }
        if (cip.hand != 0) {
            if (cip.hand == 1 && renderOffHand) {
                return false;
            }
            if (cip.hand == 2 && !renderOffHand) {
                return false;
            }
        }
        return true;
    }

    private static int getItemStackDamage(class_1799 itemStack) {
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1812) {
            return CustomItems.getPotionDamage(itemStack);
        }
        return itemStack.method_7919();
    }

    private static int getPotionDamage(class_1799 itemStack) {
        class_2487 nbt = itemStack.method_7969();
        if (nbt == null) {
            return 0;
        }
        String name = nbt.method_10558("Potion");
        if (name == null || name.equals("")) {
            return 0;
        }
        Integer value = mapPotionDamages.get(name);
        if (value == null) {
            return -1;
        }
        int val = value;
        if (itemStack.method_7909() == class_1802.field_8436) {
            val |= 0x4000;
        }
        return val;
    }

    private static Map<String, Integer> makeMapPotionDamages() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        CustomItems.addPotion("water", 0, false, map);
        CustomItems.addPotion("awkward", 16, false, map);
        CustomItems.addPotion("thick", 32, false, map);
        CustomItems.addPotion("mundane", 64, false, map);
        CustomItems.addPotion("regeneration", 1, true, map);
        CustomItems.addPotion("swiftness", 2, true, map);
        CustomItems.addPotion("fire_resistance", 3, true, map);
        CustomItems.addPotion("poison", 4, true, map);
        CustomItems.addPotion("healing", 5, true, map);
        CustomItems.addPotion("night_vision", 6, true, map);
        CustomItems.addPotion("weakness", 8, true, map);
        CustomItems.addPotion("strength", 9, true, map);
        CustomItems.addPotion("slowness", 10, true, map);
        CustomItems.addPotion("leaping", 11, true, map);
        CustomItems.addPotion("harming", 12, true, map);
        CustomItems.addPotion("water_breathing", 13, true, map);
        CustomItems.addPotion("invisibility", 14, true, map);
        return map;
    }

    private static void addPotion(String name, int value, boolean extended, Map<String, Integer> map) {
        if (extended) {
            value |= 0x2000;
        }
        map.put("minecraft:" + name, value);
        if (extended) {
            int valueStrong = value | 0x20;
            map.put("minecraft:strong_" + name, valueStrong);
            int valueLong = value | 0x40;
            map.put("minecraft:long_" + name, valueLong);
        }
    }

    private static int[][] getEnchantmentIdLevels(class_1799 itemStack) {
        class_2499 nbt;
        class_2499 class_24992;
        class_1792 item = itemStack.method_7909();
        if (item == class_1802.field_8598) {
            class_1772 cfr_ignored_0 = (class_1772)class_1802.field_8598;
            class_24992 = class_1772.method_7806(itemStack);
        } else {
            class_24992 = nbt = itemStack.method_7921();
        }
        if (nbt == null || nbt.size() <= 0) {
            return EMPTY_INT2_ARRAY;
        }
        int[][] arr = new int[nbt.size()][2];
        for (int i = 0; i < nbt.size(); ++i) {
            int id;
            class_2487 tag = nbt.method_10602(i);
            String idStr = tag.method_10558("id");
            int lvl = tag.method_10550("lvl");
            class_1887 en = EnchantmentUtils.getEnchantment(idStr);
            if (en == null) continue;
            arr[i][0] = id = class_2378.field_11160.method_10206(en);
            arr[i][1] = lvl;
        }
        return arr;
    }

    public static boolean renderCustomEffect(class_918 renderItem, class_1799 itemStack, class_1087 model) {
        CustomItemProperties[][] propertiesLocal = enchantmentProperties;
        if (propertiesLocal == null) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        Object layersRendered = null;
        boolean rendered = false;
        return rendered;
    }

    public static boolean renderCustomArmorEffect(class_1309 entity, class_1799 itemStack, class_583 model, float limbSwing, float prevLimbSwing, float partialTicks, float timeLimbSwing, float yaw, float pitch, float scale) {
        CustomItemProperties[][] propertiesLocal = enchantmentProperties;
        if (propertiesLocal == null) {
            return false;
        }
        if (Config.isShaders() && Shaders.isShadowPass) {
            return false;
        }
        if (itemStack == null) {
            return false;
        }
        int[][] idLevels = CustomItems.getEnchantmentIdLevels(itemStack);
        if (idLevels.length <= 0) {
            return false;
        }
        Object layersRendered = null;
        boolean rendered = false;
        return rendered;
    }

    public static boolean isUseGlint() {
        return useGlint;
    }

    public static void setRenderOffHand(boolean renderOffHand) {
        CustomItems.renderOffHand = renderOffHand;
    }
}

