/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;

public class ChunkPos {
    public static final long f_45577_ = ChunkPos.m_45589_(1875016, 1875016);
    private static final long f_305421_ = 32L;
    private static final long f_305422_ = 0xFFFFFFFFL;
    private static final int f_305423_ = 5;
    private static final int f_305424_ = 31;
    public final int f_45578_;
    public final int f_45579_;
    private static final int f_305425_ = 1664525;
    private static final int f_305426_ = 1013904223;
    private static final int f_305427_ = -559038737;
    private int cachedHashCode = 0;

    public ChunkPos(int x, int z) {
        this.f_45578_ = x;
        this.f_45579_ = z;
    }

    public ChunkPos(BlockPos pos) {
        this.f_45578_ = SectionPos.m_123171_((int)pos.m_123341_());
        this.f_45579_ = SectionPos.m_123171_((int)pos.m_123343_());
    }

    public ChunkPos(long longIn) {
        this.f_45578_ = (int)longIn;
        this.f_45579_ = (int)(longIn >> 32);
    }

    public long m_45588_() {
        return ChunkPos.m_45589_(this.f_45578_, this.f_45579_);
    }

    public static long m_45589_(int x, int z) {
        return (long)x & 0xFFFFFFFFL | ((long)z & 0xFFFFFFFFL) << 32;
    }

    public static long m_305432_(BlockPos posIn) {
        return ChunkPos.m_45589_(SectionPos.m_123171_((int)posIn.m_123341_()), SectionPos.m_123171_((int)posIn.m_123343_()));
    }

    public static int m_45592_(long chunkAsLong) {
        return (int)(chunkAsLong & 0xFFFFFFFFL);
    }

    public static int m_45602_(long chunkAsLong) {
        return (int)(chunkAsLong >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int i = 1664525 * this.f_45578_ + 1013904223;
        int j = 1664525 * (this.f_45579_ ^ 0xDEADBEEF) + 1013904223;
        this.cachedHashCode = i ^ j;
        return this.cachedHashCode;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ChunkPos)) {
            return false;
        }
        ChunkPos chunkpos = (ChunkPos)p_equals_1_;
        return this.f_45578_ == chunkpos.f_45578_ && this.f_45579_ == chunkpos.f_45579_;
    }

    public int m_162551_() {
        return this.m_162541_(8);
    }

    public int m_162555_() {
        return this.m_162552_(8);
    }

    public int m_45604_() {
        return SectionPos.m_123223_((int)this.f_45578_);
    }

    public int m_45605_() {
        return SectionPos.m_123223_((int)this.f_45579_);
    }

    public int m_45608_() {
        return this.m_162541_(15);
    }

    public int m_45609_() {
        return this.m_162552_(15);
    }

    public int m_45610_() {
        return this.f_45578_ >> 5;
    }

    public int m_45612_() {
        return this.f_45579_ >> 5;
    }

    public int m_45613_() {
        return this.f_45578_ & 0x1F;
    }

    public int m_45614_() {
        return this.f_45579_ & 0x1F;
    }

    public BlockPos m_305428_(int xIn, int yIn, int zIn) {
        return new BlockPos(this.m_162541_(xIn), yIn, this.m_162552_(zIn));
    }

    public int m_162541_(int xIn) {
        return SectionPos.m_213997_((int)this.f_45578_, (int)xIn);
    }

    public int m_162552_(int zIn) {
        return SectionPos.m_213997_((int)this.f_45579_, (int)zIn);
    }

    public BlockPos m_162556_(int yIn) {
        return new BlockPos(this.m_162551_(), yIn, this.m_162555_());
    }

    public String toString() {
        return "[" + this.f_45578_ + ", " + this.f_45579_ + "]";
    }

    public BlockPos m_45615_() {
        return new BlockPos(this.m_45604_(), 0, this.m_45605_());
    }

    public int m_45594_(ChunkPos chunkPosIn) {
        return Math.max(Math.abs(this.f_45578_ - chunkPosIn.f_45578_), Math.abs(this.f_45579_ - chunkPosIn.f_45579_));
    }

    public static Stream<ChunkPos> m_45596_(ChunkPos center, int radius) {
        return ChunkPos.m_45599_(new ChunkPos(center.f_45578_ - radius, center.f_45579_ - radius), new ChunkPos(center.f_45578_ + radius, center.f_45579_ + radius));
    }

    public static Stream<ChunkPos> m_45599_(final ChunkPos start, final ChunkPos end) {
        int i = Math.abs(start.f_45578_ - end.f_45578_) + 1;
        int j = Math.abs(start.f_45579_ - end.f_45579_) + 1;
        final int k = start.f_45578_ < end.f_45578_ ? 1 : -1;
        final int l = start.f_45579_ < end.f_45579_ ? 1 : -1;
        return StreamSupport.stream(new Spliterators.AbstractSpliterator<ChunkPos>((long)(i * j), 64){
            @Nullable
            private ChunkPos f_45621_;

            @Override
            public boolean tryAdvance(Consumer<? super ChunkPos> p_tryAdvance_1_) {
                if (this.f_45621_ == null) {
                    this.f_45621_ = start;
                } else {
                    int i1 = this.f_45621_.f_45578_;
                    int j1 = this.f_45621_.f_45579_;
                    if (i1 == end.f_45578_) {
                        if (j1 == end.f_45579_) {
                            return false;
                        }
                        this.f_45621_ = new ChunkPos(start.f_45578_, j1 + l);
                    } else {
                        this.f_45621_ = new ChunkPos(i1 + k, j1);
                    }
                }
                p_tryAdvance_1_.accept(this.f_45621_);
                return true;
            }
        }, false);
    }
}

