/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1049;
import net.minecraft.class_1061;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_339;
import net.minecraft.class_3695;
import net.minecraft.class_4005;
import net.minecraft.class_4325;
import net.minecraft.class_442;
import net.optifine.Config;
import net.optifine.CustomGuis;
import net.optifine.EmissiveTextures;
import net.optifine.shaders.ShadersTex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_1060
implements class_3302,
class_1061,
AutoCloseable {
    private static final Logger field_5288 = LogManager.getLogger();
    public static final class_2960 field_5285 = new class_2960("");
    private final Map<class_2960, class_1044> field_5286 = Maps.newHashMap();
    private final Set<class_1061> field_5284 = Sets.newHashSet();
    private final Map<String, Integer> field_5283 = Maps.newHashMap();
    private final class_3300 field_5287;
    private class_1044 boundTexture;
    private class_2960 boundTextureLocation;
    private Int2ObjectMap<class_1044> mapTexturesById = new Int2ObjectOpenHashMap();

    public class_1060(class_3300 resourceManager) {
        this.field_5287 = resourceManager;
    }

    public void method_22813(class_2960 resource) {
        if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(() -> this.method_4618(resource));
        } else {
            this.method_4618(resource);
        }
    }

    private void method_4618(class_2960 resource) {
        class_1044 abstracttexture;
        if (Config.isCustomGuis()) {
            resource = CustomGuis.getTextureLocation(resource);
        }
        if ((abstracttexture = this.field_5286.get(resource)) == null) {
            abstracttexture = new class_1049(resource);
            this.method_4616(resource, abstracttexture);
        }
        if (Config.isShaders()) {
            ShadersTex.bindTexture(abstracttexture);
        } else {
            abstracttexture.method_23207();
        }
        this.boundTexture = abstracttexture;
        this.boundTextureLocation = resource;
    }

    public void method_4616(class_2960 textureLocation, class_1044 textureObj) {
        int textureId;
        class_1044 abstracttexture = this.field_5286.put(textureLocation, textureObj = this.method_24303(textureLocation, textureObj));
        if (abstracttexture != textureObj) {
            if (abstracttexture != null && abstracttexture != class_1047.method_4540()) {
                this.field_5284.remove(abstracttexture);
                this.method_30299(textureLocation, abstracttexture);
            }
            if (textureObj instanceof class_1061) {
                this.field_5284.add((class_1061)((Object)textureObj));
            }
        }
        if ((textureId = textureObj.method_4624()) > 0) {
            this.mapTexturesById.put(textureId, (Object)textureObj);
        }
    }

    private void method_30299(class_2960 locationIn, class_1044 textureIn) {
        if (textureIn != class_1047.method_4540()) {
            try {
                textureIn.close();
            }
            catch (Exception exception) {
                field_5288.warn("Failed to close texture {}", (Object)locationIn, (Object)exception);
            }
        }
        textureIn.method_4528();
    }

    private class_1044 method_24303(class_2960 locationIn, class_1044 textureIn) {
        try {
            textureIn.method_4625(this.field_5287);
            return textureIn;
        }
        catch (IOException ioexception) {
            if (locationIn != field_5285) {
                field_5288.warn("Failed to load texture: {}", (Object)locationIn, (Object)ioexception);
            }
            return class_1047.method_4540();
        }
        catch (Throwable throwable) {
            class_128 crashreport = class_128.method_560(throwable, "Registering texture");
            class_129 crashreportcategory = crashreport.method_562("Resource location being registered");
            crashreportcategory.method_578("Resource location", locationIn);
            crashreportcategory.method_577("Texture object class", () -> textureIn.getClass().getName());
            throw new class_148(crashreport);
        }
    }

    public class_1044 method_4619(class_2960 textureLocation) {
        class_1044 abstracttexture = this.field_5286.get(textureLocation);
        if (abstracttexture == null) {
            abstracttexture = new class_1049(textureLocation);
            this.method_4616(textureLocation, abstracttexture);
        }
        return abstracttexture;
    }

    public class_1044 method_34590(class_2960 textureLocation, class_1044 textureDefault) {
        return this.field_5286.getOrDefault(textureLocation, textureDefault);
    }

    public class_2960 method_4617(String name, class_1043 texture) {
        Integer integer = this.field_5283.get(name);
        integer = integer == null ? Integer.valueOf(1) : Integer.valueOf(integer + 1);
        this.field_5283.put(name, integer);
        class_2960 resourcelocation = new class_2960(String.format(Locale.ROOT, "dynamic/%s_%d", name, integer));
        this.method_4616(resourcelocation, texture);
        return resourcelocation;
    }

    public CompletableFuture<Void> method_18168(class_2960 textureLocation, Executor executor) {
        if (!this.field_5286.containsKey(textureLocation)) {
            class_4005 preloadedtexture = new class_4005(this.field_5287, textureLocation, executor);
            this.field_5286.put(textureLocation, preloadedtexture);
            return preloadedtexture.method_18148().thenRunAsync(() -> this.method_4616(textureLocation, preloadedtexture), class_1060::method_22812);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static void method_22812(Runnable runnableIn) {
        class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(runnableIn::run));
    }

    @Override
    public void method_4622() {
        for (class_1061 tickable : this.field_5284) {
            tickable.method_4622();
        }
    }

    public void method_4615(class_2960 textureLocation) {
        class_1044 abstracttexture = this.method_34590(textureLocation, class_1047.method_4540());
        if (abstracttexture != class_1047.method_4540()) {
            this.field_5286.remove(textureLocation);
            TextureUtil.releaseTextureId(abstracttexture.method_4624());
        }
    }

    @Override
    public void close() {
        this.field_5286.forEach(this::method_30299);
        this.field_5286.clear();
        this.field_5284.clear();
        this.field_5283.clear();
        this.mapTexturesById.clear();
    }

    @Override
    public CompletableFuture<Void> method_25931(class_3302.class_4045 stage, class_3300 resourceManager, class_3695 preparationsProfiler, class_3695 reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        Config.dbg("*** Reloading textures ***");
        Config.log("Resource packs: " + Config.getResourcePackNames());
        Iterator<class_2960> it = this.field_5286.keySet().iterator();
        while (it.hasNext()) {
            class_2960 loc = it.next();
            String path = loc.method_12832();
            if (!path.startsWith("optifine/") && !EmissiveTextures.isEmissive(loc)) continue;
            class_1044 tex = this.field_5286.get(loc);
            if (tex instanceof class_1044) {
                class_1044 at = tex;
                at.method_4528();
            }
            it.remove();
        }
        EmissiveTextures.update();
        return ((CompletableFuture)CompletableFuture.allOf(class_442.method_18105(this, backgroundExecutor), this.method_18168(class_339.field_22757, backgroundExecutor)).thenCompose(stage::method_18352)).thenAcceptAsync(voidIn -> {
            class_1047.method_4540();
            class_4325.method_23765(this.field_5287);
            HashSet<Map.Entry<class_2960, class_1044>> entries = new HashSet<Map.Entry<class_2960, class_1044>>(this.field_5286.entrySet());
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                class_2960 resourcelocation = (class_2960)entry.getKey();
                class_1044 abstracttexture = (class_1044)entry.getValue();
                if (abstracttexture == class_1047.method_4540() && !resourcelocation.equals(class_1047.method_4539())) {
                    iterator.remove();
                    continue;
                }
                abstracttexture.method_18169(this, resourceManager, resourcelocation, gameExecutor);
            }
        }, runnableIn -> RenderSystem.recordRenderCall(runnableIn::run));
    }

    public class_1044 getBoundTexture() {
        return this.boundTexture;
    }

    public class_2960 getBoundTextureLocation() {
        return this.boundTextureLocation;
    }

    public class_1044 getTextureById(int id) {
        class_1044 tex = (class_1044)this.mapTexturesById.get(id);
        if (tex != null && tex.method_4624() != id) {
            this.mapTexturesById.remove(id);
            this.mapTexturesById.put(tex.method_4624(), (Object)tex);
            tex = null;
        }
        return tex;
    }
}

