/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync.trackers;

import com.google.common.base.Joiner;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryEntryRemovedCallback;
import net.fabricmc.fabric.api.event.registry.RegistryIdRemapCallback;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Int2ObjectMapTracker<V, OV>
implements RegistryEntryAddedCallback<V>,
RegistryIdRemapCallback<V>,
RegistryEntryRemovedCallback<V> {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private final Int2ObjectMap<OV> mappers;
    private Map<class_2960, OV> removedMapperCache = new HashMap<class_2960, OV>();

    private Int2ObjectMapTracker(String name, Int2ObjectMap<OV> mappers) {
        this.name = name;
        this.mappers = mappers;
    }

    public static <V, OV> void register(class_2378<V> registry, String name, Int2ObjectMap<OV> mappers) {
        Int2ObjectMapTracker<V, OV> updater = new Int2ObjectMapTracker<V, OV>(name, mappers);
        RegistryEntryAddedCallback.event(registry).register(updater);
        RegistryIdRemapCallback.event(registry).register(updater);
        RegistryEntryRemovedCallback.event(registry).register(updater);
    }

    @Override
    public void onEntryAdded(int rawId, class_2960 id, V object) {
        if (this.removedMapperCache.containsKey(id)) {
            this.mappers.put(rawId, this.removedMapperCache.get(id));
        }
    }

    @Override
    public void onRemap(RegistryIdRemapCallback.RemapState<V> state) {
        Int2ObjectOpenHashMap oldMappers = new Int2ObjectOpenHashMap(this.mappers);
        Int2IntMap remapMap = state.getRawIdChangeMap();
        ArrayList<CallSite> errors = null;
        this.mappers.clear();
        IntIterator intIterator = oldMappers.keySet().iterator();
        while (intIterator.hasNext()) {
            int i = (Integer)intIterator.next();
            int newI = remapMap.getOrDefault(i, Integer.MIN_VALUE);
            if (newI >= 0) {
                if (this.mappers.containsKey(newI)) {
                    if (errors == null) {
                        errors = new ArrayList<CallSite>();
                    }
                    errors.add((CallSite)((Object)(" - Map contained two equal IDs " + newI + " (" + state.getIdFromOld(i) + "/" + i + " -> " + state.getIdFromNew(newI) + "/" + newI + ")!")));
                    continue;
                }
                this.mappers.put(newI, oldMappers.get(i));
                continue;
            }
            LOGGER.warn("[fabric-registry-sync] Int2ObjectMap " + this.name + " is dropping mapping for integer ID " + i + " (" + state.getIdFromOld(i) + ") - should not happen!");
            this.removedMapperCache.put(state.getIdFromOld(i), oldMappers.get(i));
        }
        if (errors != null) {
            throw new RuntimeException("Errors while remapping Int2ObjectMap " + this.name + " found:\n" + Joiner.on((char)'\n').join(errors));
        }
    }

    @Override
    public void onEntryRemoved(int rawId, class_2960 id, V object) {
        Object mapper = this.mappers.remove(rawId);
        if (mapper != null) {
            this.removedMapperCache.put(id, mapper);
        }
    }
}

