/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.settings;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.class_1074;
import net.minecraft.class_1132;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.category.setting.ObjectCategorySetting;
import xaero.common.file.SimpleBackup;
import xaero.common.gui.GuiSettings;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.ScreenBase;
import xaero.common.interfaces.Interface;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.radar.MinimapRadar;
import xaero.common.minimap.radar.category.EntityRadarBackwardsCompatibilityConfig;
import xaero.common.minimap.radar.category.EntityRadarCategory;
import xaero.common.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.patreon.Patreon;
import xaero.common.settings.ModOptions;

public class ModSettings {
    public static int defaultSettings;
    public static int ignoreUpdate;
    public static final String format = "\u00a7";
    private AXaeroMinimap modMain;
    private EntityRadarBackwardsCompatibilityConfig entityRadarBackwardsCompatibilityConfig;
    private boolean foundOldRadarSettings;
    public static final String[] ENCHANT_COLORS;
    public static final String[] ENCHANT_COLOR_NAMES;
    public static final int[] COLORS;
    public static int serverSettings;
    public static class_304 keyBindZoom;
    public static class_304 keyBindZoom1;
    public static class_304 newWaypoint;
    public static class_304 keyWaypoints;
    public static class_304 keyLargeMap;
    public static class_304 keyToggleMap;
    public static class_304 keyToggleWaypoints;
    public static class_304 keyToggleMapWaypoints;
    public static class_304 keyToggleSlimes;
    public static class_304 keyToggleGrid;
    public static class_304 keyInstantWaypoint;
    public static class_304 keySwitchSet;
    public static class_304 keyAllSets;
    public static class_304 keyLightOverlay;
    public static class_304 keyToggleRadar;
    private boolean minimap = true;
    public static String minimapItemId;
    public static class_1792 minimapItem;
    public int zoom = 0;
    public static final float[] zooms;
    public int caveMaps = 2;
    public int caveZoom = 1;
    private boolean showWaypoints = true;
    private boolean deathpoints = true;
    private boolean oldDeathpoints = true;
    public int chunkGrid = -1;
    public boolean slimeChunks = false;
    private static HashMap<String, Long> serverSlimeSeeds;
    private boolean showIngameWaypoints = true;
    private boolean showCoords = true;
    private boolean lockNorth = false;
    private boolean antiAliasing = true;
    private boolean displayRedstone = true;
    public boolean mapSafeMode = false;
    public int distance = 1;
    public static final String[] distanceTypes;
    private int blockColours = 0;
    public static final String[] blockColourTypes;
    private boolean lighting = true;
    public boolean compassOverWaypoints = false;
    private int minimapSize = 0;
    public double minimapOpacity = 100.0;
    public double waypointsIngameCloseScale = 1.0;
    private int waypointsIngameIconScale = 0;
    private int waypointsIngameDistanceScale = 0;
    private int waypointsIngameNameScale = 0;
    private static final float DEFAULT_SCALE = 0.8f;
    private static final float MINECRAFT_SCALE = 0.02666667f;
    private static final double WAYPOINT_ICON_WORLD_SIZE = 0.19200003147125244;
    private double dotNameScale = 1.0;
    public static boolean settingsButton;
    public boolean showBiome = false;
    public static boolean updateNotification;
    private boolean showFlowers = true;
    public boolean keepWaypointNames = true;
    private int waypointsDistanceExp = 0;
    public double waypointsDistanceMin = 0.0;
    public String waypointTPCommand = "/tp @s";
    public double arrowScale = 1.5;
    public int arrowColour = 0;
    public String[] arrowColourNames = new String[]{"gui.xaero_red", "gui.xaero_green", "gui.xaero_blue", "gui.xaero_yellow", "gui.xaero_purple", "gui.xaero_white", "gui.xaero_black", "gui.xaero_preset_classic"};
    public static float[][] arrowColours;
    public boolean smoothDots = true;
    public static final String[] ENTITY_ICONS_OPTIONS;
    private boolean worldMap = true;
    private boolean terrainDepth = true;
    private static final String[] SLOPES_MODES;
    private int terrainSlopes = 2;
    public int mainEntityAs = 0;
    public boolean blockTransparency = true;
    public int waypointOpacityIngame = 80;
    public int waypointOpacityMap = 90;
    public boolean allowWrongWorldTeleportation = false;
    public int hideWorldNames = 1;
    public boolean openSlimeSettings = true;
    public boolean alwaysShowDistance = false;
    public static final String[] ENTITY_NAMES_OPTIONS;
    public int showLightLevel = 0;
    private static final String[] SHOW_LIGHT_LEVEL_NAMES;
    public int renderLayerIndex = 1;
    public boolean crossDimensionalTp = true;
    public int showTime = 0;
    public boolean differentiateByServerAddress = true;
    private boolean biomeColorsVanillaMode = false;
    public int lookingAtAngle = 10;
    public int lookingAtAngleVertical = 180;
    public boolean centeredEnlarged = false;
    public boolean zoomedOutEnlarged = false;
    public int minimapTextAlign = 0;
    public boolean showAngles;
    public boolean waypointsMutualEdit = true;
    public int caveMapsDepth = 30;
    public boolean hideWaypointCoordinates = false;
    public boolean renderAllSets = false;
    public int playerArrowOpacity = 100;
    public boolean waypointsBottom;
    private static final String[] MINIMAP_SHAPES;
    public int minimapShape;
    public int lightOverlayType;
    public int lightOverlayMaxLight = 7;
    public int lightOverlayMinLight = 0;
    public int lightOverlayColor = 13;
    public static final String[] DOTS_STYLES;
    private int dotsStyle = 0;
    public boolean debugEntityIcons;
    private int uiScale = 0;
    public static final String[] PUSHBOX_OPTIONS;
    public int bossHealthPushBox = 1;
    public int potionEffectPushBox = 1;
    public static final String[] FRAME_OPTIONS;
    public int minimapFrame = 0;
    public int minimapFrameColor = 9;
    public static final String[] COMPASS_OPTIONS;
    public int compassLocation = 1;
    private int compassScale = 1;
    public int compassColor = 9;
    public boolean showDimensionName;
    public boolean debugEntityVariantIds;
    private static final String[] MULTIPLE_WAYPOINT_INFO;
    public int displayMultipleWaypointInfo = 1;
    private boolean entityRadar = true;
    private static int[] OLD_MINIMAP_SIZES;

    public ModSettings(AXaeroMinimap modMain) {
        this.modMain = modMain;
        this.entityRadarBackwardsCompatibilityConfig = new EntityRadarBackwardsCompatibilityConfig();
        int n = defaultSettings = modMain.getVersionID().endsWith("fair") ? 16188159 : Integer.MAX_VALUE;
        if (serverSettings == 0) {
            serverSettings = defaultSettings;
        }
    }

    public boolean isKeyRepeat(class_304 kb) {
        return kb != this.modMain.getSettingsKey() && kb != keyWaypoints && kb != newWaypoint && kb != keyLargeMap && kb != keyToggleMap && kb != keyToggleWaypoints && kb != keyToggleMapWaypoints && kb != keyToggleSlimes && kb != keyToggleGrid && kb != keyInstantWaypoint && kb != keySwitchSet && kb != keyAllSets && kb != keyLightOverlay && kb != keyBindZoom && kb != keyBindZoom1 && kb != keyToggleRadar;
    }

    public boolean getMinimap() {
        return this.minimap && !this.minimapDisabled() && (minimapItem == null || class_310.method_1551().field_1724 == null || MinimapProcessor.hasMinimapItem((class_1657)class_310.method_1551().field_1724));
    }

    public boolean getCaveMaps() {
        return this.caveMaps > 0 && !this.caveMapsDisabled();
    }

    public boolean getShowWaypoints() {
        return this.showWaypoints && !this.showWaypointsDisabled();
    }

    public boolean getDeathpoints() {
        return this.deathpoints && !this.deathpointsDisabled();
    }

    public boolean getOldDeathpoints() {
        return this.oldDeathpoints;
    }

    public void setSlimeChunksSeed(long seed, String fullWorldID) {
        serverSlimeSeeds.put(fullWorldID, seed);
    }

    public Long getSlimeChunksSeed(String fullWorldID) {
        class_1132 sp = class_310.method_1551().method_1576();
        if (sp == null) {
            return serverSlimeSeeds.get(fullWorldID);
        }
        try {
            if (class_310.method_1551().field_1687.method_27983() != class_1937.field_25179) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return null;
        }
        long seed = sp.method_3847(class_1937.field_25179).method_8412();
        return seed;
    }

    public boolean customSlimeSeedNeeded(XaeroMinimapSession minimapSession) {
        return !(class_310.method_1551().field_1755 instanceof GuiSlimeSeed) && class_310.method_1551().method_1576() == null && minimapSession != null;
    }

    public boolean getSlimeChunks(WaypointsManager waypointsManager) {
        return this.slimeChunks && (class_310.method_1551().method_1576() != null || this.getSlimeChunksSeed(waypointsManager.getCurrentContainerAndWorldID()) != null);
    }

    public boolean getShowIngameWaypoints() {
        return this.showIngameWaypoints && !this.showWaypointsDisabled() && (minimapItem == null || class_310.method_1551().field_1724 == null || MinimapProcessor.hasMinimapItem((class_1657)class_310.method_1551().field_1724));
    }

    public boolean waypointsGUI(WaypointsManager waypointsManager) {
        return class_310.method_1551().field_1724 != null && waypointsManager.getWaypoints() != null && (minimapItem == null || class_310.method_1551().field_1724 == null || MinimapProcessor.hasMinimapItem((class_1657)class_310.method_1551().field_1724));
    }

    public boolean getShowCoords() {
        return this.showCoords;
    }

    public boolean getLockNorth(int mapSize, int shape) {
        if (mapSize > 180 && shape == 0) {
            return true;
        }
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        if (minimapSession == null) {
            return this.lockNorth;
        }
        return this.lockNorth || minimapSession.getMinimapProcessor().isEnlargedMap();
    }

    public boolean getAntiAliasing() {
        return this.antiAliasing && (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO());
    }

    public boolean getDisplayRedstone() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.displayRedstone;
        }
        return this.displayRedstone;
    }

    public int getBlockColours() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapColours();
        }
        return this.blockColours;
    }

    private boolean separateLighting() {
        return !this.modMain.getSupportMods().shouldUseWorldMapChunks() || this.modMain.getSupportMods().worldmapSupport.compatibilityVersion >= 4;
    }

    public boolean getLighting() {
        if (this.separateLighting()) {
            return this.lighting;
        }
        return this.modMain.getSupportMods().worldmapSupport.getWorldMapLighting();
    }

    public int getMinimapSize() {
        int width;
        if (this.minimapSize > 0) {
            return this.minimapSize;
        }
        int height = class_310.method_1551().method_22683().method_4506();
        int size = (int)((float)(height <= (width = class_310.method_1551().method_22683().method_4489()) ? height : width) / this.getMinimapScale());
        return Math.min(Math.max((int)(ModOptions.SIZE.getValueMin() + ModOptions.SIZE.getValueStep()), 2 * size * 130 / 1080), (int)ModOptions.SIZE.getValueMax());
    }

    public float getMinimapScale() {
        return this.getUIScale(this.uiScale, 1, 11);
    }

    public float getUIScale(int optionValue, int min, int max) {
        if (optionValue <= min) {
            return this.getAutoUIScale();
        }
        if (optionValue == max) {
            return (float)class_310.method_1551().method_22683().method_4495();
        }
        return optionValue;
    }

    public int getAutoUIScale() {
        int width;
        int size;
        int height = class_310.method_1551().method_22683().method_4506();
        int n = size = height <= (width = class_310.method_1551().method_22683().method_4489()) ? height : width;
        if (size >= 1500) {
            int steps = size / 500;
            return steps;
        }
        return 2;
    }

    public float getWaypointsIngameIconScale() {
        return this.getUIScale(this.waypointsIngameIconScale, 0, 17);
    }

    public float getWaypointsIngameDistanceScale() {
        return this.getUIScale(this.waypointsIngameDistanceScale, 0, 17);
    }

    public int getWaypointsIngameNameScale() {
        int scale = (int)this.getUIScale(this.waypointsIngameNameScale, 0, 17);
        if (this.waypointsIngameNameScale <= 0) {
            return (int)Math.ceil(scale / 2);
        }
        return scale;
    }

    public double getWaypointsClampDepth(double fov, int height) {
        int baseIconHeight = (int)(this.getWaypointsIngameIconScale() * 9.0f);
        double worldSizeAtClampDepth = this.waypointsIngameCloseScale * 0.19200003147125244 * (double)height / (double)baseIconHeight;
        double fovMultiplier = 2.0 * Math.tan(Math.toRadians(fov / 2.0));
        double clampDepth = worldSizeAtClampDepth / fovMultiplier;
        return clampDepth;
    }

    public double getDotNameScale() {
        return this.dotNameScale * (class_310.method_1551().method_1573() ? 2.0 : 1.0);
    }

    public boolean getShowFlowers() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapFlowers();
        }
        return this.showFlowers;
    }

    public double getMaxWaypointsDistance() {
        if (this.waypointsDistanceExp <= 0) {
            return 0.0;
        }
        return Math.pow(2.0, 2 + this.waypointsDistanceExp);
    }

    public boolean getSmoothDots() {
        return this.smoothDots && (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO());
    }

    public boolean getUseWorldMap() {
        return this.worldMap && (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO());
    }

    public boolean getTerrainDepth() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapTerrainDepth();
        }
        return this.terrainDepth;
    }

    public int getTerrainSlopes() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapTerrainSlopes();
        }
        return this.terrainSlopes;
    }

    public boolean getBiomeColorsVanillaMode() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapBiomeColorsVanillaMode();
        }
        return this.biomeColorsVanillaMode;
    }

    public int getCompassScale() {
        return this.compassScale * (class_310.method_1551().method_1573() ? 2 : 1);
    }

    public boolean getEntityRadar() {
        return this.entityRadar && !this.modMain.isFairPlay();
    }

    public int getDotsStyle() {
        if (!this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().usingFBO()) {
            return this.dotsStyle;
        }
        return 1;
    }

    public boolean isIgnoreHeightmaps() {
        if (this.modMain.getSupportMods().shouldUseWorldMapChunks()) {
            return this.modMain.getSupportMods().worldmapSupport.getWorldMapIgnoreHeightmaps();
        }
        WaypointWorldRootContainer currentRootContainer = XaeroMinimapSession.getCurrentSession().getWaypointsManager().getAutoWorld().getContainer().getRootContainer();
        return currentRootContainer.isIgnoreHeightmaps();
    }

    public void convertWaypointFilesToFolders() throws IOException {
        Stream<Path> files = Files.list(this.modMain.getWaypointsFolder().toPath());
        Path backupFolder = this.modMain.getWaypointsFolder().toPath().resolve("backup");
        Files.createDirectories(backupFolder, new FileAttribute[0]);
        if (files != null) {
            Object[] fileArray = files.toArray();
            for (int i = 0; i < fileArray.length; ++i) {
                Object fileName;
                Path filePath = (Path)fileArray[i];
                if (filePath.toFile().isDirectory() || !((String)(fileName = filePath.getFileName().toString())).endsWith(".txt") || !((String)fileName).contains("_")) continue;
                int lastUnderscore = ((String)fileName).lastIndexOf("_");
                if (!((String)fileName).startsWith("Multiplayer_") && !((String)fileName).startsWith("Realms_")) {
                    fileName = ((String)fileName).substring(0, lastUnderscore).replace("_", "%us%") + ((String)fileName).substring(lastUnderscore);
                }
                String noExtension = ((String)fileName).substring(0, ((String)fileName).lastIndexOf("."));
                Path folderPath = filePath.getParent().resolve(noExtension);
                Path fixedFilePath = folderPath.resolve("waypoints.txt");
                Path backupFilePath = backupFolder.resolve((String)fileName);
                Files.createDirectories(folderPath, new FileAttribute[0]);
                if (!backupFilePath.toFile().exists()) {
                    Files.copy(filePath, backupFilePath, new CopyOption[0]);
                }
                try {
                    Files.move(filePath, fixedFilePath, new CopyOption[0]);
                    continue;
                }
                catch (FileAlreadyExistsException e) {
                    if (!backupFilePath.toFile().exists()) continue;
                    Files.deleteIfExists(filePath);
                }
            }
            files.close();
        }
    }

    public void convertWaypointFoldersToSingleFolder(WaypointsManager waypointsManager) throws IOException {
        Stream<Path> folders = Files.list(this.modMain.getWaypointsFolder().toPath());
        if (folders != null) {
            Object[] folderArray = folders.toArray();
            for (int i = 0; i < folderArray.length; ++i) {
                Stream<Path> deleteCheck;
                Stream<Path> files;
                Path correctFolder;
                String lastArg;
                String folderName;
                String[] folderArgs;
                Path folderPath = (Path)folderArray[i];
                if (!folderPath.toFile().isDirectory() || (folderArgs = (folderName = folderPath.getFileName().toString()).split("_")).length <= 1 || !(lastArg = folderArgs[folderArgs.length - 1]).equals("null") && (!lastArg.startsWith("DIM") || lastArg.length() <= 3)) continue;
                int dimensionId = lastArg.equals("null") ? 0 : Integer.parseInt(lastArg.substring(3));
                Object dimensionName = "dim%" + dimensionId;
                class_5321<class_1937> dimRegistryKey = waypointsManager.getDimensionKeyForDirectoryName((String)dimensionName);
                if (dimRegistryKey != null) {
                    dimensionName = waypointsManager.getDimensionDirectoryName(dimRegistryKey);
                }
                if (!Files.exists(correctFolder = folderPath.getParent().resolve(folderName.substring(0, folderName.lastIndexOf("_"))).resolve((String)dimensionName), new LinkOption[0])) {
                    Files.createDirectories(correctFolder, new FileAttribute[0]);
                }
                if ((files = Files.list(folderPath)) != null) {
                    Object[] filesArray = files.toArray();
                    for (int j = 0; j < filesArray.length; ++j) {
                        Path filePath = (Path)filesArray[j];
                        if (filePath.toFile().isDirectory()) continue;
                        Path correctFilePath = correctFolder.resolve(filePath.getFileName());
                        Files.move(filePath, correctFilePath, new CopyOption[0]);
                    }
                    files.close();
                }
                if ((deleteCheck = Files.list(folderPath)).count() == 0L) {
                    Files.deleteIfExists(folderPath);
                }
                deleteCheck.close();
            }
            folders.close();
        }
    }

    public static void copyTempFilesBack(Path folder) throws IOException {
        Stream<Path> tempFiles = Files.list(folder);
        if (tempFiles != null) {
            Iterator tempFilesIter = tempFiles.iterator();
            while (tempFilesIter.hasNext()) {
                Path tempFile = (Path)tempFilesIter.next();
                Path newLocation = folder.getParent().resolve(tempFile.getFileName());
                if (!Files.exists(newLocation, new LinkOption[0]) || !Files.isDirectory(newLocation, new LinkOption[0]) && Files.size(newLocation) == 0L) {
                    Misc.safeMoveAndReplace(tempFile, newLocation, false);
                    continue;
                }
                SimpleBackup.moveToBackup(folder.getParent(), tempFile);
            }
            tempFiles.close();
        }
        Files.delete(folder);
    }

    public void loadAllWaypoints(WaypointsManager waypointsManager) throws IOException {
        Path waypointTempToAddFolder;
        Path waypointsFolderPath = this.modMain.getWaypointsFolder().toPath();
        if (!Files.exists(waypointsFolderPath, new LinkOption[0])) {
            Files.createDirectories(waypointsFolderPath, new FileAttribute[0]);
        }
        if (Files.exists(waypointTempToAddFolder = waypointsFolderPath.resolve("temp_to_add"), new LinkOption[0])) {
            ModSettings.copyTempFilesBack(waypointTempToAddFolder);
        }
        this.convertWaypointFilesToFolders();
        this.convertWaypointFoldersToSingleFolder(waypointsManager);
        Stream<Path> folders = Files.list(this.modMain.getWaypointsFolder().toPath());
        if (folders != null) {
            Object[] paths = folders.toArray();
            for (int i = 0; i < paths.length; ++i) {
                Stream<Path> filesOrFolders;
                String folderName;
                Path folderPath = (Path)paths[i];
                Path tempToAdd = folderPath.resolve("temp_to_add");
                if (Files.exists(tempToAdd, new LinkOption[0])) {
                    ModSettings.copyTempFilesBack(tempToAdd);
                }
                if (!folderPath.toFile().isDirectory() || (folderName = folderPath.getFileName().toString()).equals("backup") || (filesOrFolders = Files.list(folderPath)) == null) continue;
                Object[] fileArray = filesOrFolders.toArray();
                for (int j = 0; j < fileArray.length; ++j) {
                    String fileOrFolderName;
                    Path fileOrFolderPath = (Path)fileArray[j];
                    Path tempToAdd2 = fileOrFolderPath.resolve("temp_to_add");
                    if (Files.exists(tempToAdd2, new LinkOption[0])) {
                        ModSettings.copyTempFilesBack(tempToAdd2);
                    }
                    if ((fileOrFolderName = fileOrFolderPath.getFileName().toString()).startsWith("backup")) continue;
                    if (fileOrFolderPath.toFile().isDirectory()) {
                        String dimensionName = fileOrFolderName;
                        String fixedDimensionName = this.fixDimensionName(dimensionName);
                        boolean toDeleteOld = !fixedDimensionName.equals(dimensionName);
                        String containerKey = folderName + "/" + fixedDimensionName;
                        WaypointWorldContainer wc = waypointsManager.addWorldContainer(containerKey);
                        Stream<Path> files = Files.list(fileOrFolderPath);
                        if (files != null) {
                            Object[] filesArray = files.toArray();
                            if (filesArray.length == 0) {
                                waypointsManager.removeContainer(containerKey);
                            } else {
                                for (int k = 0; k < filesArray.length; ++k) {
                                    Path filePath = (Path)filesArray[k];
                                    String fileName = filePath.getFileName().toString();
                                    this.loadWaypointsFile(wc, fileName, filePath.toFile());
                                }
                            }
                            files.close();
                        }
                        if (waypointsManager.getWorldContainer(folderName).isEmpty()) {
                            waypointsManager.removeContainer(folderName);
                        }
                        if (!toDeleteOld) continue;
                        SimpleBackup.moveToBackup(fileOrFolderPath);
                        this.saveWorlds(wc.getAllWorlds());
                        continue;
                    }
                    if (!fileOrFolderName.contains("_")) continue;
                    WaypointWorldContainer wc = waypointsManager.addWorldContainer(folderName);
                    this.loadWaypointsFile(wc, fileOrFolderName, null);
                }
                filesOrFolders.close();
            }
            folders.close();
        }
    }

    private String fixDimensionName(String savedDimName) {
        if (savedDimName.equals("Overworld")) {
            return "dim%0";
        }
        if (savedDimName.equals("Nether")) {
            return "dim%-1";
        }
        if (savedDimName.equals("The End")) {
            return "dim%1";
        }
        return savedDimName;
    }

    private boolean loadWaypointsFile(WaypointWorldContainer wc, String fileName, File file) throws IOException {
        WaypointWorld w;
        String noExtension;
        if (!fileName.endsWith(".txt")) {
            return false;
        }
        String multiworldId = noExtension = fileName.substring(0, fileName.lastIndexOf("."));
        if (!noExtension.equals("waypoints")) {
            String[] multiworld = noExtension.split("_");
            multiworldId = multiworld[0];
            String multiworldName = multiworld[1].replace("%us%", "_");
            wc.addName(multiworldId, multiworldName);
        }
        if ((w = wc.addWorld(multiworldId)) != null) {
            this.loadWaypoints(w, file);
        }
        return true;
    }

    public void saveAllWaypoints(WaypointsManager waypointsManager) throws IOException {
        String[] keys = waypointsManager.getWaypointMap().keySet().toArray(new String[0]);
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            WaypointWorldContainer wc = waypointsManager.getWaypointMap().get(key);
            this.saveWorlds(wc.getAllWorlds());
        }
    }

    public void saveWorlds(ArrayList<WaypointWorld> worlds) throws IOException {
        for (int j = 0; j < worlds.size(); ++j) {
            WaypointWorld w = worlds.get(j);
            if (w == null) continue;
            this.saveWaypoints(w);
        }
    }

    public void saveWaypoints(WaypointWorld wpw) throws IOException {
        this.saveWaypoints(wpw, true);
    }

    public File getWaypointsFile(WaypointWorld w) throws IOException {
        File containerFolder = w.getContainer().getDirectory();
        Path containerFolderPath = containerFolder.toPath();
        if (!Files.exists(containerFolderPath, new LinkOption[0])) {
            Files.createDirectories(containerFolderPath, new FileAttribute[0]);
        }
        String filePath = containerFolder.getPath() + "/" + w.getId();
        String name = w.getContainer().getName(w.getId());
        if (name != null) {
            filePath = filePath + "_" + name.replace("_", "%us%").replace(":", "\u00a7\u00a7");
        }
        return new File(filePath + ".txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveWaypoints(WaypointWorld wpw, boolean overwrite) throws IOException {
        if (wpw == null) {
            return;
        }
        File worldFile = this.getWaypointsFile(wpw);
        if (worldFile.exists() && !overwrite) {
            return;
        }
        File worldFileTemp = new File(worldFile.getParentFile(), worldFile.getName() + ".temp");
        try (OutputStreamWriter output = null;){
            String name;
            int i;
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(worldFileTemp), StandardCharsets.UTF_8);
            Object[] keys = wpw.getSets().keySet().toArray();
            if (keys.length > 1) {
                output.write("sets:" + wpw.getCurrent());
                for (i = 0; i < keys.length; ++i) {
                    name = (String)keys[i];
                    if (name.equals(wpw.getCurrent())) continue;
                    output.write(":" + (String)keys[i]);
                }
                output.write("\n");
            }
            output.write("#\n");
            output.write("#waypoint:name:initials:x:y:z:color:disabled:type:set:rotate_on_tp:tp_yaw:global\n");
            output.write("#\n");
            for (i = 0; i < keys.length; ++i) {
                name = (String)keys[i];
                WaypointSet set = wpw.getSets().get(name);
                if (set == null) continue;
                ArrayList<Waypoint> list = set.getList();
                for (int j = 0; j < list.size(); ++j) {
                    Waypoint w = list.get(j);
                    if (w.isTemporary()) continue;
                    output.write("waypoint:" + w.getNameSafe("\u00a7\u00a7") + ":" + w.getSymbolSafe("\u00a7\u00a7") + ":" + w.getX() + ":" + (Serializable)(w.isYIncluded() ? Integer.valueOf(w.getY()) : "~") + ":" + w.getZ() + ":" + w.getColor() + ":" + w.isDisabled() + ":" + w.getType() + ":" + name + ":" + w.isRotation() + ":" + w.getYaw() + ":" + w.isGlobal() + "\n");
                }
            }
            ArrayList<Map.Entry<String, Boolean>> serverWaypointsDisabled = new ArrayList<Map.Entry<String, Boolean>>(wpw.getServerWaypointsDisabled().entrySet());
            for (int i2 = 0; i2 < serverWaypointsDisabled.size(); ++i2) {
                Map.Entry<String, Boolean> e = serverWaypointsDisabled.get(i2);
                output.write("server_waypoint:" + e.getKey() + ":" + e.getValue() + "\n");
            }
        }
        Misc.safeMoveAndReplace(worldFileTemp.toPath(), worldFile.toPath(), true);
        if (wpw.hasSomethingToRemoveOnSave()) {
            wpw.onSaveCleanup(worldFile);
        }
    }

    public boolean checkWaypointsLine(String[] args, WaypointWorld wpw) {
        if (args[0].equalsIgnoreCase("sets")) {
            wpw.setCurrent(args[1]);
            for (int i = 1; i < args.length; ++i) {
                if (wpw.getSets().get(args[i]) != null) continue;
                wpw.getSets().put(args[i], new WaypointSet(args[i]));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("waypoint")) {
            String setName = args[9];
            WaypointSet waypoints = wpw.getSets().get(setName);
            if (waypoints == null) {
                waypoints = new WaypointSet(setName);
                wpw.getSets().put(setName, waypoints);
            }
            boolean yIncluded = !args[4].equals("~");
            int yCoord = 0;
            if (yIncluded) {
                yCoord = Integer.parseInt(args[4]);
            }
            Waypoint loadWaypoint = new Waypoint(Integer.parseInt(args[3]), yCoord, Integer.parseInt(args[5]), Waypoint.getStringFromStringSafe(args[1], "\u00a7\u00a7"), Waypoint.getStringFromStringSafe(args[2], "\u00a7\u00a7"), Integer.parseInt(args[6]), 0, false, yIncluded);
            if (args.length > 7) {
                loadWaypoint.setDisabled(args[7].equals("true"));
            }
            if (args.length > 8) {
                loadWaypoint.setType(Integer.parseInt(args[8]));
            }
            if (args.length > 10) {
                loadWaypoint.setRotation(args[10].equals("true"));
            }
            if (args.length > 11) {
                loadWaypoint.setYaw(Integer.parseInt(args[11]));
            }
            if (args.length > 12) {
                loadWaypoint.setGlobal(args[12].equals("true"));
            }
            waypoints.getList().add(loadWaypoint);
            return true;
        }
        if (args[0].equalsIgnoreCase("server_waypoint")) {
            wpw.getServerWaypointsDisabled().put(args[1], args[2].equals("true"));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWaypoints(WaypointWorld wpw, File file) throws IOException {
        if (file == null) {
            file = this.getWaypointsFile(wpw);
        }
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            while ((s = reader.readLine()) != null) {
                Object[] args = s.split(":");
                try {
                    this.checkWaypointsLine((String[])args, wpw);
                }
                catch (Exception e) {
                    System.out.println("Skipping:" + Arrays.toString(args));
                    e.printStackTrace();
                }
            }
        }
    }

    public String convertToNewConteinerID(String oldID, WaypointsManager waypointsManager) {
        int dimensionId;
        class_5321<class_1937> dimRegistryKey;
        String parentContainer = oldID.substring(0, oldID.lastIndexOf("_"));
        Object dimension = oldID.substring(oldID.lastIndexOf("_") + 1);
        if (((String)dimension).equals("null")) {
            dimension = "Overworld";
        } else if (((String)dimension).startsWith("DIM") && (dimRegistryKey = waypointsManager.getDimensionKeyForDirectoryName((String)(dimension = "dim%" + (dimensionId = Integer.parseInt(((String)dimension).substring(3)))))) != null) {
            dimension = waypointsManager.getDimensionDirectoryName(dimRegistryKey);
        }
        return parentContainer + "/" + this.fixDimensionName((String)dimension);
    }

    public boolean checkWaypointsLineOLD(String[] args, WaypointsManager waypointsManager) {
        if (args[0].equalsIgnoreCase("world")) {
            if (!args[1].contains("_")) {
                args[1] = args[1] + "_null";
            }
            WaypointWorldContainer wc = waypointsManager.addWorldContainer(this.convertToNewConteinerID(args[1], waypointsManager));
            WaypointWorld map = wc.addWorld("waypoints");
            map.setCurrent(args[2]);
            for (int i = 2; i < args.length; ++i) {
                if (map.getSets().get(args[i]) != null) continue;
                map.getSets().put(args[i], new WaypointSet(args[i]));
            }
            return true;
        }
        if (args[0].equalsIgnoreCase("waypoint")) {
            WaypointSet waypoints;
            if (!args[1].contains("_")) {
                args[1] = args[1] + "_null";
            }
            WaypointWorldContainer wc = waypointsManager.addWorldContainer(this.convertToNewConteinerID(args[1], waypointsManager));
            WaypointWorld map = wc.addWorld("waypoints");
            String setName = "gui.xaero_default";
            if (args.length > 10) {
                setName = args[10];
            }
            if ((waypoints = map.getSets().get(setName)) == null) {
                waypoints = new WaypointSet(setName);
                map.getSets().put(setName, waypoints);
            }
            Waypoint loadWaypoint = new Waypoint(Integer.parseInt(args[4]), Integer.parseInt(args[5]), Integer.parseInt(args[6]), args[2].replace("\u00a7\u00a7", ":"), args[3].replace("\u00a7\u00a7", ":"), Integer.parseInt(args[7]));
            if (args.length > 8) {
                loadWaypoint.setDisabled(args[8].equals("true"));
            }
            if (args.length > 9) {
                loadWaypoint.setType(Integer.parseInt(args[9]));
            }
            if (args.length > 11) {
                loadWaypoint.setRotation(args[11].equals("true"));
            }
            if (args.length > 12) {
                loadWaypoint.setYaw(Integer.parseInt(args[12]));
            }
            waypoints.getList().add(loadWaypoint);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOldWaypoints(File file, WaypointsManager waypointsManager) throws IOException {
        if (!file.exists()) {
            return;
        }
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(file));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    this.checkWaypointsLineOLD(args, waypointsManager);
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
        File backupFile = new File(file.getAbsolutePath() + ".backup");
        if (backupFile.exists()) {
            System.out.println("Waypoints old file backup already exists!");
            return;
        }
        Files.move(file.toPath(), backupFile.toPath(), new CopyOption[0]);
    }

    public void writeSettings(PrintWriter writer) {
        writer.println("#CONFIG ONLY OPTIONS");
        writer.println("ignoreUpdate:" + ignoreUpdate);
        writer.println("settingsButton:" + settingsButton);
        if (minimapItemId != null) {
            writer.println("minimapItemId:" + minimapItemId);
        }
        writer.println("allowWrongWorldTeleportation:" + this.allowWrongWorldTeleportation);
        writer.println("differentiateByServerAddress:" + this.differentiateByServerAddress);
        writer.println("debugEntityIcons:" + this.debugEntityIcons);
        writer.println("debugEntityVariantIds:" + this.debugEntityVariantIds);
        writer.println("#INGAME SETTINGS (DO NOT EDIT!)");
        writer.println("updateNotification:" + updateNotification);
        writer.println("minimap:" + this.minimap);
        writer.println("caveMaps:" + this.caveMaps);
        writer.println("caveZoom:" + this.caveZoom);
        writer.println("showWaypoints:" + this.showWaypoints);
        writer.println("showIngameWaypoints:" + this.showIngameWaypoints);
        writer.println("displayRedstone:" + this.displayRedstone);
        writer.println("deathpoints:" + this.deathpoints);
        writer.println("oldDeathpoints:" + this.oldDeathpoints);
        writer.println("distance:" + this.distance);
        writer.println("showCoords:" + this.showCoords);
        writer.println("lockNorth:" + this.lockNorth);
        writer.println("zoom:" + this.zoom);
        writer.println("minimapSize:" + this.minimapSize);
        writer.println("chunkGrid:" + this.chunkGrid);
        writer.println("slimeChunks:" + this.slimeChunks);
        writer.println("mapSafeMode:" + this.mapSafeMode);
        writer.println("minimapOpacity:" + this.minimapOpacity);
        writer.println("waypointsIngameIconScale:" + this.waypointsIngameIconScale);
        writer.println("waypointsIngameDistanceScale:" + this.waypointsIngameDistanceScale);
        writer.println("waypointsIngameNameScale:" + this.waypointsIngameNameScale);
        writer.println("waypointsIngameCloseScale:" + this.waypointsIngameCloseScale);
        writer.println("antiAliasing:" + this.antiAliasing);
        writer.println("blockColours:" + this.blockColours);
        writer.println("lighting:" + this.lighting);
        writer.println("dotsStyle:" + this.dotsStyle);
        writer.println("dotNameScale:" + this.dotNameScale);
        writer.println("compassOverWaypoints:" + this.compassOverWaypoints);
        writer.println("showBiome:" + this.showBiome);
        writer.println("showFlowers:" + this.showFlowers);
        writer.println("keepWaypointNames:" + this.keepWaypointNames);
        writer.println("waypointsDistanceExp:" + this.waypointsDistanceExp);
        writer.println("waypointsDistanceMin:" + this.waypointsDistanceMin);
        writer.println("waypointTPCommand:" + this.waypointTPCommand.replace(":", "^col^"));
        writer.println("arrowScale:" + this.arrowScale);
        writer.println("arrowColour:" + this.arrowColour);
        writer.println("smoothDots:" + this.smoothDots);
        writer.println("worldMap:" + this.worldMap);
        writer.println("terrainDepth:" + this.terrainDepth);
        writer.println("terrainSlopes:" + this.terrainSlopes);
        writer.println("mainEntityAs:" + this.mainEntityAs);
        writer.println("blockTransparency:" + this.blockTransparency);
        writer.println("waypointOpacityIngame:" + this.waypointOpacityIngame);
        writer.println("waypointOpacityMap:" + this.waypointOpacityMap);
        writer.println("hideWorldNames:" + this.hideWorldNames);
        writer.println("openSlimeSettings:" + this.openSlimeSettings);
        writer.println("alwaysShowDistance:" + this.alwaysShowDistance);
        writer.println("showLightLevel:" + this.showLightLevel);
        writer.println("renderLayerIndex:" + this.renderLayerIndex);
        writer.println("crossDimensionalTp:" + this.crossDimensionalTp);
        writer.println("showTime:" + this.showTime);
        writer.println("biomeColorsVanillaMode:" + this.biomeColorsVanillaMode);
        writer.println("lookingAtAngle:" + this.lookingAtAngle);
        writer.println("lookingAtAngleVertical:" + this.lookingAtAngleVertical);
        writer.println("centeredEnlarged:" + this.centeredEnlarged);
        writer.println("zoomedOutEnlarged:" + this.zoomedOutEnlarged);
        writer.println("minimapTextAlign:" + this.minimapTextAlign);
        writer.println("showAngles:" + this.showAngles);
        writer.println("waypointsMutualEdit:" + this.waypointsMutualEdit);
        writer.println("compassLocation:" + this.compassLocation);
        writer.println("compassScale:" + this.compassScale);
        writer.println("caveMapsDepth:" + this.caveMapsDepth);
        writer.println("hideWaypointCoordinates:" + this.hideWaypointCoordinates);
        writer.println("renderAllSets:" + this.renderAllSets);
        writer.println("playerArrowOpacity:" + this.playerArrowOpacity);
        writer.println("waypointsBottom:" + this.waypointsBottom);
        writer.println("minimapShape:" + this.minimapShape);
        writer.println("lightOverlayType:" + this.lightOverlayType);
        writer.println("lightOverlayMaxLight:" + this.lightOverlayMaxLight);
        writer.println("lightOverlayMinLight:" + this.lightOverlayMinLight);
        writer.println("lightOverlayColor:" + this.lightOverlayColor);
        writer.println("uiScale:" + this.uiScale);
        writer.println("bossHealthPushBox:" + this.bossHealthPushBox);
        writer.println("potionEffectPushBox:" + this.potionEffectPushBox);
        writer.println("minimapFrame:" + this.minimapFrame);
        writer.println("minimapFrameColor:" + this.minimapFrameColor);
        writer.println("compassColor:" + this.compassColor);
        writer.println("showDimensionName:" + this.showDimensionName);
        writer.println("displayMultipleWaypointInfo:" + this.displayMultipleWaypointInfo);
        writer.println("entityRadar:" + this.entityRadar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSettings() throws IOException {
        try (PrintWriter writer = null;){
            writer = new PrintWriter(new FileWriter(this.modMain.getConfigFile()));
            this.writeSettings(writer);
            Object[] keys = serverSlimeSeeds.keySet().toArray();
            Object[] values = serverSlimeSeeds.values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                writer.println("seed:" + keys[i] + ":" + values[i]);
            }
            Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
            while (iter.hasNext()) {
                Interface l = iter.next();
                writer.println("interface:" + l.getIname() + ":" + l.getActualx() + ":" + l.getActualy() + ":" + l.isCentered() + ":" + l.isFlipped() + ":" + l.isFromRight() + ":" + l.isFromBottom());
            }
            writer.println("#WAYPOINTS HAVE BEEN MOVED TO /XaeroWaypoints");
        }
    }

    public void readSetting(String[] args) {
        if (args[0].equalsIgnoreCase("ignoreUpdate")) {
            ignoreUpdate = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("updateNotification")) {
            updateNotification = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("settingsButton")) {
            settingsButton = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapItemId")) {
            minimapItemId = args[1] + ":" + args[2];
            minimapItem = (class_1792)class_2378.field_11142.method_10223(new class_2960(args[1], args[2]));
            System.out.println("Minimap item set: " + minimapItem.method_7848().getString());
        } else if (args[0].equalsIgnoreCase("allowWrongWorldTeleportation")) {
            this.allowWrongWorldTeleportation = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("differentiateByServerAddress")) {
            this.differentiateByServerAddress = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("debugEntityIcons")) {
            this.debugEntityIcons = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("debugEntityVariantIds")) {
            this.debugEntityVariantIds = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimap")) {
            this.minimap = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("caveMaps")) {
            this.caveMaps = args[1].equals("true") ? 1 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("caveZoom")) {
            this.caveZoom = args[1].equals("true") ? 2 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("showWaypoints")) {
            this.showWaypoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("deathpoints")) {
            this.deathpoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("oldDeathpoints")) {
            this.oldDeathpoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showIngameWaypoints")) {
            this.showIngameWaypoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("displayRedstone")) {
            this.displayRedstone = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("distance")) {
            this.distance = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("showCoords")) {
            this.showCoords = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("lockNorth")) {
            this.lockNorth = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("zoom")) {
            this.zoom = Integer.parseInt(args[1]);
            if (this.zoom >= zooms.length) {
                this.zoom = zooms.length - 1;
            }
        } else if (args[0].equalsIgnoreCase("mapSize")) {
            int oldSize = Integer.parseInt(args[1]);
            this.minimapSize = oldSize == -1 ? 0 : OLD_MINIMAP_SIZES[oldSize];
        } else if (args[0].equalsIgnoreCase("minimapSize")) {
            this.minimapSize = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("chunkGrid")) {
            this.chunkGrid = args[1].equals("true") ? 0 : (args[1].equals("false") ? -1 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("slimeChunks")) {
            this.slimeChunks = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("mapSafeMode")) {
            this.mapSafeMode = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapOpacity")) {
            this.minimapOpacity = Double.valueOf(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointsIngameIconScale")) {
            this.waypointsIngameIconScale = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointsIngameDistanceScale")) {
            this.waypointsIngameDistanceScale = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointsIngameNameScale")) {
            this.waypointsIngameNameScale = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointsIngameCloseScale")) {
            this.waypointsIngameCloseScale = Double.valueOf(args[1]);
        } else if (args[0].equalsIgnoreCase("antiAliasing")) {
            this.antiAliasing = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("blockColours")) {
            this.blockColours = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lighting")) {
            this.lighting = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("dotsStyle")) {
            this.dotsStyle = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("dotNameScale")) {
            this.dotNameScale = Double.valueOf(args[1]);
        } else if (args[0].equalsIgnoreCase("compassOverWaypoints")) {
            this.compassOverWaypoints = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showBiome")) {
            this.showBiome = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showFlowers")) {
            this.showFlowers = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("keepWaypointNames")) {
            this.keepWaypointNames = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointsDistance")) {
            double oldValue = Double.valueOf(args[1]);
            this.waypointsDistanceExp = oldValue <= 0.0 ? 0 : (int)Math.max(3.0, Math.ceil(Math.log(oldValue) / Math.log(2.0))) - 2;
        } else if (args[0].equalsIgnoreCase("waypointsDistanceExp")) {
            this.waypointsDistanceExp = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointsDistanceMin")) {
            this.waypointsDistanceMin = Double.valueOf(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointTp")) {
            this.waypointTPCommand = "/" + args[1];
        } else if (args[0].equalsIgnoreCase("waypointTPCommand")) {
            this.waypointTPCommand = args[1].replace("^col^", ":");
        } else if (args[0].equalsIgnoreCase("arrowScale")) {
            this.arrowScale = Double.valueOf(args[1]);
        } else if (args[0].equalsIgnoreCase("arrowColour")) {
            this.arrowColour = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("seed")) {
            serverSlimeSeeds.put(args[1], Long.parseLong(args[2]));
        } else if (args[0].equalsIgnoreCase("smoothDots")) {
            this.smoothDots = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("worldMap")) {
            this.worldMap = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("terrainDepth")) {
            this.terrainDepth = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("terrainSlopes")) {
            this.terrainSlopes = args[1].equals("true") ? 2 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("alwaysArrow") && args[1].equals("true")) {
            this.mainEntityAs = 2;
        } else if (args[0].equalsIgnoreCase("mainEntityAs")) {
            this.mainEntityAs = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("blockTransparency")) {
            this.blockTransparency = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointOpacityIngame")) {
            this.waypointOpacityIngame = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointOpacityMap")) {
            this.waypointOpacityMap = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hideWorldNames")) {
            this.hideWorldNames = args[1].equals("true") ? 2 : (args[1].equals("false") ? 1 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("openSlimeSettings")) {
            this.openSlimeSettings = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("alwaysShowDistance")) {
            this.alwaysShowDistance = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showLightLevel")) {
            this.showLightLevel = args[1].equals("true") ? 1 : (args[1].equals("false") ? 0 : Integer.parseInt(args[1]));
        } else if (args[0].equalsIgnoreCase("renderLayerIndex")) {
            this.renderLayerIndex = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("crossDimensionalTp")) {
            this.crossDimensionalTp = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("showTime")) {
            this.showTime = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("biomeColorsVanillaMode")) {
            this.biomeColorsVanillaMode = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("lookingAtAngle")) {
            this.lookingAtAngle = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lookingAtAngleVertical")) {
            this.lookingAtAngleVertical = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("centeredEnlarged")) {
            this.centeredEnlarged = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("zoomedOutEnlarged")) {
            this.zoomedOutEnlarged = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapTextAlign")) {
            this.minimapTextAlign = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("showAngles")) {
            this.showAngles = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("waypointsMutualEdit")) {
            this.waypointsMutualEdit = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("compass")) {
            this.compassLocation = args[1].equals("true") ? 1 : 0;
        } else if (args[0].equalsIgnoreCase("compassLocation")) {
            this.compassLocation = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("compassScale")) {
            this.compassScale = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("caveMapsDepth")) {
            this.caveMapsDepth = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("hideWaypointCoordinates")) {
            this.hideWaypointCoordinates = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("renderAllSets")) {
            this.renderAllSets = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("playerArrowOpacity")) {
            this.playerArrowOpacity = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("waypointsBottom")) {
            this.waypointsBottom = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("minimapShape")) {
            this.minimapShape = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayType")) {
            this.lightOverlayType = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayMaxLight")) {
            this.lightOverlayMaxLight = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayMinLight")) {
            this.lightOverlayMinLight = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("lightOverlayColor")) {
            this.lightOverlayColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("uiScale")) {
            this.uiScale = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("bossHealthPushBox")) {
            this.bossHealthPushBox = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("potionEffectPushBox")) {
            this.potionEffectPushBox = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("minimapFrame")) {
            this.minimapFrame = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("minimapFrameColor")) {
            this.minimapFrameColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("compassColor")) {
            this.compassColor = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("showDimensionName")) {
            this.showDimensionName = args[1].equals("true");
        } else if (args[0].equalsIgnoreCase("displayMultipleWaypointInfo")) {
            this.displayMultipleWaypointInfo = Integer.parseInt(args[1]);
        } else if (args[0].equalsIgnoreCase("entityRadar")) {
            this.entityRadar = args[1].equals("true");
        } else if (this.entityRadarBackwardsCompatibilityConfig.readSetting(args)) {
            this.foundOldRadarSettings = true;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadWaypointsFromAllSources(WaypointsManager waypointsManager) throws IOException {
        waypointsManager.getWaypointMap().clear();
        boolean saveWaypoints = false;
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(this.modMain.getConfigFile()));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    if (!this.checkWaypointsLineOLD(args, waypointsManager)) continue;
                    saveWaypoints = true;
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
        if (this.modMain.getWaypointsFile().exists()) {
            this.loadOldWaypoints(this.modMain.getWaypointsFile(), waypointsManager);
            saveWaypoints = true;
        }
        this.loadAllWaypoints(waypointsManager);
        if (saveWaypoints) {
            this.saveAllWaypoints(waypointsManager);
            this.saveSettings();
        }
        waypointsManager.onLoad();
    }

    public void loadDefaultSettings() throws IOException {
        File mainConfigFile = this.modMain.getConfigFile();
        File defaultConfigFile = mainConfigFile.toPath().getParent().resolveSibling("defaultconfigs").resolve(mainConfigFile.getName()).toFile();
        if (defaultConfigFile.exists()) {
            this.loadSettingsFile(defaultConfigFile);
        }
    }

    public void loadSettings() throws IOException {
        this.loadDefaultSettings();
        File mainConfigFile = this.modMain.getConfigFile();
        Path configFolderPath = mainConfigFile.toPath().getParent();
        if (!Files.exists(configFolderPath, new LinkOption[0])) {
            Files.createDirectories(configFolderPath, new FileAttribute[0]);
        }
        if (mainConfigFile.exists()) {
            this.loadSettingsFile(mainConfigFile);
        }
        this.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSettingsFile(File file) throws IOException {
        try (BufferedReader reader = null;){
            String s;
            reader = new BufferedReader(new FileReader(file));
            while ((s = reader.readLine()) != null) {
                String[] args = s.split(":");
                try {
                    this.readSetting(args);
                    if (!args[0].equalsIgnoreCase("interface")) continue;
                    Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
                    while (iter.hasNext()) {
                        Interface l = iter.next();
                        if (!args[1].equals(l.getIname())) continue;
                        l.setX(Integer.parseInt(args[2]));
                        l.setY(Integer.parseInt(args[3]));
                        l.setActualx(l.getX());
                        l.setActualy(l.getY());
                        l.setCentered(args[4].equals("true"));
                        l.setFlipped(args[5].equals("true"));
                        l.setFromRight(args[6].equals("true"));
                        if (args.length > 7) {
                            l.setFromBottom(args[7].equals("true"));
                        }
                        l.backup();
                    }
                }
                catch (Exception e) {
                    System.out.println("Skipping setting:" + args[0]);
                }
            }
        }
    }

    public String getMoreOptionValueNames(ModOptions par1EnumOptions) {
        return "undefined";
    }

    private String getBooleanName(ModOptions par1EnumOptions) {
        boolean clientSetting = this.getClientBooleanValue(par1EnumOptions);
        boolean serverSetting = this.getBooleanValue(par1EnumOptions);
        return ModSettings.getTranslation(clientSetting) + (String)(serverSetting != clientSetting ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
    }

    public Object getOptionValue(ModOptions par1EnumOptions) {
        if (par1EnumOptions.enumBoolean) {
            return this.getClientBooleanValue(par1EnumOptions);
        }
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return 0;
        }
        if (par1EnumOptions == ModOptions.ZOOM) {
            return this.zoom;
        }
        if (par1EnumOptions == ModOptions.DISTANCE) {
            return this.distance;
        }
        if (par1EnumOptions == ModOptions.SLIME_CHUNKS && this.customSlimeSeedNeeded(XaeroMinimapSession.getCurrentSession())) {
            return -1;
        }
        if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            return this.caveMaps;
        }
        if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
            return this.caveZoom;
        }
        if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
            return this.hideWorldNames;
        }
        if (par1EnumOptions == ModOptions.SHOW_TIME) {
            return this.showTime;
        }
        if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
            return this.minimapTextAlign;
        }
        if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            return this.arrowColour;
        }
        if (par1EnumOptions == ModOptions.COLOURS) {
            return this.blockColours;
        }
        if (par1EnumOptions == ModOptions.TERRAIN_SLOPES) {
            return this.terrainSlopes;
        }
        if (par1EnumOptions == ModOptions.MAIN_ENTITY_AS) {
            return this.mainEntityAs;
        }
        if (par1EnumOptions == ModOptions.SHOW_LIGHT_LEVEL) {
            return this.showLightLevel;
        }
        if (par1EnumOptions == ModOptions.MINIMAP_SHAPE) {
            return this.minimapShape;
        }
        if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE) {
            return this.lightOverlayType < 0 ? 0 : this.lightOverlayType;
        }
        if (par1EnumOptions == ModOptions.DOTS_STYLE) {
            return this.dotsStyle;
        }
        if (par1EnumOptions == ModOptions.BOSS_HEALTH_PUSHBOX) {
            return this.bossHealthPushBox;
        }
        if (par1EnumOptions == ModOptions.POTION_EFFECTS_PUSHBOX) {
            return this.potionEffectPushBox;
        }
        if (par1EnumOptions == ModOptions.MINIMAP_FRAME) {
            return this.minimapFrame;
        }
        if (par1EnumOptions == ModOptions.COMPASS_LOCATION) {
            return this.compassLocation;
        }
        if (par1EnumOptions == ModOptions.MULTIPLE_WAYPOINT_INFO) {
            return this.displayMultipleWaypointInfo;
        }
        if (par1EnumOptions == ModOptions.EAMOUNT) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.ENTITY_NUMBER);
        }
        if (par1EnumOptions == ModOptions.RADAR_ICONS_DISPLAYED) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.ICONS);
        }
        if (par1EnumOptions == ModOptions.RADAR_NAMES_DISPLAYED) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.NAMES);
        }
        return this.getMoreOptionValues(par1EnumOptions);
    }

    protected Object getMoreOptionValues(ModOptions par1EnumOptions) {
        return false;
    }

    public String getOptionValueName(ModOptions par1EnumOptions) {
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return ModSettings.getTranslation(false);
        }
        if (this.usesWorldMapValue(par1EnumOptions)) {
            return "\u00a7e" + class_1074.method_4662((String)"gui.xaero_world_map", (Object[])new Object[0]);
        }
        if (par1EnumOptions.enumBoolean) {
            return this.getBooleanName(par1EnumOptions);
        }
        Object s = "";
        if (par1EnumOptions == ModOptions.ZOOM) {
            s = (String)s + zooms[this.zoom] + "x";
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            s = (String)s + class_1074.method_4662((String)distanceTypes[this.distance], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS && this.customSlimeSeedNeeded(XaeroMinimapSession.getCurrentSession())) {
            s = par1EnumOptions.getEnumString();
        } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            if (this.caveMaps == 0) {
                s = (String)s + class_1074.method_4662((String)"gui.xaero_off", (Object[])new Object[0]);
            } else {
                int roofSideSize = this.caveMaps * 2 - 1;
                s = (String)s + roofSideSize + "x" + roofSideSize + " " + class_1074.method_4662((String)"gui.xaero_roof", (Object[])new Object[0]);
                if (!this.getCaveMaps()) {
                    s = (String)s + "\u00a7e (" + ModSettings.getTranslation(false) + ")";
                }
            }
        } else if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
            s = this.caveZoom == 0 ? (String)s + class_1074.method_4662((String)"gui.xaero_off", (Object[])new Object[0]) : (String)s + (1 + this.caveZoom) + "x";
        } else if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
            s = (String)s + (this.hideWorldNames == 0 ? class_1074.method_4662((String)"gui.xaero_off", (Object[])new Object[0]) : (this.hideWorldNames == 1 ? class_1074.method_4662((String)"gui.xaero_partial", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.xaero_full", (Object[])new Object[0])));
        } else if (par1EnumOptions == ModOptions.SHOW_TIME) {
            s = (String)s + (String)(this.showTime == 0 ? class_1074.method_4662((String)"gui.xaero_off", (Object[])new Object[0]) : (String)(this.showTime < 3 ? class_1074.method_4662((String)"gui.xaero_day", (Object[])new Object[0]) + "+" : "") + ((this.showTime - 1) % 2 == 0 ? class_1074.method_4662((String)"gui.xaero_24h", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.xaero_12h", (Object[])new Object[0])));
        } else if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
            s = (String)s + (this.minimapTextAlign == 0 ? class_1074.method_4662((String)"gui.xaero_center", (Object[])new Object[0]) : (this.minimapTextAlign == 1 ? class_1074.method_4662((String)"gui.xaero_left", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.xaero_right", (Object[])new Object[0])));
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            String colourName = "gui.xaero_team";
            if (this.arrowColour != -1) {
                colourName = this.arrowColourNames[this.arrowColour];
            }
            s = (String)s + class_1074.method_4662((String)colourName, (Object[])new Object[0]);
        } else {
            s = par1EnumOptions == ModOptions.COLOURS ? (String)s + class_1074.method_4662((String)blockColourTypes[this.getBlockColours()], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.TERRAIN_SLOPES ? (String)s + class_1074.method_4662((String)SLOPES_MODES[this.terrainSlopes], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MAIN_ENTITY_AS ? (String)s + (this.mainEntityAs == 0 ? class_1074.method_4662((String)"gui.xaero_crosshair", (Object[])new Object[0]) : (this.mainEntityAs == 1 ? class_1074.method_4662((String)"gui.xaero_dot", (Object[])new Object[0]) : class_1074.method_4662((String)"gui.xaero_arrow", (Object[])new Object[0]))) : (par1EnumOptions == ModOptions.SHOW_LIGHT_LEVEL ? (String)s + class_1074.method_4662((String)SHOW_LIGHT_LEVEL_NAMES[this.showLightLevel], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MINIMAP_SHAPE ? (String)s + class_1074.method_4662((String)MINIMAP_SHAPES[this.minimapShape], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE ? (String)s + class_1074.method_4662((String)SHOW_LIGHT_LEVEL_NAMES[this.lightOverlayType < 0 ? 0 : this.lightOverlayType], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.DOTS_STYLE ? (String)s + class_1074.method_4662((String)DOTS_STYLES[this.dotsStyle], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.BOSS_HEALTH_PUSHBOX ? (String)s + class_1074.method_4662((String)PUSHBOX_OPTIONS[this.bossHealthPushBox], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.POTION_EFFECTS_PUSHBOX ? (String)s + class_1074.method_4662((String)PUSHBOX_OPTIONS[this.potionEffectPushBox], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MINIMAP_FRAME ? (String)s + class_1074.method_4662((String)FRAME_OPTIONS[this.minimapFrame], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.COMPASS_LOCATION ? (String)s + class_1074.method_4662((String)COMPASS_OPTIONS[this.compassLocation], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.MULTIPLE_WAYPOINT_INFO ? (String)s + class_1074.method_4662((String)MULTIPLE_WAYPOINT_INFO[this.displayMultipleWaypointInfo], (Object[])new Object[0]) : (par1EnumOptions == ModOptions.EAMOUNT ? (String)s + this.getRadarSettingOptionName(EntityRadarCategorySettings.ENTITY_NUMBER) : (par1EnumOptions == ModOptions.RADAR_ICONS_DISPLAYED ? (String)s + this.getRadarSettingOptionName(EntityRadarCategorySettings.ICONS) : (par1EnumOptions == ModOptions.RADAR_NAMES_DISPLAYED ? (String)s + this.getRadarSettingOptionName(EntityRadarCategorySettings.NAMES) : this.getMoreOptionValueNames(par1EnumOptions)))))))))))))));
        }
        return s;
    }

    public boolean usesWorldMapValue(ModOptions par1EnumOptions) {
        return (par1EnumOptions == ModOptions.COLOURS || par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS || par1EnumOptions == ModOptions.REDSTONE || par1EnumOptions == ModOptions.FLOWERS || par1EnumOptions == ModOptions.BIOMES_VANILLA || par1EnumOptions == ModOptions.LIGHT && !this.separateLighting() || par1EnumOptions == ModOptions.TERRAIN_DEPTH || par1EnumOptions == ModOptions.TERRAIN_SLOPES) && this.modMain.getSupportMods().shouldUseWorldMapChunks();
    }

    public String getSliderOptionText(ModOptions par1EnumOptions) {
        boolean usingSafeMode;
        String s = par1EnumOptions.getEnumString() + ": ";
        boolean bl = usingSafeMode = this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.modMain.getInterfaces().getMinimapInterface().usingFBO() || this.mapSafeMode;
        if (par1EnumOptions == ModOptions.CHUNK_GRID) {
            s = s + (String)(this.chunkGrid > -1 ? format + ENCHANT_COLORS[this.chunkGrid] + class_1074.method_4662((String)ENCHANT_COLOR_NAMES[this.chunkGrid], (Object[])new Object[0]) : class_1074.method_4662((String)"gui.xaero_off", (Object[])new Object[0]));
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_COLOR) {
            s = s + format + ENCHANT_COLORS[this.lightOverlayColor] + class_1074.method_4662((String)ENCHANT_COLOR_NAMES[this.lightOverlayColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.UI_SCALE) {
            s = s + (Serializable)(this.uiScale <= 1 ? class_1074.method_4662((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getAutoUIScale() + ")" : (this.uiScale == 11 ? class_1074.method_4662((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + (int)class_310.method_1551().method_22683().method_4495() + ")" : Integer.valueOf(this.uiScale)));
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            s = s + this.lightOverlayMaxLight;
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            s = s + this.lightOverlayMinLight;
        } else if (par1EnumOptions == ModOptions.MINIMAP_FRAME_COLOR) {
            s = s + format + ENCHANT_COLORS[this.minimapFrameColor] + class_1074.method_4662((String)ENCHANT_COLOR_NAMES[this.minimapFrameColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.COMPASS_COLOR) {
            s = s + format + ENCHANT_COLORS[this.compassColor] + class_1074.method_4662((String)ENCHANT_COLOR_NAMES[this.compassColor], (Object[])new Object[0]);
        } else if (par1EnumOptions == ModOptions.DOTS_SIZE) {
            s = s + this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.DOT_SIZE);
            if (usingSafeMode) {
                s = s + "\u00a7e (" + ModSettings.getTranslation(false) + ")";
            }
        } else if (par1EnumOptions == ModOptions.SIZE) {
            s = s + (this.minimapSize > 0 ? "" + this.minimapSize : class_1074.method_4662((String)"gui.xaero_auto_map_size", (Object[])new Object[0]) + " (" + this.getMinimapSize() + ")");
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_ICON_SCALE || par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE_SCALE) {
            int settingValue;
            int n = settingValue = par1EnumOptions == ModOptions.WAYPOINTS_ICON_SCALE ? this.waypointsIngameIconScale : this.waypointsIngameDistanceScale;
            s = s + (Serializable)(settingValue <= 0 ? class_1074.method_4662((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getAutoUIScale() + ")" : (settingValue == 17 ? class_1074.method_4662((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + (int)class_310.method_1551().method_22683().method_4495() + ")" : Integer.valueOf(settingValue)));
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_NAME_SCALE) {
            int settingValue = this.waypointsIngameNameScale;
            s = s + (Serializable)(settingValue <= 0 ? class_1074.method_4662((String)"gui.xaero_ui_scale_auto", (Object[])new Object[0]) + " (" + this.getWaypointsIngameNameScale() + ")" : (settingValue == 17 ? class_1074.method_4662((String)"gui.xaero_ui_scale_mc", (Object[])new Object[0]) + " (" + (int)class_310.method_1551().method_22683().method_4495() + ")" : Integer.valueOf(settingValue)));
        } else {
            if (par1EnumOptions == ModOptions.HEADS_SCALE) {
                return s + this.getRadarSettingOptionName(EntityRadarCategorySettings.ICON_SCALE);
            }
            if (par1EnumOptions == ModOptions.HEIGHT_LIMIT) {
                return s + this.getRadarSettingOptionName(EntityRadarCategorySettings.HEIGHT_LIMIT);
            }
            if (par1EnumOptions == ModOptions.WAYPOINTS_CLOSE_SCALE) {
                return this.getEnumFloatSliderText(s, "%.3f", par1EnumOptions);
            }
            return this.getEnumFloatSliderText(s, "%.1f", par1EnumOptions);
        }
        return s;
    }

    protected String getEnumFloatSliderText(String s, String f, ModOptions par1EnumOptions) {
        Object f1 = String.format(f, this.getOptionDoubleValue(par1EnumOptions));
        if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE) {
            double waypointsDistance = this.getMaxWaypointsDistance();
            f1 = waypointsDistance == 0.0 ? class_1074.method_4662((String)"gui.xaero_unlimited", (Object[])new Object[0]) : (int)waypointsDistance + "m";
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            f1 = this.waypointsDistanceMin == 0.0 ? class_1074.method_4662((String)"gui.xaero_off", (Object[])new Object[0]) : (int)this.waypointsDistanceMin + "m";
        } else if (par1EnumOptions == ModOptions.ARROW_SCALE) {
            f1 = (String)f1 + "x";
        }
        return s + (String)f1;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.MINIMAP) {
            return this.getMinimap();
        }
        if (o == ModOptions.CAVE_MAPS) {
            return this.getCaveMaps();
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.getShowWaypoints();
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.getDeathpoints();
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.getOldDeathpoints();
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.getShowIngameWaypoints();
        }
        if (o == ModOptions.COORDS) {
            return this.getShowCoords();
        }
        if (o == ModOptions.NORTH) {
            return this.getLockNorth(this.getMinimapSize(), this.minimapShape);
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode || this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isTriedFBO() && !this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().isLoadedFBO();
        }
        if (o == ModOptions.AA) {
            return this.getAntiAliasing();
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.getSmoothDots();
        }
        if (o == ModOptions.WORLD_MAP) {
            return this.getUseWorldMap();
        }
        if (o == ModOptions.TERRAIN_DEPTH) {
            return this.getTerrainDepth();
        }
        if (o == ModOptions.RADAR_DISPLAYED) {
            return this.getEntityRadar();
        }
        return this.getClientBooleanValue(o);
    }

    public boolean getClientBooleanValue(ModOptions o) {
        if (o.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return false;
        }
        if (o == ModOptions.IGNORE_HEIGHTMAPS) {
            return this.isIgnoreHeightmaps();
        }
        if (o == ModOptions.MINIMAP) {
            return this.minimap;
        }
        if (o == ModOptions.WAYPOINTS) {
            return this.showWaypoints;
        }
        if (o == ModOptions.DEATHPOINTS) {
            return this.deathpoints;
        }
        if (o == ModOptions.OLD_DEATHPOINTS) {
            return this.oldDeathpoints;
        }
        if (o == ModOptions.INGAME_WAYPOINTS) {
            return this.showIngameWaypoints;
        }
        if (o == ModOptions.REDSTONE) {
            return this.displayRedstone;
        }
        if (o == ModOptions.COORDS) {
            return this.showCoords;
        }
        if (o == ModOptions.NORTH) {
            return this.lockNorth;
        }
        if (o == ModOptions.SLIME_CHUNKS) {
            return this.slimeChunks;
        }
        if (o == ModOptions.SAFE_MAP) {
            return this.mapSafeMode;
        }
        if (o == ModOptions.AA) {
            return this.antiAliasing;
        }
        if (o == ModOptions.LIGHT) {
            return this.lighting;
        }
        if (o == ModOptions.COMPASS) {
            return this.compassOverWaypoints;
        }
        if (o == ModOptions.BIOME) {
            return this.showBiome;
        }
        if (o == ModOptions.FLOWERS) {
            return this.showFlowers;
        }
        if (o == ModOptions.KEEP_WP_NAMES) {
            return this.keepWaypointNames;
        }
        if (o == ModOptions.SMOOTH_DOTS) {
            return this.smoothDots;
        }
        if (o == ModOptions.WORLD_MAP) {
            return this.worldMap;
        }
        if (o == ModOptions.CAPES) {
            return Patreon.isShowCapes();
        }
        if (o == ModOptions.TERRAIN_DEPTH) {
            return this.terrainDepth;
        }
        if (o == ModOptions.BLOCK_TRANSPARENCY) {
            return this.blockTransparency;
        }
        if (o == ModOptions.OPEN_SLIME_SETTINGS) {
            return this.openSlimeSettings;
        }
        if (o == ModOptions.ALWAYS_SHOW_DISTANCE) {
            return this.alwaysShowDistance;
        }
        if (o == ModOptions.CROSS_DIMENSIONAL_TP) {
            return this.crossDimensionalTp;
        }
        if (o == ModOptions.BIOMES_VANILLA) {
            return this.biomeColorsVanillaMode;
        }
        if (o == ModOptions.CENTERED_ENLARGED) {
            return this.centeredEnlarged;
        }
        if (o == ModOptions.ZOOMED_OUT_ENLARGED) {
            return this.zoomedOutEnlarged;
        }
        if (o == ModOptions.SHOW_ANGLES) {
            return this.showAngles;
        }
        if (o == ModOptions.HIDE_WP_COORDS) {
            return this.hideWaypointCoordinates;
        }
        if (o == ModOptions.WAYPOINTS_ALL_SETS) {
            return this.renderAllSets;
        }
        if (o == ModOptions.WAYPOINTS_BOTTOM) {
            return this.waypointsBottom;
        }
        if (o == ModOptions.SHOW_DIMENSION_NAME) {
            return this.showDimensionName;
        }
        if (o == ModOptions.RADAR_DISPLAYED) {
            return this.entityRadar;
        }
        if (o == ModOptions.ENTITY_HEIGHT) {
            return this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
        }
        if (o == ModOptions.ENTITY_NAMETAGS) {
            return this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
        }
        if (o == ModOptions.ICON_NAME_FALLBACK) {
            return this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
        }
        if (o == ModOptions.UPDATE_NOTIFICATION) {
            return updateNotification;
        }
        return false;
    }

    public static String getTranslation(boolean o) {
        return class_1074.method_4662((String)("gui.xaero_" + (o ? "on" : "off")), (Object[])new Object[0]);
    }

    public void toggleBooleanOptionValue(ModOptions par1EnumOptions) {
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (!par1EnumOptions.enumBoolean) {
            return;
        }
        this.setOptionValue(par1EnumOptions, (Boolean)this.getOptionValue(par1EnumOptions) == false);
    }

    public void setOptionValue(ModOptions par1EnumOptions, Object value) {
        if (par1EnumOptions.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (this.usesWorldMapValue(par1EnumOptions)) {
            this.modMain.getSupportMods().worldmapSupport.openSettings();
            return;
        }
        if (par1EnumOptions == ModOptions.ZOOM) {
            this.zoom = (Integer)value;
        } else if (par1EnumOptions == ModOptions.MINIMAP) {
            this.minimap = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.CAVE_MAPS) {
            this.caveMaps = (Integer)value;
        } else if (par1EnumOptions == ModOptions.CAVE_ZOOM) {
            this.caveZoom = (Integer)value;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS) {
            this.showWaypoints = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.DEATHPOINTS) {
            this.deathpoints = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.OLD_DEATHPOINTS) {
            this.oldDeathpoints = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.INGAME_WAYPOINTS) {
            this.showIngameWaypoints = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.REDSTONE) {
            this.displayRedstone = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.DISTANCE) {
            this.distance = (Integer)value;
        } else if (par1EnumOptions == ModOptions.COORDS) {
            this.showCoords = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.NORTH) {
            this.lockNorth = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.SLIME_CHUNKS) {
            minimapSession = XaeroMinimapSession.getCurrentSession();
            if (this.customSlimeSeedNeeded(minimapSession)) {
                class_437 current = class_310.method_1551().field_1755;
                class_437 currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                class_310.method_1551().method_1507((class_437)new GuiSlimeSeed(this.modMain, minimapSession.getWaypointsManager(), current, currentEscScreen));
                return;
            }
            this.slimeChunks = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.SAFE_MAP) {
            this.mapSafeMode = (Boolean)value;
            minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
            this.refreshScreen();
        } else if (par1EnumOptions == ModOptions.AA) {
            this.antiAliasing = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.COLOURS) {
            this.blockColours = (Integer)value;
        } else if (par1EnumOptions == ModOptions.LIGHT) {
            this.lighting = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.COMPASS) {
            this.compassOverWaypoints = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.BIOME) {
            this.showBiome = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.FLOWERS) {
            this.showFlowers = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.KEEP_WP_NAMES) {
            this.keepWaypointNames = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.ARROW_COLOUR) {
            this.arrowColour = (Integer)value;
        } else if (par1EnumOptions == ModOptions.SMOOTH_DOTS) {
            this.smoothDots = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.DOTS_STYLE) {
            this.dotsStyle = (Integer)value;
        } else if (par1EnumOptions == ModOptions.WORLD_MAP) {
            this.worldMap = (Boolean)value;
            this.refreshScreen();
        } else if (par1EnumOptions == ModOptions.CAPES) {
            Patreon.setShowCapes((Boolean)value);
            Patreon.saveSettings();
        } else if (par1EnumOptions == ModOptions.TERRAIN_DEPTH) {
            this.terrainDepth = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.TERRAIN_SLOPES) {
            this.terrainSlopes = (Integer)value;
        } else if (par1EnumOptions == ModOptions.MAIN_ENTITY_AS) {
            this.mainEntityAs = (Integer)value;
        } else if (par1EnumOptions == ModOptions.BLOCK_TRANSPARENCY) {
            this.blockTransparency = (Boolean)value;
            minimapSession = XaeroMinimapSession.getCurrentSession();
            if (minimapSession != null) {
                minimapSession.getMinimapProcessor().setToResetImage(true);
            }
        } else if (par1EnumOptions == ModOptions.HIDE_WORLD_NAMES) {
            this.hideWorldNames = (Integer)value;
        } else if (par1EnumOptions == ModOptions.OPEN_SLIME_SETTINGS) {
            this.openSlimeSettings = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.ALWAYS_SHOW_DISTANCE) {
            this.alwaysShowDistance = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.SHOW_LIGHT_LEVEL) {
            this.showLightLevel = (Integer)value;
        } else if (par1EnumOptions == ModOptions.CROSS_DIMENSIONAL_TP) {
            this.crossDimensionalTp = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.SHOW_TIME) {
            this.showTime = (Integer)value;
        } else if (par1EnumOptions == ModOptions.BIOMES_VANILLA) {
            this.biomeColorsVanillaMode = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.CENTERED_ENLARGED) {
            this.centeredEnlarged = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.ZOOMED_OUT_ENLARGED) {
            this.zoomedOutEnlarged = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.MINIMAP_TEXT_ALIGN) {
            this.minimapTextAlign = (Integer)value;
        } else if (par1EnumOptions == ModOptions.SHOW_ANGLES) {
            this.showAngles = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.COMPASS_LOCATION) {
            this.compassLocation = (Integer)value;
        } else if (par1EnumOptions == ModOptions.HIDE_WP_COORDS) {
            this.hideWaypointCoordinates = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_ALL_SETS) {
            this.renderAllSets = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.IGNORE_HEIGHTMAPS) {
            WaypointWorldRootContainer currentRootContainer = XaeroMinimapSession.getCurrentSession().getWaypointsManager().getAutoWorld().getContainer().getRootContainer();
            currentRootContainer.setIgnoreHeightmaps((Boolean)value);
            currentRootContainer.saveConfig();
        } else if (par1EnumOptions == ModOptions.WAYPOINTS_BOTTOM) {
            this.waypointsBottom = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.MINIMAP_SHAPE) {
            this.minimapShape = (Integer)value;
        } else if (par1EnumOptions == ModOptions.LIGHT_OVERLAY_TYPE) {
            this.lightOverlayType = (Integer)value;
        } else if (par1EnumOptions == ModOptions.BOSS_HEALTH_PUSHBOX) {
            this.bossHealthPushBox = (Integer)value;
        } else if (par1EnumOptions == ModOptions.POTION_EFFECTS_PUSHBOX) {
            this.potionEffectPushBox = (Integer)value;
        } else if (par1EnumOptions == ModOptions.MINIMAP_FRAME) {
            this.minimapFrame = (Integer)value;
        } else if (par1EnumOptions == ModOptions.SHOW_DIMENSION_NAME) {
            this.showDimensionName = (Boolean)value;
        } else if (par1EnumOptions == ModOptions.MULTIPLE_WAYPOINT_INFO) {
            this.displayMultipleWaypointInfo = (Integer)value;
        } else if (par1EnumOptions == ModOptions.RADAR_DISPLAYED) {
            this.entityRadar = (Boolean)value;
        } else {
            if (par1EnumOptions == ModOptions.EAMOUNT) {
                this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.ENTITY_NUMBER, (Integer)value);
                this.modMain.getEntityRadarCategoryManager().save();
                return;
            }
            if (par1EnumOptions == ModOptions.ENTITY_HEIGHT) {
                this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.HEIGHT_FADE, (Boolean)value != false ? 1 : 0);
                this.modMain.getEntityRadarCategoryManager().save();
                return;
            }
            if (par1EnumOptions == ModOptions.ENTITY_NAMETAGS) {
                this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.ALWAYS_NAMETAGS, (Boolean)value != false ? 1 : 0);
                this.modMain.getEntityRadarCategoryManager().save();
                return;
            }
            if (par1EnumOptions == ModOptions.ICON_NAME_FALLBACK) {
                this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.ICON_NAME_FALLBACK, (Boolean)value != false ? 1 : 0);
                this.modMain.getEntityRadarCategoryManager().save();
                return;
            }
            if (par1EnumOptions == ModOptions.RADAR_ICONS_DISPLAYED) {
                this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.ICONS, (Integer)value);
                this.modMain.getEntityRadarCategoryManager().save();
                return;
            }
            if (par1EnumOptions == ModOptions.RADAR_NAMES_DISPLAYED) {
                this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.NAMES, (Integer)value);
                this.modMain.getEntityRadarCategoryManager().save();
                return;
            }
            if (par1EnumOptions == ModOptions.UPDATE_NOTIFICATION) {
                updateNotification = !updateNotification;
            }
        }
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void refreshScreen() {
        class_437 currentScreen = class_310.method_1551().field_1755;
        GuiSettings settingsScreen = currentScreen instanceof GuiSettings ? (GuiSettings)currentScreen : null;
        int focusedIndex = -1;
        if (settingsScreen != null) {
            focusedIndex = settingsScreen.getIndex(settingsScreen.method_25399());
        }
        class_310.method_1551().method_1507(currentScreen);
        settingsScreen.restoreFocus(focusedIndex);
    }

    public void setOptionDoubleValue(ModOptions options, double d) {
        if (options.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return;
        }
        if (options == ModOptions.OPACITY) {
            this.minimapOpacity = d;
        }
        if (options == ModOptions.WAYPOINTS_ICON_SCALE) {
            this.waypointsIngameIconScale = (int)d;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_SCALE) {
            this.waypointsIngameDistanceScale = (int)d;
        }
        if (options == ModOptions.WAYPOINTS_NAME_SCALE) {
            this.waypointsIngameNameScale = (int)d;
        }
        if (options == ModOptions.WAYPOINTS_CLOSE_SCALE) {
            this.waypointsIngameCloseScale = d;
        }
        if (options == ModOptions.DOT_NAME_SCALE) {
            this.dotNameScale = d;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            this.waypointsDistanceExp = (int)d;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            this.waypointsDistanceMin = (int)d;
        }
        if (options == ModOptions.ARROW_SCALE) {
            this.arrowScale = d;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_INGAME) {
            this.waypointOpacityIngame = (int)d;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_MAP) {
            this.waypointOpacityMap = (int)d;
        }
        if (options == ModOptions.WAYPOINT_LOOKING_ANGLE) {
            this.lookingAtAngle = (int)d;
        }
        if (options == ModOptions.WAYPOINT_VERTICAL_LOOKING_ANGLE) {
            this.lookingAtAngleVertical = (int)d;
        }
        if (options == ModOptions.CAVE_MAPS_DEPTH) {
            this.caveMapsDepth = (int)d;
        }
        if (options == ModOptions.CHUNK_GRID) {
            this.chunkGrid = (int)d;
        }
        if (options == ModOptions.PLAYER_ARROW_OPACITY) {
            this.playerArrowOpacity = (int)d;
        }
        if (options == ModOptions.LIGHT_OVERLAY_COLOR) {
            this.lightOverlayColor = (int)d;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            this.lightOverlayMaxLight = (int)d;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            this.lightOverlayMinLight = (int)d;
        }
        if (options == ModOptions.SIZE) {
            this.minimapSize = d == 54.0 ? 0 : (int)d;
        }
        if (options == ModOptions.UI_SCALE) {
            this.uiScale = (int)d;
        }
        if (options == ModOptions.MINIMAP_FRAME_COLOR) {
            this.minimapFrameColor = (int)d;
        }
        if (options == ModOptions.COMPASS_SCALE) {
            this.compassScale = (int)d;
        }
        if (options == ModOptions.COMPASS_COLOR) {
            this.compassColor = (int)d;
        }
        if (options == ModOptions.DOTS_SIZE) {
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.DOT_SIZE, (int)d);
            return;
        }
        if (options == ModOptions.HEADS_SCALE) {
            XaeroMinimapSession minimapSession;
            double currentScale = this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ICON_SCALE);
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.ICON_SCALE, (int)d);
            double newScale = this.modMain.getEntityRadarCategoryManager().getRootCategory().getSettingValue(EntityRadarCategorySettings.ICON_SCALE);
            if (newScale < 1.0 || newScale < 1.0 != currentScale < 1.0) {
                this.modMain.getInterfaces().getMinimapInterface().getMinimapFBORenderer().resetEntityIcons();
            }
            if ((minimapSession = XaeroMinimapSession.getCurrentSession()) != null) {
                MinimapProcessor minimapProcessor = minimapSession.getMinimapProcessor();
                MinimapRadar radar = minimapProcessor.getEntityRadar();
                radar.updateRadar(class_310.method_1551().field_1687, (class_1657)class_310.method_1551().field_1724, class_310.method_1551().method_1560(), minimapProcessor);
            }
            return;
        }
        if (options == ModOptions.HEIGHT_LIMIT) {
            this.setOptionIndexForRadarSetting(EntityRadarCategorySettings.HEIGHT_LIMIT, (int)d);
            return;
        }
        try {
            this.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public double getOptionDoubleValue(ModOptions options) {
        if (options.isIngameOnly() && !ModSettings.canEditIngameSettings()) {
            return 0.0;
        }
        if (options == ModOptions.OPACITY) {
            return this.minimapOpacity;
        }
        if (options == ModOptions.WAYPOINTS_ICON_SCALE) {
            return this.waypointsIngameIconScale;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_SCALE) {
            return this.waypointsIngameDistanceScale;
        }
        if (options == ModOptions.WAYPOINTS_NAME_SCALE) {
            return this.waypointsIngameNameScale;
        }
        if (options == ModOptions.WAYPOINTS_CLOSE_SCALE) {
            return this.waypointsIngameCloseScale;
        }
        if (options == ModOptions.DOT_NAME_SCALE) {
            return this.dotNameScale;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE) {
            return this.waypointsDistanceExp;
        }
        if (options == ModOptions.WAYPOINTS_DISTANCE_MIN) {
            return this.waypointsDistanceMin;
        }
        if (options == ModOptions.ARROW_SCALE) {
            return this.arrowScale;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_INGAME) {
            return this.waypointOpacityIngame;
        }
        if (options == ModOptions.WAYPOINT_OPACITY_MAP) {
            return this.waypointOpacityMap;
        }
        if (options == ModOptions.WAYPOINT_LOOKING_ANGLE) {
            return this.lookingAtAngle;
        }
        if (options == ModOptions.WAYPOINT_VERTICAL_LOOKING_ANGLE) {
            return this.lookingAtAngleVertical;
        }
        if (options == ModOptions.CAVE_MAPS_DEPTH) {
            return this.caveMapsDepth;
        }
        if (options == ModOptions.CHUNK_GRID) {
            return this.chunkGrid;
        }
        if (options == ModOptions.PLAYER_ARROW_OPACITY) {
            return this.playerArrowOpacity;
        }
        if (options == ModOptions.LIGHT_OVERLAY_COLOR) {
            return this.lightOverlayColor;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MAX_LIGHT) {
            return this.lightOverlayMaxLight;
        }
        if (options == ModOptions.LIGHT_OVERLAY_MIN_LIGHT) {
            return this.lightOverlayMinLight;
        }
        if (options == ModOptions.SIZE) {
            return this.minimapSize;
        }
        if (options == ModOptions.UI_SCALE) {
            return this.uiScale;
        }
        if (options == ModOptions.MINIMAP_FRAME_COLOR) {
            return this.minimapFrameColor;
        }
        if (options == ModOptions.COMPASS_SCALE) {
            return this.compassScale;
        }
        if (options == ModOptions.COMPASS_COLOR) {
            return this.compassColor;
        }
        if (options == ModOptions.DOTS_SIZE) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.DOT_SIZE);
        }
        if (options == ModOptions.HEADS_SCALE) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.ICON_SCALE);
        }
        if (options == ModOptions.HEIGHT_LIMIT) {
            return this.getOptionIndexForRadarSetting(EntityRadarCategorySettings.HEIGHT_LIMIT);
        }
        return 1.0;
    }

    private <T> int getOptionIndexForRadarSetting(ObjectCategorySetting<T> setting) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        return setting.getIndexWriter().apply(rootCategory.getSettingValue(setting));
    }

    public boolean minimapDisabled() {
        return (serverSettings & 1) != 1;
    }

    public boolean caveMapsDisabled() {
        return (serverSettings & 0x4000) != 16384;
    }

    public boolean showWaypointsDisabled() {
        return (serverSettings & 0x10000) != 65536;
    }

    public boolean deathpointsDisabled() {
        return (serverSettings & 0x200000) == 0;
    }

    public void resetServerSettings() {
        serverSettings = defaultSettings;
    }

    public static void setServerSettings() {
    }

    public static boolean canEditIngameSettings() {
        XaeroMinimapSession minimapSession = XaeroMinimapSession.getCurrentSession();
        return minimapSession != null && minimapSession.getWaypointsManager().getAutoContainerID() != null;
    }

    private <T> String getRadarSettingOptionName(ObjectCategorySetting<T> setting) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        return setting.getWidgetValueNameProvider().apply(rootCategory.getSettingValue(setting));
    }

    private <T> void setOptionIndexForRadarSetting(ObjectCategorySetting<T> setting, int index) {
        EntityRadarCategory rootCategory = this.modMain.getEntityRadarCategoryManager().getRootCategory();
        rootCategory.setSettingValue(setting, setting.getIndexReader().apply(index));
    }

    public EntityRadarBackwardsCompatibilityConfig getEntityRadarBackwardsCompatibilityConfig() {
        return this.entityRadarBackwardsCompatibilityConfig;
    }

    public void resetEntityRadarBackwardsCompatibilityConfig() {
        this.entityRadarBackwardsCompatibilityConfig = new EntityRadarBackwardsCompatibilityConfig();
        this.foundOldRadarSettings = false;
    }

    public boolean foundOldRadarSettings() {
        return this.foundOldRadarSettings;
    }

    static {
        ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
        ENCHANT_COLOR_NAMES = new String[]{"gui.xaero_black", "gui.xaero_dark_blue", "gui.xaero_dark_green", "gui.xaero_dark_aqua", "gui.xaero_dark_red", "gui.xaero_dark_purple", "gui.xaero_gold", "gui.xaero_gray", "gui.xaero_dark_gray", "gui.xaero_blue", "gui.xaero_green", "gui.xaero_aqua", "gui.xaero_red", "gui.xaero_purple", "gui.xaero_yellow", "gui.xaero_white"};
        COLORS = new int[]{-16777216, -16777046, -16733696, -16733526, -5636096, -5635926, -22016, -5592406, -11184811, -11184641, -11141291, -11141121, -65536, -43521, -171, -1};
        keyBindZoom = new class_304("gui.xaero_zoom_in", -1, "Xaero's Minimap");
        keyBindZoom1 = new class_304("gui.xaero_zoom_out", -1, "Xaero's Minimap");
        newWaypoint = new class_304("gui.xaero_new_waypoint", 66, "Xaero's Minimap");
        keyWaypoints = new class_304("gui.xaero_waypoints_key", 85, "Xaero's Minimap");
        keyLargeMap = new class_304("gui.xaero_enlarge_map", 90, "Xaero's Minimap");
        keyToggleMap = new class_304("gui.xaero_toggle_map", -1, "Xaero's Minimap");
        keyToggleWaypoints = new class_304("gui.xaero_toggle_waypoints", -1, "Xaero's Minimap");
        keyToggleMapWaypoints = new class_304("gui.xaero_toggle_map_waypoints", -1, "Xaero's Minimap");
        keyToggleSlimes = new class_304("gui.xaero_toggle_slime", -1, "Xaero's Minimap");
        keyToggleGrid = new class_304("gui.xaero_toggle_grid", -1, "Xaero's Minimap");
        keyInstantWaypoint = new class_304("gui.xaero_instant_waypoint", 334, "Xaero's Minimap");
        keySwitchSet = new class_304("gui.xaero_switch_waypoint_set", -1, "Xaero's Minimap");
        keyAllSets = new class_304("gui.xaero_display_all_sets", -1, "Xaero's Minimap");
        keyLightOverlay = new class_304("gui.xaero_toggle_light_overlay", -1, "Xaero's Minimap");
        keyToggleRadar = new class_304("gui.xaero_toggle_entity_radar", -1, "Xaero's Minimap");
        minimapItemId = null;
        minimapItem = null;
        zooms = new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f};
        serverSlimeSeeds = new HashMap();
        distanceTypes = new String[]{"gui.xaero_off", "gui.xaero_looking_at", "gui.xaero_all"};
        blockColourTypes = new String[]{"gui.xaero_accurate", "gui.xaero_vanilla"};
        settingsButton = false;
        updateNotification = true;
        arrowColours = new float[][]{{0.8f, 0.1f, 0.1f, 1.0f}, {0.09f, 0.57f, 0.0f, 1.0f}, {0.0f, 0.55f, 1.0f, 1.0f}, {1.0f, 0.93f, 0.0f, 1.0f}, {0.73f, 0.33f, 0.83f, 1.0f}, {1.0f, 1.0f, 1.0f, 1.0f}, {0.0f, 0.0f, 0.0f, 1.0f}, {0.4588f, 0.0f, 0.0f, 1.0f}};
        ENTITY_ICONS_OPTIONS = new String[]{"gui.xaero_icons_off", "gui.xaero_icons_list", "gui.xaero_icons_always", "-"};
        SLOPES_MODES = new String[]{"gui.xaero_off", "gui.xaero_slopes_legacy", "gui.xaero_slopes_default_3d", "gui.xaero_slopes_default_2d"};
        ENTITY_NAMES_OPTIONS = new String[]{"gui.xaero_names_off", "gui.xaero_names_list", "gui.xaero_names_always", "-"};
        SHOW_LIGHT_LEVEL_NAMES = new String[]{"gui.xaero_off", "gui.xaero_light_block", "gui.xaero_light_sky", "gui.xaero_light_both"};
        MINIMAP_SHAPES = new String[]{"gui.xaero_minimap_shape_square", "gui.xaero_minimap_shape_circle"};
        DOTS_STYLES = new String[]{"gui.xaero_dots_style_default", "gui.xaero_dots_style_legacy"};
        PUSHBOX_OPTIONS = new String[]{"gui.xaero_off", "gui.xaero_pushbox_normal", "gui.xaero_pushbox_screen_height"};
        FRAME_OPTIONS = new String[]{"gui.xaero_minimap_frame_default", "gui.xaero_minimap_frame_colored_thick", "gui.xaero_minimap_frame_colored_thin", "gui.xaero_off"};
        COMPASS_OPTIONS = new String[]{"gui.xaero_off", "gui.xaero_minimap_compass_inside_frame", "gui.xaero_minimap_compass_on_frame"};
        MULTIPLE_WAYPOINT_INFO = new String[]{"gui.xaero_off", "gui.xaero_while_sneaking", "gui.xaero_multiple_waypoints_always"};
        OLD_MINIMAP_SIZES = new int[]{57, 85, 113, 169};
    }
}

