/*
 * Decompiled with CFR 0.152.
 */
package net.optifine;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Properties;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_757;
import net.optifine.Config;
import net.optifine.CustomLoadingScreens;

public class CustomLoadingScreen {
    private class_2960 locationTexture;
    private int scaleMode = 0;
    private int scale = 2;
    private boolean center;
    private static final int SCALE_DEFAULT = 2;
    private static final int SCALE_MODE_FIXED = 0;
    private static final int SCALE_MODE_FULL = 1;
    private static final int SCALE_MODE_STRETCH = 2;

    public CustomLoadingScreen(class_2960 locationTexture, int scaleMode, int scale, boolean center) {
        this.locationTexture = locationTexture;
        this.scaleMode = scaleMode;
        this.scale = scale;
        this.center = center;
    }

    public static CustomLoadingScreen parseScreen(String path, int dimId, Properties props) {
        class_2960 loc = new class_2960(path);
        int scaleMode = CustomLoadingScreen.parseScaleMode(CustomLoadingScreen.getProperty("scaleMode", dimId, props));
        int scaleDef = scaleMode == 0 ? 2 : 1;
        int scale = CustomLoadingScreen.parseScale(CustomLoadingScreen.getProperty("scale", dimId, props), scaleDef);
        boolean center = Config.parseBoolean(CustomLoadingScreen.getProperty("center", dimId, props), false);
        CustomLoadingScreen scr = new CustomLoadingScreen(loc, scaleMode, scale, center);
        return scr;
    }

    private static String getProperty(String key, int dim, Properties props) {
        if (props == null) {
            return null;
        }
        String val = props.getProperty("dim" + dim + "." + key);
        if (val != null) {
            return val;
        }
        val = props.getProperty(key);
        return val;
    }

    private static int parseScaleMode(String str) {
        if (str == null) {
            return 0;
        }
        if ((str = str.toLowerCase().trim()).equals("fixed")) {
            return 0;
        }
        if (str.equals("full")) {
            return 1;
        }
        if (str.equals("stretch")) {
            return 2;
        }
        CustomLoadingScreens.warn("Invalid scale mode: " + str);
        return 0;
    }

    private static int parseScale(String str, int def) {
        if (str == null) {
            return def;
        }
        int val = Config.parseInt(str = str.trim(), -1);
        if (val < 1) {
            CustomLoadingScreens.warn("Invalid scale: " + str);
            return def;
        }
        return val;
    }

    public void drawBackground(int width, int height) {
        class_289 tessellator = class_289.method_1348();
        class_287 bufferbuilder = tessellator.method_1349();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture(0, this.locationTexture);
        RenderSystem.setShaderColor(1.0f, 1.0f, 1.0f, 1.0f);
        float div = 16 * this.scale;
        float uMax = (float)width / div;
        float vMax = (float)height / div;
        float du = 0.0f;
        float dv = 0.0f;
        if (this.center) {
            du = (div - (float)width) / (div * 2.0f);
            dv = (div - (float)height) / (div * 2.0f);
        }
        switch (this.scaleMode) {
            case 1: {
                div = Math.max(width, height);
                uMax = (float)(this.scale * width) / div;
                vMax = (float)(this.scale * height) / div;
                if (!this.center) break;
                du = (float)this.scale * (div - (float)width) / (div * 2.0f);
                dv = (float)this.scale * (div - (float)height) / (div * 2.0f);
                break;
            }
            case 2: {
                uMax = this.scale;
                vMax = this.scale;
                du = 0.0f;
                dv = 0.0f;
            }
        }
        bufferbuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1575);
        bufferbuilder.method_22912(0.0, height, 0.0).method_22913(du, dv + vMax).method_1336(255, 255, 255, 255).method_1344();
        bufferbuilder.method_22912(width, height, 0.0).method_22913(du + uMax, dv + vMax).method_1336(255, 255, 255, 255).method_1344();
        bufferbuilder.method_22912(width, 0.0, 0.0).method_22913(du + uMax, dv).method_1336(255, 255, 255, 255).method_1344();
        bufferbuilder.method_22912(0.0, 0.0, 0.0).method_22913(du, dv).method_1336(255, 255, 255, 255).method_1344();
        tessellator.method_1350();
    }
}

