/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;

public enum Direction implements StringRepresentable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0));

    public static final Codec<Direction> f_289994_;
    private final int f_122339_;
    private final int f_122340_;
    private final int f_122341_;
    private final String f_122342_;
    private final Axis f_122343_;
    private final AxisDirection f_122344_;
    private final Vec3i f_122345_;
    public static final Direction[] f_122346_;
    private static final Map<String, Direction> f_122347_;
    public static final Direction[] f_122348_;
    private static final Direction[] f_122349_;
    private static final Long2ObjectMap<Direction> f_122350_;

    private Direction(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn, Vec3i directionVecIn) {
        this.f_122339_ = indexIn;
        this.f_122341_ = horizontalIndexIn;
        this.f_122340_ = oppositeIn;
        this.f_122342_ = nameIn;
        this.f_122343_ = axisIn;
        this.f_122344_ = axisDirectionIn;
        this.f_122345_ = directionVecIn;
    }

    public static Direction[] m_122382_(Entity entityIn) {
        Direction direction2;
        float f = entityIn.m_5686_(1.0f) * ((float)Math.PI / 180);
        float f1 = -entityIn.m_5675_(1.0f) * ((float)Math.PI / 180);
        float f2 = Mth.m_14031_(f);
        float f3 = Mth.m_14089_(f);
        float f4 = Mth.m_14031_(f1);
        float f5 = Mth.m_14089_(f1);
        boolean flag = f4 > 0.0f;
        boolean flag1 = f2 < 0.0f;
        boolean flag2 = f5 > 0.0f;
        float f6 = flag ? f4 : -f4;
        float f7 = flag1 ? -f2 : f2;
        float f8 = flag2 ? f5 : -f5;
        float f9 = f6 * f3;
        float f10 = f8 * f3;
        Direction direction = flag ? EAST : WEST;
        Direction direction1 = flag1 ? UP : DOWN;
        Direction direction3 = direction2 = flag2 ? SOUTH : NORTH;
        if (f6 > f8) {
            if (f7 > f9) {
                return Direction.m_122398_(direction1, direction, direction2);
            }
            return f10 > f7 ? Direction.m_122398_(direction, direction2, direction1) : Direction.m_122398_(direction, direction1, direction2);
        }
        if (f7 > f10) {
            return Direction.m_122398_(direction1, direction2, direction);
        }
        return f9 > f7 ? Direction.m_122398_(direction2, direction, direction1) : Direction.m_122398_(direction2, direction1, direction);
    }

    private static Direction[] m_122398_(Direction first, Direction second, Direction third) {
        return new Direction[]{first, second, third, third.m_122424_(), second.m_122424_(), first.m_122424_()};
    }

    public static Direction m_122384_(Matrix4f matrixIn, Direction directionIn) {
        Vec3i vec3i = directionIn.m_122436_();
        Vector4f vector4f = new Vector4f((float)vec3i.m_123341_(), (float)vec3i.m_123342_(), (float)vec3i.m_123343_(), 0.0f);
        vector4f.m_123607_(matrixIn);
        return Direction.m_122372_(vector4f.m_123601_(), vector4f.m_123615_(), vector4f.m_123616_());
    }

    public Quaternion m_122406_() {
        Quaternion quaternion = Vector3f.f_122223_.m_122240_(90.0f);
        switch (this) {
            case DOWN: {
                return Vector3f.f_122223_.m_122240_(180.0f);
            }
            case UP: {
                return Quaternion.f_80118_.m_80161_();
            }
            case NORTH: {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(180.0f));
                return quaternion;
            }
            case SOUTH: {
                return quaternion;
            }
            case WEST: {
                quaternion.m_80148_(Vector3f.f_122227_.m_122240_(90.0f));
                return quaternion;
            }
        }
        quaternion.m_80148_(Vector3f.f_122227_.m_122240_(-90.0f));
        return quaternion;
    }

    public int m_122411_() {
        return this.f_122339_;
    }

    public int m_122416_() {
        return this.f_122341_;
    }

    public AxisDirection m_122421_() {
        return this.f_122344_;
    }

    public static Direction m_213598_(Entity entityIn, Axis axisIn) {
        switch (axisIn) {
            case X: {
                return EAST.m_122370_(entityIn.m_5675_(1.0f)) ? EAST : WEST;
            }
            case Z: {
                return SOUTH.m_122370_(entityIn.m_5675_(1.0f)) ? SOUTH : NORTH;
            }
        }
        return entityIn.m_5686_(1.0f) < 0.0f ? UP : DOWN;
    }

    public Direction m_122424_() {
        return f_122346_[this.f_122340_];
    }

    public Direction m_317183_(Axis axisIn) {
        switch (axisIn) {
            case X: {
                if (this != WEST && this != EAST) {
                    return this.m_317187_();
                }
                return this;
            }
            case Z: {
                if (this != NORTH && this != SOUTH) {
                    return this.m_317189_();
                }
                return this;
            }
            case Y: {
                if (this != UP && this != DOWN) {
                    return this.m_122427_();
                }
                return this;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axisIn);
    }

    public Direction m_317185_(Axis axisIn) {
        switch (axisIn) {
            case X: {
                if (this != WEST && this != EAST) {
                    return this.m_317188_();
                }
                return this;
            }
            case Z: {
                if (this != NORTH && this != SOUTH) {
                    return this.m_317190_();
                }
                return this;
            }
            case Y: {
                if (this != UP && this != DOWN) {
                    return this.m_122428_();
                }
                return this;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + axisIn);
    }

    public Direction m_122427_() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
            case EAST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + (Object)((Object)this));
    }

    private Direction m_317187_() {
        switch (this) {
            case DOWN: {
                return SOUTH;
            }
            case UP: {
                return NORTH;
            }
            case NORTH: {
                return DOWN;
            }
            case SOUTH: {
                return UP;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + (Object)((Object)this));
    }

    private Direction m_317188_() {
        switch (this) {
            case DOWN: {
                return NORTH;
            }
            case UP: {
                return SOUTH;
            }
            case NORTH: {
                return UP;
            }
            case SOUTH: {
                return DOWN;
            }
        }
        throw new IllegalStateException("Unable to get X-rotated facing of " + (Object)((Object)this));
    }

    private Direction m_317189_() {
        switch (this) {
            case DOWN: {
                return WEST;
            }
            case UP: {
                return EAST;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + (Object)((Object)this));
            }
            case WEST: {
                return UP;
            }
            case EAST: 
        }
        return DOWN;
    }

    private Direction m_317190_() {
        switch (this) {
            case DOWN: {
                return EAST;
            }
            case UP: {
                return WEST;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + (Object)((Object)this));
            }
            case WEST: {
                return DOWN;
            }
            case EAST: 
        }
        return UP;
    }

    public Direction m_122428_() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
            case EAST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + (Object)((Object)this));
    }

    public int m_122429_() {
        return this.f_122345_.m_123341_();
    }

    public int m_122430_() {
        return this.f_122345_.m_123342_();
    }

    public int m_122431_() {
        return this.f_122345_.m_123343_();
    }

    public Vector3f m_122432_() {
        return new Vector3f((float)this.m_122429_(), (float)this.m_122430_(), (float)this.m_122431_());
    }

    public String m_122433_() {
        return this.f_122342_;
    }

    public Axis m_122434_() {
        return this.f_122343_;
    }

    @Nullable
    public static Direction m_122402_(@Nullable String name) {
        return name == null ? null : f_122347_.get(name.toLowerCase(Locale.ROOT));
    }

    public static Direction m_122376_(int index) {
        return f_122348_[Mth.m_14040_(index % f_122348_.length)];
    }

    public static Direction m_122407_(int horizontalIndexIn) {
        return f_122349_[Mth.m_14040_(horizontalIndexIn % f_122349_.length)];
    }

    @Nullable
    public static Direction m_317181_(BlockPos posIn) {
        return (Direction)((Object)f_122350_.get(posIn.m_121878_()));
    }

    @Nullable
    public static Direction m_122378_(int x, int y, int z) {
        return (Direction)((Object)f_122350_.get(BlockPos.m_121882_((int)x, (int)y, (int)z)));
    }

    public static Direction m_122364_(double angle) {
        return Direction.m_122407_(Mth.m_14107_(angle / 90.0 + 0.5) & 3);
    }

    public static Direction m_122387_(Axis axisIn, AxisDirection axisDirectionIn) {
        switch (axisIn) {
            case X: {
                return axisDirectionIn == AxisDirection.POSITIVE ? EAST : WEST;
            }
            default: {
                return axisDirectionIn == AxisDirection.POSITIVE ? SOUTH : NORTH;
            }
            case Y: 
        }
        return axisDirectionIn == AxisDirection.POSITIVE ? UP : DOWN;
    }

    public float m_122435_() {
        return (this.f_122341_ & 3) * 90;
    }

    public static Direction m_122404_(Random rand) {
        return Util.m_137545_(f_122346_, rand);
    }

    public static Direction m_122366_(double x, double y, double z) {
        return Direction.m_122372_((float)x, (float)y, (float)z);
    }

    public static Direction m_122372_(float x, float y, float z) {
        Direction direction = NORTH;
        float f = Float.MIN_VALUE;
        for (Direction direction1 : f_122346_) {
            float f1 = x * (float)direction1.f_122345_.m_123341_() + y * (float)direction1.f_122345_.m_123342_() + z * (float)direction1.f_122345_.m_123343_();
            if (!(f1 > f)) continue;
            f = f1;
            direction = direction1;
        }
        return direction;
    }

    public String toString() {
        return this.f_122342_;
    }

    public String m_7912_() {
        return this.f_122342_;
    }

    public static Direction m_122390_(AxisDirection axisDirectionIn, Axis axisIn) {
        for (Direction direction : f_122346_) {
            if (direction.m_122421_() != axisDirectionIn || direction.m_122434_() != axisIn) continue;
            return direction;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirectionIn) + " " + axisIn);
    }

    public Vec3i m_122436_() {
        return this.f_122345_;
    }

    public boolean m_122370_(float p_122370_1_) {
        float f = p_122370_1_ * ((float)Math.PI / 180);
        float f1 = -Mth.m_14031_(f);
        float f2 = Mth.m_14089_(f);
        return (float)this.f_122345_.m_123341_() * f1 + (float)this.f_122345_.m_123343_() * f2 > 0.0f;
    }

    static {
        f_289994_ = StringRepresentable.m_14350_(Direction::values, Direction::m_122402_);
        f_122346_ = Direction.values();
        f_122347_ = Arrays.stream(f_122346_).collect(Collectors.toMap(Direction::m_122433_, p_122425_0_ -> p_122425_0_));
        f_122348_ = (Direction[])Arrays.stream(f_122346_).sorted(Comparator.comparingInt(p_122422_0_ -> p_122422_0_.f_122339_)).toArray(Direction[]::new);
        f_122349_ = (Direction[])Arrays.stream(f_122346_).filter(p_122419_0_ -> p_122419_0_.m_122434_().m_122479_()).sorted(Comparator.comparingInt(p_122414_0_ -> p_122414_0_.f_122341_)).toArray(Direction[]::new);
        f_122350_ = (Long2ObjectMap)Arrays.stream(f_122346_).collect(Collectors.toMap(p_122409_0_ -> new BlockPos(p_122409_0_.m_122436_()).m_121878_(), p_122393_0_ -> p_122393_0_, (p_122395_0_, p_122395_1_) -> {
            throw new IllegalArgumentException("Duplicate keys");
        }, Long2ObjectOpenHashMap::new));
    }

    public static enum Plane implements Iterable<Direction>,
    Predicate<Direction>
    {
        HORIZONTAL(new Direction[]{NORTH, EAST, SOUTH, WEST}, new Axis[]{Axis.X, Axis.Z}),
        VERTICAL(new Direction[]{UP, DOWN}, new Axis[]{Axis.Y});

        private final Direction[] f_122548_;
        private final Axis[] f_122549_;

        private Plane(Direction[] facingValuesIn, Axis[] axisValuesIn) {
            this.f_122548_ = facingValuesIn;
            this.f_122549_ = axisValuesIn;
        }

        public Direction m_122560_(Random rand) {
            return Util.m_137545_(this.f_122548_, rand);
        }

        public Axis m_122562_(Random p_122562_1_) {
            return Util.m_137545_(this.f_122549_, p_122562_1_);
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.m_122434_().m_122480_() == this;
        }

        @Override
        public Iterator<Direction> iterator() {
            return Iterators.forArray((Object[])this.f_122548_);
        }

        public Stream<Direction> m_122557_() {
            return Arrays.stream(this.f_122548_);
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int f_122531_;
        private final String f_122532_;

        private AxisDirection(int offset, String description) {
            this.f_122531_ = offset;
            this.f_122532_ = description;
        }

        public int m_122540_() {
            return this.f_122531_;
        }

        public String m_317193_() {
            return this.f_122532_;
        }

        public String toString() {
            return this.f_122532_;
        }

        public AxisDirection m_122541_() {
            return this == POSITIVE ? NEGATIVE : POSITIVE;
        }
    }

    public static enum Axis implements StringRepresentable,
    Predicate<Direction>
    {
        X("x"){

            @Override
            public int m_7863_(int x, int y, int z) {
                return x;
            }

            @Override
            public double m_6150_(double x, double y, double z) {
                return x;
            }
        }
        ,
        Y("y"){

            @Override
            public int m_7863_(int x, int y, int z) {
                return y;
            }

            @Override
            public double m_6150_(double x, double y, double z) {
                return y;
            }
        }
        ,
        Z("z"){

            @Override
            public int m_7863_(int x, int y, int z) {
                return z;
            }

            @Override
            public double m_6150_(double x, double y, double z) {
                return z;
            }
        };

        public static final Axis[] f_122448_;
        public static final Codec<Axis> f_122447_;
        private static final Map<String, Axis> f_122449_;
        private final String f_122450_;

        private Axis(String nameIn) {
            this.f_122450_ = nameIn;
        }

        @Nullable
        public static Axis m_122473_(String name) {
            return f_122449_.get(name.toLowerCase(Locale.ROOT));
        }

        public String m_122477_() {
            return this.f_122450_;
        }

        public boolean m_122478_() {
            return this == Y;
        }

        public boolean m_122479_() {
            return this == X || this == Z;
        }

        public String toString() {
            return this.f_122450_;
        }

        public static Axis m_122475_(Random randomIn) {
            return Util.m_137545_(f_122448_, randomIn);
        }

        @Override
        public boolean test(@Nullable Direction p_test_1_) {
            return p_test_1_ != null && p_test_1_.m_122434_() == this;
        }

        public Plane m_122480_() {
            switch (this) {
                case X: 
                case Z: {
                    return Plane.HORIZONTAL;
                }
                case Y: {
                    return Plane.VERTICAL;
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        public String m_7912_() {
            return this.f_122450_;
        }

        public abstract int m_7863_(int var1, int var2, int var3);

        public abstract double m_6150_(double var1, double var3, double var5);

        static {
            f_122448_ = Axis.values();
            f_122447_ = StringRepresentable.m_14350_(Axis::values, Axis::m_122473_);
            f_122449_ = Arrays.stream(f_122448_).collect(Collectors.toMap(Axis::m_122477_, p_122469_0_ -> p_122469_0_));
        }
    }
}

