/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;

public class RenderChunkRegion
implements BlockAndTintGetter {
    protected final int f_112899_;
    protected final int f_112900_;
    protected final BlockPos f_112901_;
    protected final int f_112902_;
    protected final int f_112903_;
    protected final int f_112904_;
    protected final LevelChunk[][] f_112905_;
    protected final BlockState[] f_112906_;
    protected final Level f_112908_;

    @Nullable
    public static RenderChunkRegion m_112920_(Level worldIn, BlockPos from, BlockPos to, int padding) {
        return RenderChunkRegion.generateCache(worldIn, from, to, padding, true);
    }

    public static RenderChunkRegion generateCache(Level worldIn, BlockPos from, BlockPos to, int padding, boolean checkEmpty) {
        int i = SectionPos.m_123171_((int)(from.m_123341_() - padding));
        int j = SectionPos.m_123171_((int)(from.m_123343_() - padding));
        int k = SectionPos.m_123171_((int)(to.m_123341_() + padding));
        int l = SectionPos.m_123171_((int)(to.m_123343_() + padding));
        LevelChunk[][] alevelchunk = new LevelChunk[k - i + 1][l - j + 1];
        for (int i1 = i; i1 <= k; ++i1) {
            for (int j1 = j; j1 <= l; ++j1) {
                alevelchunk[i1 - i][j1 - j] = worldIn.m_6325_(i1, j1);
            }
        }
        if (checkEmpty && RenderChunkRegion.m_112930_(from, to, i, j, alevelchunk)) {
            return null;
        }
        boolean k1 = true;
        BlockPos blockpos1 = from.m_224058_(-1, -1, -1);
        BlockPos blockpos = to.m_224058_(1, 1, 1);
        return new RenderChunkRegion(worldIn, i, j, alevelchunk, blockpos1, blockpos);
    }

    public static boolean m_112930_(BlockPos posFrom, BlockPos posTo, int chunkX, int chunkZ, LevelChunk[][] chunksIn) {
        for (int i = SectionPos.m_123171_((int)posFrom.m_123341_()); i <= SectionPos.m_123171_((int)posTo.m_123341_()); ++i) {
            for (int j = SectionPos.m_123171_((int)posFrom.m_123343_()); j <= SectionPos.m_123171_((int)posTo.m_123343_()); ++j) {
                LevelChunk levelchunk = chunksIn[i - chunkX][j - chunkZ];
                if (levelchunk.m_5566_(posFrom.m_123342_(), posTo.m_123342_())) continue;
                return false;
            }
        }
        return true;
    }

    public RenderChunkRegion(Level worldIn, int chunkStartXIn, int chunkStartZIn, LevelChunk[][] chunksIn, BlockPos startPos, BlockPos endPos) {
        this.f_112908_ = worldIn;
        this.f_112899_ = chunkStartXIn;
        this.f_112900_ = chunkStartZIn;
        this.f_112905_ = chunksIn;
        this.f_112901_ = startPos;
        this.f_112902_ = endPos.m_123341_() - startPos.m_123341_() + 1;
        this.f_112903_ = endPos.m_123342_() - startPos.m_123342_() + 1;
        this.f_112904_ = endPos.m_123343_() - startPos.m_123343_() + 1;
        this.f_112906_ = null;
    }

    protected final int m_112925_(BlockPos pos) {
        return this.m_112916_(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    protected int m_112916_(int xIn, int yIn, int zIn) {
        int i = xIn - this.f_112901_.m_123341_();
        int j = yIn - this.f_112901_.m_123342_();
        int k = zIn - this.f_112901_.m_123343_();
        return k * this.f_112902_ * this.f_112903_ + j * this.f_112902_ + i;
    }

    public BlockState m_8055_(BlockPos pos) {
        int i = (pos.m_123341_() >> 4) - this.f_112899_;
        int j = (pos.m_123343_() >> 4) - this.f_112900_;
        return this.f_112905_[i][j].m_8055_(pos);
    }

    public FluidState m_6425_(BlockPos pos) {
        return this.m_8055_(pos).m_60819_();
    }

    public float m_7717_(Direction directionIn, boolean shadeIn) {
        return this.f_112908_.m_7717_(directionIn, shadeIn);
    }

    public LevelLightEngine m_5518_() {
        return this.f_112908_.m_5518_();
    }

    @Nullable
    public BlockEntity m_7702_(BlockPos pos) {
        return this.m_112927_(pos, LevelChunk.EntityCreationType.IMMEDIATE);
    }

    @Nullable
    public BlockEntity m_112927_(BlockPos pos, LevelChunk.EntityCreationType creationType) {
        int i = SectionPos.m_123171_((int)pos.m_123341_()) - this.f_112899_;
        int j = SectionPos.m_123171_((int)pos.m_123343_()) - this.f_112900_;
        return this.f_112905_[i][j].m_5685_(pos, creationType);
    }

    public int m_6171_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
        return this.f_112908_.m_6171_(blockPosIn, colorResolverIn);
    }

    public int m_141493_() {
        return this.f_112908_.m_141493_();
    }

    public int m_141877_() {
        return this.f_112908_.m_141877_();
    }

    public Biome getBiome(BlockPos pos) {
        return this.f_112908_.m_46857_(pos);
    }

    public LevelChunk getChunk(int ix, int iz) {
        return this.f_112905_[ix][iz];
    }
}

