/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.player;

import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.HttpTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.ShoulderRidingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.optifine.Config;
import net.optifine.player.CapeUtils;
import net.optifine.player.PlayerConfigurations;
import net.optifine.reflect.Reflector;

public abstract class AbstractClientPlayer
extends Player {
    private static final String f_315831_ = "http://skins.minecraft.net/MinecraftSkins/%s.png";
    public static final int f_315824_ = 8;
    public static final int f_315825_ = 8;
    public static final int f_315832_ = 8;
    public static final int f_315833_ = 8;
    public static final int f_315834_ = 40;
    public static final int f_315826_ = 8;
    public static final int f_315827_ = 8;
    public static final int f_315828_ = 8;
    public static final int f_315829_ = 64;
    public static final int f_315830_ = 64;
    private PlayerInfo f_108546_;
    public float f_108542_;
    public float f_108543_;
    public float f_108544_;
    public final ClientLevel f_108545_;
    private ResourceLocation locationOfCape = null;
    private long reloadCapeTimeMs = 0L;
    private boolean elytraOfCape = false;
    private String nameClear = null;
    public ShoulderRidingEntity entityShoulderLeft;
    public ShoulderRidingEntity entityShoulderRight;
    public float capeRotateX;
    public float capeRotateY;
    public float capeRotateZ;
    private static final ResourceLocation TEXTURE_ELYTRA = new ResourceLocation("textures/entity/elytra.png");

    public AbstractClientPlayer(ClientLevel worldIn, GameProfile profileIn) {
        super((Level)worldIn, worldIn.m_104822_(), worldIn.m_104823_(), profileIn);
        this.f_108545_ = worldIn;
        this.nameClear = profileIn.getName();
        if (this.nameClear != null && !this.nameClear.isEmpty()) {
            this.nameClear = StringUtil.m_14406_((String)this.nameClear);
        }
        CapeUtils.downloadCape((AbstractClientPlayer)this);
        PlayerConfigurations.getPlayerConfiguration((AbstractClientPlayer)this);
    }

    public boolean m_5833_() {
        PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(this.m_36316_().getId());
        return playerinfo != null && playerinfo.m_105325_() == GameType.SPECTATOR;
    }

    public boolean m_7500_() {
        PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(this.m_36316_().getId());
        return playerinfo != null && playerinfo.m_105325_() == GameType.CREATIVE;
    }

    public boolean m_108555_() {
        return this.m_108558_() != null;
    }

    @Nullable
    protected PlayerInfo m_108558_() {
        if (this.f_108546_ == null) {
            this.f_108546_ = Minecraft.m_91087_().m_91403_().m_104949_(this.m_141538_());
        }
        return this.f_108546_;
    }

    public boolean m_108559_() {
        PlayerInfo playerinfo = this.m_108558_();
        return playerinfo != null && playerinfo.m_105335_();
    }

    public ResourceLocation m_108560_() {
        PlayerInfo playerinfo = this.m_108558_();
        return playerinfo == null ? DefaultPlayerSkin.m_118627_((UUID)this.m_141538_()) : playerinfo.m_105337_();
    }

    @Nullable
    public ResourceLocation m_108561_() {
        if (!Config.isShowCapes()) {
            return null;
        }
        if (this.reloadCapeTimeMs != 0L && System.currentTimeMillis() > this.reloadCapeTimeMs) {
            CapeUtils.reloadCape((AbstractClientPlayer)this);
            this.reloadCapeTimeMs = 0L;
        }
        if (this.locationOfCape != null) {
            return this.locationOfCape;
        }
        PlayerInfo playerinfo = this.m_108558_();
        return playerinfo == null ? null : playerinfo.m_105338_();
    }

    public boolean m_108562_() {
        return this.m_108558_() != null;
    }

    @Nullable
    public ResourceLocation m_108563_() {
        PlayerInfo playerinfo = this.m_108558_();
        return playerinfo == null ? null : playerinfo.m_105339_();
    }

    public static void m_281877_(ResourceLocation locationIn, String nameIn) {
        TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
        AbstractTexture abstracttexture = texturemanager.m_288257_(locationIn, MissingTextureAtlasSprite.m_118080_());
        if (abstracttexture == MissingTextureAtlasSprite.m_118080_()) {
            HttpTexture httptexture = new HttpTexture(null, String.format(f_315831_, StringUtil.m_14406_((String)nameIn)), DefaultPlayerSkin.m_118627_((UUID)AbstractClientPlayer.m_36283_((String)nameIn)), true, null);
            texturemanager.m_118495_(locationIn, httptexture);
        }
    }

    public static ResourceLocation m_108556_(String username) {
        return new ResourceLocation("skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)StringUtil.m_14406_((String)username)));
    }

    public String m_108564_() {
        PlayerInfo playerinfo = this.m_108558_();
        return playerinfo == null ? DefaultPlayerSkin.m_118629_((UUID)this.m_141538_()) : playerinfo.m_105336_();
    }

    public float m_108565_() {
        float f = 1.0f;
        if (this.m_158008_().f_35935_) {
            f *= 1.1f;
        }
        f = (float)((double)f * ((this.m_21133_(Attributes.f_22279_) / (double)this.m_158008_().m_35947_() + 1.0) / 2.0));
        if (this.m_158008_().m_35947_() == 0.0f || Float.isNaN(f) || Float.isInfinite(f)) {
            f = 1.0f;
        }
        ItemStack itemstack = this.m_21211_();
        if (this.m_6117_()) {
            if (itemstack.m_41720_() instanceof BowItem) {
                int i = this.m_21252_();
                float f1 = (float)i / 20.0f;
                f1 = f1 > 1.0f ? 1.0f : (f1 *= f1);
                f *= 1.0f - f1 * 0.15f;
            } else if (Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && this.m_158009_()) {
                return 0.1f;
            }
        }
        if (Reflector.ForgeHooksClient_getOffsetFOV.exists()) {
            return Reflector.callFloat(Reflector.ForgeHooksClient_getOffsetFOV, new Object[]{this, Float.valueOf(f)});
        }
        return Mth.m_14179_(Minecraft.m_91087_().f_91066_.f_92070_, 1.0f, f);
    }

    public String getNameClear() {
        return this.nameClear;
    }

    public ResourceLocation getLocationOfCape() {
        return this.locationOfCape;
    }

    public void setLocationOfCape(ResourceLocation locationOfCape) {
        this.locationOfCape = locationOfCape;
    }

    public boolean hasElytraCape() {
        ResourceLocation loc = this.m_108561_();
        if (loc == null) {
            return false;
        }
        if (loc == this.locationOfCape) {
            return this.elytraOfCape;
        }
        return true;
    }

    public void setElytraOfCape(boolean elytraOfCape) {
        this.elytraOfCape = elytraOfCape;
    }

    public boolean isElytraOfCape() {
        return this.elytraOfCape;
    }

    public long getReloadCapeTimeMs() {
        return this.reloadCapeTimeMs;
    }

    public void setReloadCapeTimeMs(long reloadCapeTimeMs) {
        this.reloadCapeTimeMs = reloadCapeTimeMs;
    }
}

