/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.components;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.client.ClientBrandRetriever;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.network.Connection;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.FrameTimer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.optifine.Config;
import net.optifine.SmartAnimations;
import net.optifine.TextureAnimations;
import net.optifine.reflect.Reflector;
import net.optifine.util.GuiPoint;
import net.optifine.util.GuiRect;
import net.optifine.util.GuiUtils;
import net.optifine.util.MemoryMonitor;
import net.optifine.util.NativeMemory;

public class DebugScreenOverlay
extends GuiComponent {
    private static final int f_314188_ = 0xE0E0E0;
    private static final int f_314189_ = 2;
    private static final int f_314190_ = 2;
    private static final int f_314191_ = 2;
    private static final Map<Heightmap.Types, String> f_94029_ = Util.m_137469_(new EnumMap(Heightmap.Types.class), p_94069_0_ -> {
        p_94069_0_.put(Heightmap.Types.WORLD_SURFACE_WG, "SW");
        p_94069_0_.put(Heightmap.Types.WORLD_SURFACE, "S");
        p_94069_0_.put(Heightmap.Types.OCEAN_FLOOR_WG, "OW");
        p_94069_0_.put(Heightmap.Types.OCEAN_FLOOR, "O");
        p_94069_0_.put(Heightmap.Types.MOTION_BLOCKING, "M");
        p_94069_0_.put(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, "ML");
    });
    private final Minecraft f_94030_;
    private final Font f_94031_;
    private HitResult f_94032_;
    private HitResult f_94033_;
    @Nullable
    private ChunkPos f_94034_;
    @Nullable
    private LevelChunk f_94035_;
    @Nullable
    private CompletableFuture<LevelChunk> f_94036_;
    private static final int f_314192_ = -65536;
    private static final int f_314193_ = -256;
    private static final int f_314194_ = -16711936;
    private String debugOF = null;
    private List<String> debugInfoLeft = null;
    private List<String> debugInfoRight = null;
    private long updateInfoLeftTimeMs = 0L;
    private long updateInfoRightTimeMs = 0L;

    public DebugScreenOverlay(Minecraft mc) {
        this.f_94030_ = mc;
        this.f_94031_ = mc.f_91062_;
    }

    public void m_94040_() {
        this.f_94036_ = null;
        this.f_94035_ = null;
    }

    public void m_94056_(PoseStack matrixStackIn) {
        this.f_94030_.m_91307_().m_6180_("debug");
        Entity entity = this.f_94030_.m_91288_();
        this.f_94032_ = entity.m_19907_(20.0, 0.0f, false);
        this.f_94033_ = entity.m_19907_(20.0, 0.0f, true);
        this.m_94076_(matrixStackIn);
        this.m_94079_(matrixStackIn);
        if (this.f_94030_.f_91066_.f_92065_) {
            int i = this.f_94030_.m_91268_().m_85445_();
            this.m_94058_(matrixStackIn, this.f_94030_.m_91293_(), 0, i / 2, true);
            IntegratedServer integratedserver = this.f_94030_.m_91092_();
            if (integratedserver != null) {
                this.m_94058_(matrixStackIn, integratedserver.m_129904_(), i - Math.min(i / 2, 240), i / 2, false);
            }
        }
        this.f_94030_.m_91307_().m_7238_();
    }

    protected void m_94076_(PoseStack matrixStackIn) {
        List<String> list = this.debugInfoLeft;
        if (list == null || System.currentTimeMillis() > this.updateInfoLeftTimeMs) {
            list = this.m_94075_();
            list.add("");
            boolean flag = this.f_94030_.m_91092_() != null;
            list.add("Debug: Pie [shift]: " + (this.f_94030_.f_91066_.f_92064_ ? "visible" : "hidden") + (flag ? " FPS + TPS" : " FPS") + " [alt]: " + (this.f_94030_.f_91066_.f_92065_ ? "visible" : "hidden"));
            list.add("For help: press F3 + Q");
            this.debugInfoLeft = list;
            this.updateInfoLeftTimeMs = System.currentTimeMillis() + 100L;
        }
        GuiPoint[] points = new GuiPoint[list.size()];
        GuiRect[] rects = new GuiRect[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = 9;
            int k = this.f_94031_.m_92895_(s);
            int l = 2;
            int i1 = 2 + j * i;
            rects[i] = new GuiRect(1, i1 - 1, 2 + k + 1, i1 + j - 1);
            points[i] = new GuiPoint(2, i1);
        }
        GuiUtils.fill((Matrix4f)matrixStackIn.m_85850_().m_85861_(), (GuiRect[])rects, (int)-1873784752);
        this.f_94031_.renderStrings(list, points, 0xE0E0E0, matrixStackIn.m_85850_().m_85861_(), false, this.f_94031_.m_92718_());
    }

    protected void m_94079_(PoseStack matrixStackIn) {
        List<String> list = this.debugInfoRight;
        if (list == null || System.currentTimeMillis() > this.updateInfoRightTimeMs) {
            this.debugInfoRight = list = this.m_94078_();
            this.updateInfoRightTimeMs = System.currentTimeMillis() + 100L;
        }
        GuiPoint[] points = new GuiPoint[list.size()];
        GuiRect[] rects = new GuiRect[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            String s = list.get(i);
            if (Strings.isNullOrEmpty((String)s)) continue;
            int j = 9;
            int k = this.f_94031_.m_92895_(s);
            int l = this.f_94030_.m_91268_().m_85445_() - 2 - k;
            int i1 = 2 + j * i;
            rects[i] = new GuiRect(l - 1, i1 - 1, l + k + 1, i1 + j - 1);
            points[i] = new GuiPoint(l, i1);
        }
        GuiUtils.fill((Matrix4f)matrixStackIn.m_85850_().m_85861_(), (GuiRect[])rects, (int)-1873784752);
        this.f_94031_.renderStrings(list, points, 0xE0E0E0, matrixStackIn.m_85850_().m_85861_(), false, this.f_94031_.m_92718_());
    }

    protected List<String> m_94075_() {
        if (this.f_94030_.f_90977_ != this.debugOF) {
            StringBuffer sb = new StringBuffer(this.f_94030_.f_90977_);
            int chunkUpdates = Config.getChunkUpdates();
            int posT = this.f_94030_.f_90977_.indexOf("T: ");
            if (posT >= 0) {
                sb.insert(posT, "(" + chunkUpdates + " chunk updates) ");
            }
            int fpsMin = Config.getFpsMin();
            int posFps = this.f_94030_.f_90977_.indexOf(" fps ");
            if (posFps >= 0) {
                sb.replace(0, posFps + 4, Config.getFpsString());
            }
            if (Config.isSmoothFps()) {
                sb.append(" sf");
            }
            if (Config.isFastRender()) {
                sb.append(" fr");
            }
            if (Config.isAnisotropicFiltering()) {
                sb.append(" af");
            }
            if (Config.isAntialiasing()) {
                sb.append(" aa");
            }
            if (Config.isRenderRegions()) {
                sb.append(" rr");
            }
            if (Config.isShaders()) {
                sb.append(" sh");
            }
            this.debugOF = this.f_94030_.f_90977_ = sb.toString();
        }
        List<String> list = this.getInfoLeft();
        StringBuilder sb = new StringBuilder();
        TextureAtlas tm = Config.getTextureMap();
        sb.append(", A: ");
        if (SmartAnimations.isActive()) {
            sb.append(tm.getCountAnimationsActive() + TextureAnimations.getCountAnimationsActive());
            sb.append("/");
        }
        sb.append(tm.getCountAnimations() + TextureAnimations.getCountAnimations());
        String ofInfo = sb.toString();
        for (int i = 0; i < list.size(); ++i) {
            String line = list.get(i);
            if (line == null || !line.startsWith("P: ")) continue;
            line = line + ofInfo;
            list.set(i, line);
            break;
        }
        return list;
    }

    protected List<String> getInfoLeft() {
        PostChain postchain;
        Level level;
        String s1;
        IntegratedServer integratedserver = this.f_94030_.m_91092_();
        Connection connection = this.f_94030_.m_91403_().m_6198_();
        float f = connection.m_129543_();
        float f1 = connection.m_129542_();
        String s = integratedserver != null ? String.format("Integrated server @ %.0f ms ticks, %.0f tx, %.0f rx", Float.valueOf(integratedserver.m_129903_()), Float.valueOf(f), Float.valueOf(f1)) : String.format("\"%s\" server, %.0f tx, %.0f rx", this.f_94030_.f_91074_.m_108629_(), Float.valueOf(f), Float.valueOf(f1));
        BlockPos blockpos = this.f_94030_.m_91288_().m_141983_();
        if (this.f_94030_.m_91299_()) {
            return Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.m_136187_().getName() + " (" + this.f_94030_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + ")", this.f_94030_.f_90977_, s, this.f_94030_.f_91060_.m_109820_(), this.f_94030_.f_91060_.m_109822_(), "P: " + this.f_94030_.f_91061_.m_107403_() + ". T: " + this.f_94030_.f_91073_.m_104813_(), this.f_94030_.f_91073_.m_299808_(), "", String.format("Chunk-relative: %d %d %d", blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF)});
        }
        Entity entity = this.f_94030_.m_91288_();
        Direction direction = entity.m_6350_();
        switch (direction) {
            case NORTH: {
                s1 = "Towards negative Z";
                break;
            }
            case SOUTH: {
                s1 = "Towards positive Z";
                break;
            }
            case WEST: {
                s1 = "Towards negative X";
                break;
            }
            case EAST: {
                s1 = "Towards positive X";
                break;
            }
            default: {
                s1 = "Invalid";
            }
        }
        ChunkPos chunkpos = new ChunkPos(blockpos);
        if (!Objects.equals(this.f_94034_, chunkpos)) {
            this.f_94034_ = chunkpos;
            this.m_94040_();
        }
        LongSets.EmptySet longset = (level = this.m_94083_()) instanceof ServerLevel ? ((ServerLevel)level).m_8902_() : LongSets.EMPTY_SET;
        ArrayList list = Lists.newArrayList((Object[])new String[]{"Minecraft " + SharedConstants.m_136187_().getName() + " (" + this.f_94030_.m_91388_() + "/" + ClientBrandRetriever.m_129629_() + ("release".equalsIgnoreCase(this.f_94030_.m_91389_()) ? "" : "/" + this.f_94030_.m_91389_()) + ")", this.f_94030_.f_90977_, s, this.f_94030_.f_91060_.m_109820_(), this.f_94030_.f_91060_.m_109822_(), "P: " + this.f_94030_.f_91061_.m_107403_() + ". T: " + this.f_94030_.f_91073_.m_104813_(), this.f_94030_.f_91073_.m_299808_()});
        String s2 = this.m_94082_();
        if (s2 != null) {
            list.add(s2);
        }
        list.add(this.f_94030_.f_91073_.m_46472_().m_135782_() + " FC: " + longset.size());
        list.add("");
        list.add(String.format(Locale.ROOT, "XYZ: %.3f / %.5f / %.3f", this.f_94030_.m_91288_().m_20185_(), this.f_94030_.m_91288_().m_20186_(), this.f_94030_.m_91288_().m_20189_()));
        list.add(String.format("Block: %d %d %d", blockpos.m_123341_(), blockpos.m_123342_(), blockpos.m_123343_()));
        list.add(String.format("Chunk: %d %d %d in %d %d %d", blockpos.m_123341_() & 0xF, blockpos.m_123342_() & 0xF, blockpos.m_123343_() & 0xF, SectionPos.m_123171_((int)blockpos.m_123341_()), SectionPos.m_123171_((int)blockpos.m_123342_()), SectionPos.m_123171_((int)blockpos.m_123343_())));
        list.add(String.format(Locale.ROOT, "Facing: %s (%s) (%.1f / %.1f)", new Object[]{direction, s1, Float.valueOf(Mth.m_14177_(entity.m_302838_())), Float.valueOf(Mth.m_14177_(entity.m_302839_()))}));
        LevelChunk levelchunk = this.m_94085_();
        if (levelchunk.m_6430_()) {
            list.add("Waiting for chunk...");
        } else {
            int i = this.f_94030_.f_91073_.m_7726_().m_7827_().m_75831_(blockpos, 0);
            int j = this.f_94030_.f_91073_.m_45517_(LightLayer.SKY, blockpos);
            int k = this.f_94030_.f_91073_.m_45517_(LightLayer.BLOCK, blockpos);
            list.add("Client Light: " + i + " (" + j + " sky, " + k + " block)");
            LevelChunk levelchunk1 = this.m_94084_();
            StringBuilder stringbuilder = new StringBuilder("CH");
            for (Heightmap.Types heightmap$types : Heightmap.Types.values()) {
                if (!heightmap$types.m_64297_()) continue;
                stringbuilder.append(" ").append(f_94029_.get(heightmap$types)).append(": ").append(levelchunk.m_5885_(heightmap$types, blockpos.m_123341_(), blockpos.m_123343_()));
            }
            list.add(stringbuilder.toString());
            stringbuilder.setLength(0);
            stringbuilder.append("SH");
            for (Heightmap.Types heightmap$types1 : Heightmap.Types.values()) {
                if (!heightmap$types1.m_64298_()) continue;
                stringbuilder.append(" ").append(f_94029_.get(heightmap$types1)).append(": ");
                if (levelchunk1 != null) {
                    stringbuilder.append(levelchunk1.m_5885_(heightmap$types1, blockpos.m_123341_(), blockpos.m_123343_()));
                    continue;
                }
                stringbuilder.append("??");
            }
            list.add(stringbuilder.toString());
            if (blockpos.m_123342_() >= this.f_94030_.f_91073_.m_141493_() && blockpos.m_123342_() < this.f_94030_.f_91073_.m_163334_()) {
                list.add("Biome: " + this.f_94030_.f_91073_.m_5962_().m_213953_(Registry.f_122885_).m_7981_((Object)this.f_94030_.f_91073_.m_46857_(blockpos)));
                long i1 = 0L;
                float f2 = 0.0f;
                if (levelchunk1 != null) {
                    f2 = level.m_46940_();
                    i1 = levelchunk1.m_6319_();
                }
                DifficultyInstance difficultyinstance = new DifficultyInstance(level.m_46791_(), level.m_46468_(), i1, f2);
                list.add(String.format(Locale.ROOT, "Local Difficulty: %.2f // %.2f (Day %d)", Float.valueOf(difficultyinstance.m_19056_()), Float.valueOf(difficultyinstance.m_19057_()), this.f_94030_.f_91073_.m_46468_() / 24000L));
            }
        }
        ServerLevel serverlevel = this.m_94081_();
        if (serverlevel != null) {
            NaturalSpawner.SpawnState naturalspawner$spawnstate = serverlevel.m_7726_().m_8485_();
            if (naturalspawner$spawnstate != null) {
                Object2IntMap object2intmap = naturalspawner$spawnstate.m_47148_();
                int l = naturalspawner$spawnstate.m_47126_();
                list.add("SC: " + l + ", " + Stream.of(MobCategory.values()).map(p_94066_1_ -> Character.toUpperCase(p_94066_1_.m_21607_().charAt(0)) + ": " + object2intmap.getInt(p_94066_1_)).collect(Collectors.joining(", ")));
            } else {
                list.add("SC: N/A");
            }
        }
        if ((postchain = this.f_94030_.f_91063_.m_109149_()) != null) {
            list.add("Shader: " + postchain.m_110022_());
        }
        list.add(this.f_94030_.m_91106_().m_120408_() + String.format(" (Mood %d%%)", Math.round(this.f_94030_.f_91074_.m_108762_() * 100.0f)));
        return list;
    }

    @Nullable
    private ServerLevel m_94081_() {
        IntegratedServer integratedserver = this.f_94030_.m_91092_();
        return integratedserver != null ? integratedserver.m_129880_(this.f_94030_.f_91073_.m_46472_()) : null;
    }

    @Nullable
    private String m_94082_() {
        ServerLevel serverlevel = this.m_94081_();
        return serverlevel != null ? serverlevel.m_299808_() : null;
    }

    private Level m_94083_() {
        return (Level)DataFixUtils.orElse(Optional.ofNullable(this.f_94030_.m_91092_()).flatMap(p_94064_1_ -> Optional.ofNullable(p_94064_1_.m_129880_(this.f_94030_.f_91073_.m_46472_()))), (Object)((Object)this.f_94030_.f_91073_));
    }

    @Nullable
    private LevelChunk m_94084_() {
        if (this.f_94036_ == null) {
            ServerLevel serverlevel = this.m_94081_();
            if (serverlevel != null) {
                this.f_94036_ = serverlevel.m_7726_().m_8431_(this.f_94034_.f_45578_, this.f_94034_.f_45579_, ChunkStatus.f_62326_, false).thenApply(p_94054_0_ -> (LevelChunk)p_94054_0_.map(p_314197_0_ -> (LevelChunk)p_314197_0_, p_314195_0_ -> null));
            }
            if (this.f_94036_ == null) {
                this.f_94036_ = CompletableFuture.completedFuture(this.m_94085_());
            }
        }
        return this.f_94036_.getNow(null);
    }

    private LevelChunk m_94085_() {
        if (this.f_94035_ == null) {
            this.f_94035_ = this.f_94030_.f_91073_.m_6325_(this.f_94034_.f_45578_, this.f_94034_.f_45579_);
        }
        return this.f_94035_;
    }

    protected List<String> m_94078_() {
        Entity entity;
        Object locations;
        long i = Runtime.getRuntime().maxMemory();
        long j = Runtime.getRuntime().totalMemory();
        long k = Runtime.getRuntime().freeMemory();
        long l = j - k;
        ArrayList list = Lists.newArrayList((Object[])new String[]{String.format("Java: %s %dbit", System.getProperty("java.version"), this.f_94030_.m_91103_() ? 64 : 32), String.format("Mem: % 2d%% %03d/%03dMB", l * 100L / i, DebugScreenOverlay.m_94050_(l), DebugScreenOverlay.m_94050_(i)), String.format("Allocated: % 2d%% %03dMB", j * 100L / i, DebugScreenOverlay.m_94050_(j)), "", String.format("CPU: %s", GlUtil.m_84819_()), "", String.format("Display: %dx%d (%s)", Minecraft.m_91087_().m_91268_().m_85441_(), Minecraft.m_91087_().m_91268_().m_85442_(), GlUtil.m_84818_()), GlUtil.m_84820_(), GlUtil.m_84821_()});
        long bufferAllocated = NativeMemory.getBufferAllocated();
        long bufferMaximum = NativeMemory.getBufferMaximum();
        long imageAllocated = NativeMemory.getImageAllocated();
        String strNative = "Native: " + DebugScreenOverlay.m_94050_(bufferAllocated) + "/" + DebugScreenOverlay.m_94050_(bufferMaximum) + "+" + DebugScreenOverlay.m_94050_(imageAllocated) + "MB";
        list.add(3, strNative);
        list.set(4, "GC: " + MemoryMonitor.getAllocationRateMb() + "MB/s");
        if (Reflector.BrandingControl_getBrandings.exists()) {
            list.add("");
            Collection brandings = (Collection)Reflector.call(Reflector.BrandingControl_getBrandings, true, false);
            for (String line : brandings) {
                if (line.startsWith("Minecraft ")) continue;
                list.add(line);
            }
        }
        if (this.f_94030_.m_91299_()) {
            return list;
        }
        if (this.f_94032_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos = ((BlockHitResult)this.f_94032_).m_82425_();
            BlockState blockstate = this.f_94030_.f_91073_.m_8055_(blockpos);
            list.add("");
            list.add(ChatFormatting.UNDERLINE + "Targeted Block: " + blockpos.m_123341_() + ", " + blockpos.m_123342_() + ", " + blockpos.m_123343_());
            list.add(String.valueOf(Registry.f_122824_.m_7981_((Object)blockstate.m_60734_())));
            for (Object entry : blockstate.m_61148_().entrySet()) {
                list.add(this.m_94071_((Map.Entry<Property<?>, Comparable<?>>)entry));
            }
            locations = Reflector.IForgeBlock_getTags.exists() ? (Collection)Reflector.call(blockstate.m_60734_(), Reflector.IForgeBlock_getTags, new Object[0]) : this.f_94030_.m_91403_().m_105148_().m_145498_(Registry.f_122901_).m_13394_((Object)blockstate.m_60734_());
            for (ResourceLocation resourcelocation : locations) {
                list.add("#" + resourcelocation);
            }
        }
        if (this.f_94033_.m_6662_() == HitResult.Type.BLOCK) {
            BlockPos blockpos1 = ((BlockHitResult)this.f_94033_).m_82425_();
            FluidState fluidstate = this.f_94030_.f_91073_.m_6425_(blockpos1);
            list.add("");
            list.add(ChatFormatting.UNDERLINE + "Targeted Fluid: " + blockpos1.m_123341_() + ", " + blockpos1.m_123342_() + ", " + blockpos1.m_123343_());
            list.add(String.valueOf(Registry.f_122822_.m_7981_((Object)fluidstate.m_76152_())));
            for (Map.Entry entry1 : fluidstate.m_61148_().entrySet()) {
                list.add(this.m_94071_(entry1));
            }
            locations = Reflector.ForgeFluid_getTags.exists() ? (Collection)Reflector.call(fluidstate.m_76152_(), Reflector.ForgeFluid_getTags, new Object[0]) : this.f_94030_.m_91403_().m_105148_().m_145498_(Registry.f_122899_).m_13394_((Object)fluidstate.m_76152_());
            for (ResourceLocation resourcelocation1 : locations) {
                list.add("#" + resourcelocation1);
            }
        }
        if ((entity = this.f_94030_.f_91076_) != null) {
            list.add("");
            list.add(ChatFormatting.UNDERLINE + "Targeted Entity");
            list.add(String.valueOf(Registry.f_122826_.m_7981_((Object)entity.m_6095_())));
            if (Reflector.ForgeEntityType_getTags.exists()) {
                Collection locations2 = (Collection)Reflector.call(entity.m_6095_(), Reflector.ForgeEntityType_getTags, new Object[0]);
                locations2.forEach(t -> list.add("#" + t));
            }
        }
        return list;
    }

    private String m_94071_(Map.Entry<Property<?>, Comparable<?>> entryIn) {
        Property<?> property = entryIn.getKey();
        Comparable<?> comparable = entryIn.getValue();
        String s = Util.m_137453_(property, comparable);
        if (Boolean.TRUE.equals(comparable)) {
            s = ChatFormatting.GREEN + s;
        } else if (Boolean.FALSE.equals(comparable)) {
            s = ChatFormatting.RED + s;
        }
        return property.m_61708_() + ": " + s;
    }

    private void m_94058_(PoseStack matrixStackIn, FrameTimer frameTimerIn, int xIn, int widthIn, boolean fpsIn) {
        if (fpsIn) {
            return;
        }
        int widthScaledOF = (int)(512.0 / this.f_94030_.m_91268_().m_85449_());
        xIn = Math.max(xIn, widthScaledOF);
        widthIn = this.f_94030_.m_91268_().m_85445_() - xIn;
        RenderSystem.m_69465_();
        int i = frameTimerIn.m_13754_();
        int j = frameTimerIn.m_13761_();
        long[] along = frameTimerIn.m_13764_();
        int l = xIn;
        int i1 = Math.max(0, along.length - widthIn);
        int j1 = along.length - i1;
        int k = frameTimerIn.m_13762_(i + i1);
        long k1 = 0L;
        int l1 = Integer.MAX_VALUE;
        int i2 = Integer.MIN_VALUE;
        for (int j2 = 0; j2 < j1; ++j2) {
            int k2 = (int)(along[frameTimerIn.m_13762_(k + j2)] / 1000000L);
            l1 = Math.min(l1, k2);
            i2 = Math.max(i2, k2);
            k1 += (long)k2;
        }
        int k4 = this.f_94030_.m_91268_().m_85446_();
        DebugScreenOverlay.m_93172_((PoseStack)matrixStackIn, (int)xIn, (int)(k4 - 60), (int)(xIn + j1), (int)k4, (int)-1873784752);
        RenderSystem.m_256236_(GameRenderer::m_282214_);
        BufferBuilder bufferbuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.m_69478_();
        RenderSystem.m_69472_();
        RenderSystem.m_69453_();
        bufferbuilder.m_190458_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        Matrix4f matrix4f = Transformation.m_121093_().m_121104_();
        while (k != j) {
            int l2 = frameTimerIn.m_13757_(along[k], fpsIn ? 30 : 60, fpsIn ? 60 : 20);
            int i3 = fpsIn ? 100 : 60;
            int j3 = this.m_94045_(Mth.m_14045_(l2, 0, i3), 0, i3 / 2, i3);
            int k3 = j3 >> 24 & 0xFF;
            int l3 = j3 >> 16 & 0xFF;
            int i4 = j3 >> 8 & 0xFF;
            int j4 = j3 & 0xFF;
            bufferbuilder.m_85982_(matrix4f, l + 1, k4, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            bufferbuilder.m_85982_(matrix4f, l + 1, k4 - l2 + 1, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            bufferbuilder.m_85982_(matrix4f, l, k4 - l2 + 1, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            bufferbuilder.m_85982_(matrix4f, l, k4, 0.0f).m_6122_(l3, i4, j4, k3).m_5752_();
            ++l;
            k = frameTimerIn.m_13762_(k + 1);
        }
        bufferbuilder.m_85721_();
        BufferUploader.m_85761_(bufferbuilder);
        RenderSystem.m_69493_();
        RenderSystem.m_69461_();
        if (fpsIn) {
            DebugScreenOverlay.m_93172_((PoseStack)matrixStackIn, (int)(xIn + 1), (int)(k4 - 30 + 1), (int)(xIn + 14), (int)(k4 - 30 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(matrixStackIn, "60 FPS", xIn + 2, k4 - 30 + 2, 0xE0E0E0);
            this.m_93154_(matrixStackIn, xIn, xIn + j1 - 1, k4 - 30, -1);
            DebugScreenOverlay.m_93172_((PoseStack)matrixStackIn, (int)(xIn + 1), (int)(k4 - 60 + 1), (int)(xIn + 14), (int)(k4 - 60 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(matrixStackIn, "30 FPS", xIn + 2, k4 - 60 + 2, 0xE0E0E0);
            this.m_93154_(matrixStackIn, xIn, xIn + j1 - 1, k4 - 60, -1);
        } else {
            DebugScreenOverlay.m_93172_((PoseStack)matrixStackIn, (int)(xIn + 1), (int)(k4 - 60 + 1), (int)(xIn + 14), (int)(k4 - 60 + 10), (int)-1873784752);
            this.f_94031_.m_92883_(matrixStackIn, "20 TPS", xIn + 2, k4 - 60 + 2, 0xE0E0E0);
            this.m_93154_(matrixStackIn, xIn, xIn + j1 - 1, k4 - 60, -1);
        }
        this.m_93154_(matrixStackIn, xIn, xIn + j1 - 1, k4 - 1, -1);
        this.m_93222_(matrixStackIn, xIn, k4 - 60, k4, -1);
        this.m_93222_(matrixStackIn, xIn + j1 - 1, k4 - 60, k4, -1);
        if (fpsIn && this.f_94030_.f_91066_.f_92113_ > 0 && this.f_94030_.f_91066_.f_92113_ <= 250) {
            this.m_93154_(matrixStackIn, xIn, xIn + j1 - 1, k4 - 1 - (int)(1800.0 / (double)this.f_94030_.f_91066_.f_92113_), -16711681);
        }
        String s = l1 + " ms min";
        String s1 = k1 / (long)j1 + " ms avg";
        String s2 = i2 + " ms max";
        this.f_94031_.m_92750_(matrixStackIn, s, xIn + 2, k4 - 60 - 9, 0xE0E0E0);
        this.f_94031_.m_92750_(matrixStackIn, s1, xIn + j1 / 2 - this.f_94031_.m_92895_(s1) / 2, k4 - 60 - 9, 0xE0E0E0);
        this.f_94031_.m_92750_(matrixStackIn, s2, xIn + j1 - this.f_94031_.m_92895_(s2), k4 - 60 - 9, 0xE0E0E0);
        RenderSystem.m_69482_();
    }

    private int m_94045_(int height, int heightMin, int heightMid, int heightMax) {
        return height < heightMid ? this.m_94041_(-16711936, -256, (float)height / (float)heightMid) : this.m_94041_(-256, -65536, (float)(height - heightMid) / (float)(heightMax - heightMid));
    }

    private int m_94041_(int col1, int col2, float factor) {
        int i = col1 >> 24 & 0xFF;
        int j = col1 >> 16 & 0xFF;
        int k = col1 >> 8 & 0xFF;
        int l = col1 & 0xFF;
        int i1 = col2 >> 24 & 0xFF;
        int j1 = col2 >> 16 & 0xFF;
        int k1 = col2 >> 8 & 0xFF;
        int l1 = col2 & 0xFF;
        int i2 = Mth.m_14045_((int)Mth.m_14179_(factor, i, i1), 0, 255);
        int j2 = Mth.m_14045_((int)Mth.m_14179_(factor, j, j1), 0, 255);
        int k2 = Mth.m_14045_((int)Mth.m_14179_(factor, k, k1), 0, 255);
        int l2 = Mth.m_14045_((int)Mth.m_14179_(factor, l, l1), 0, 255);
        return i2 << 24 | j2 << 16 | k2 << 8 | l2;
    }

    private static long m_94050_(long bytes) {
        return bytes / 1024L / 1024L;
    }
}

