/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import com.google.common.collect.Lists;
import com.ibm.icu.text.ArabicShaping;
import com.ibm.icu.text.ArabicShapingException;
import com.ibm.icu.text.Bidi;
import com.mojang.blaze3d.font.GlyphInfo;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.gui.font.glyphs.EmptyGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.FormattedCharSink;
import net.minecraft.util.Mth;
import net.minecraft.util.StringDecomposer;
import net.optifine.render.GlBlendState;
import net.optifine.util.GlyphAdvanceFixed;
import net.optifine.util.GuiPoint;

public class Font {
    private static final float f_314022_ = 0.01f;
    private static final Vector3f f_92712_ = new Vector3f(0.0f, 0.0f, 0.03f);
    public final int f_92710_ = 9;
    public final Random f_92711_ = new Random();
    private final Function<ResourceLocation, FontSet> f_92713_;
    private final StringSplitter f_92714_;
    private boolean blend = false;
    private GlBlendState oldBlendState = new GlBlendState();
    private GlyphInfo glyphAdvanceSpace = new GlyphAdvanceFixed(4.0f);

    public Font(Function<ResourceLocation, FontSet> fontsIn) {
        this.f_92713_ = fontsIn;
        this.f_92714_ = new StringSplitter((charIn, styleIn) -> this.m_92863_(styleIn.m_131192_()).m_95065_(charIn).m_83827_(styleIn.m_131154_()));
    }

    FontSet m_92863_(ResourceLocation locationIn) {
        return this.f_92713_.apply(locationIn);
    }

    public int m_92750_(PoseStack matrixStackIn, String text, float x, float y, int color) {
        return this.m_92803_(text, x, y, color, matrixStackIn.m_85850_().m_85861_(), true, this.m_92718_());
    }

    public int m_92756_(PoseStack matrixStackIn, String text, float x, float y, int color, boolean bidiIn) {
        return this.m_92803_(text, x, y, color, matrixStackIn.m_85850_().m_85861_(), true, bidiIn);
    }

    public int m_92883_(PoseStack matrixStackIn, String text, float x, float y, int color) {
        return this.m_92803_(text, x, y, color, matrixStackIn.m_85850_().m_85861_(), false, this.m_92718_());
    }

    public int m_92744_(PoseStack matrixStackIn, FormattedCharSequence text, float x, float y, int color) {
        return this.m_92726_(text, x, y, color, matrixStackIn.m_85850_().m_85861_(), true);
    }

    public int m_92763_(PoseStack matrixStackIn, Component componentIn, float x, float y, int color) {
        return this.m_92726_(componentIn.m_7532_(), x, y, color, matrixStackIn.m_85850_().m_85861_(), true);
    }

    public int m_92877_(PoseStack matrixStackIn, FormattedCharSequence text, float x, float y, int color) {
        return this.m_92726_(text, x, y, color, matrixStackIn.m_85850_().m_85861_(), false);
    }

    public int m_92889_(PoseStack matrixStackIn, Component componentIn, float x, float y, int color) {
        return this.m_92726_(componentIn.m_7532_(), x, y, color, matrixStackIn.m_85850_().m_85861_(), false);
    }

    public String m_92801_(String text) {
        try {
            Bidi bidi = new Bidi(new ArabicShaping(8).shape(text), 127);
            bidi.setReorderingMode(0);
            return bidi.writeReordered(2);
        }
        catch (ArabicShapingException arabicshapingexception) {
            return text;
        }
    }

    private int m_92803_(String text, float x, float y, int color, Matrix4f matrix, boolean dropShadow, boolean bidiIn) {
        if (text == null) {
            return 0;
        }
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_(Tesselator.m_85913_().m_85915_());
        int i = this.m_92822_(text, x, y, color, dropShadow, matrix, multibuffersource$buffersource, false, 0, 0xF000F0, bidiIn);
        multibuffersource$buffersource.m_109911_();
        return i;
    }

    public void renderStrings(List<String> texts, GuiPoint[] points, int color, Matrix4f matrix, boolean dropShadow, boolean bidiIn) {
        MultiBufferSource.BufferSource irendertypebuffer$impl = MultiBufferSource.m_109898_(Tesselator.m_85913_().m_85915_());
        for (int i = 0; i < texts.size(); ++i) {
            GuiPoint pos;
            String text = texts.get(i);
            if (text == null || text.isEmpty() || (pos = points[i]) == null) continue;
            float x = pos.getX();
            float y = pos.getY();
            this.m_92822_(text, x, y, color, dropShadow, matrix, irendertypebuffer$impl, false, 0, 0xF000F0, bidiIn);
        }
        irendertypebuffer$impl.m_109911_();
    }

    private int m_92726_(FormattedCharSequence text, float x, float y, int color, Matrix4f matrixIn, boolean shadow) {
        MultiBufferSource.BufferSource multibuffersource$buffersource = MultiBufferSource.m_109898_(Tesselator.m_85913_().m_85915_());
        int i = this.m_92733_(text, x, y, color, shadow, matrixIn, multibuffersource$buffersource, false, 0, 0xF000F0);
        multibuffersource$buffersource.m_109911_();
        return i;
    }

    public int m_92811_(String text, float x, float y, int color, boolean dropShadow, Matrix4f matrix, MultiBufferSource buffer, boolean transparentIn, int colorBackgroundIn, int packedLight) {
        return this.m_92822_(text, x, y, color, dropShadow, matrix, buffer, transparentIn, colorBackgroundIn, packedLight, this.m_92718_());
    }

    public int m_92822_(String text, float x, float y, int color, boolean shadow, Matrix4f matrixIn, MultiBufferSource bufferIn, boolean isTransparent, int colorBackgroundIn, int packedLight, boolean bidiIn) {
        return this.m_92908_(text, x, y, color, shadow, matrixIn, bufferIn, isTransparent, colorBackgroundIn, packedLight, bidiIn);
    }

    public int m_92841_(Component componentIn, float x, float y, int color, boolean shadow, Matrix4f matrixIn, MultiBufferSource bufferSourceIn, boolean isTransparent, int colorBackground, int packedLight) {
        return this.m_92733_(componentIn.m_7532_(), x, y, color, shadow, matrixIn, bufferSourceIn, isTransparent, colorBackground, packedLight);
    }

    public int m_92733_(FormattedCharSequence text, float x, float y, int color, boolean shadow, Matrix4f matrixIn, MultiBufferSource bufferIn, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        return this.m_92866_(text, x, y, color, shadow, matrixIn, bufferIn, isTransparent, colorBackgroundIn, packedLight);
    }

    public void m_314023_(FormattedCharSequence text, float x, float y, int colorText, int colorOutline, Matrix4f matrixIn, MultiBufferSource bufferIn, int packedLight) {
        int i = Font.m_92719_(colorOutline);
        StringRenderOutput font$stringrenderoutput = new StringRenderOutput(bufferIn, 0.0f, 0.0f, i, false, matrixIn, DisplayMode.NORMAL, packedLight);
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (j == 0 && k == 0) continue;
                float[] afloat = new float[]{x};
                int l = j;
                int i1 = k;
                text.m_13731_((p_314032_7_, p_314032_8_, p_314032_9_) -> {
                    boolean flag = p_314032_8_.m_131154_();
                    FontSet fontset = this.m_92863_(p_314032_8_.m_131192_());
                    GlyphInfo glyphinfo = fontset.m_95065_(p_314032_9_);
                    font$stringrenderoutput.f_92948_ = afloat[0] + (float)l * glyphinfo.m_5645_();
                    font$stringrenderoutput.f_92949_ = y + (float)i1 * glyphinfo.m_5645_();
                    afloat[0] = afloat[0] + glyphinfo.m_83827_(flag);
                    return font$stringrenderoutput.m_6411_(p_314032_7_, p_314032_8_.m_319083_(i), p_314032_9_);
                });
            }
        }
        StringRenderOutput font$stringrenderoutput1 = new StringRenderOutput(bufferIn, x, y, Font.m_92719_(colorText), false, matrixIn, DisplayMode.POLYGON_OFFSET, packedLight);
        text.m_13731_((FormattedCharSink)font$stringrenderoutput1);
        font$stringrenderoutput1.m_92961_(0, x);
    }

    private static int m_92719_(int colorIn) {
        return (colorIn & 0xFC000000) == 0 ? colorIn | 0xFF000000 : colorIn;
    }

    private int m_92908_(String text, float x, float y, int color, boolean shadow, Matrix4f matrixIn, MultiBufferSource bufferIn, boolean isTransparent, int colorBackgroundIn, int packedLight, boolean bidiIn) {
        if (bidiIn) {
            text = this.m_92801_(text);
        }
        color = Font.m_92719_(color);
        Matrix4f matrix4f = matrixIn.m_27658_();
        if (shadow) {
            this.m_92897_(text, x, y, color, true, matrixIn, bufferIn, isTransparent, colorBackgroundIn, packedLight);
            matrix4f.m_27648_(f_92712_);
        }
        x = this.m_92897_(text, x, y, color, false, matrix4f, bufferIn, isTransparent, colorBackgroundIn, packedLight);
        return (int)x + (shadow ? 1 : 0);
    }

    private int m_92866_(FormattedCharSequence text, float x, float y, int color, boolean shadow, Matrix4f matrixIn, MultiBufferSource bufferIn, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        color = Font.m_92719_(color);
        Matrix4f matrix4f = matrixIn.m_27658_();
        if (shadow) {
            this.m_92926_(text, x, y, color, true, matrixIn, bufferIn, isTransparent, colorBackgroundIn, packedLight);
            matrix4f.m_27648_(f_92712_);
        }
        x = this.m_92926_(text, x, y, color, false, matrix4f, bufferIn, isTransparent, colorBackgroundIn, packedLight);
        return (int)x + (shadow ? 1 : 0);
    }

    private float m_92897_(String text, float x, float y, int color, boolean isShadow, Matrix4f matrix, MultiBufferSource buffer, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        StringRenderOutput font$stringrenderoutput = new StringRenderOutput(buffer, x, y, color, isShadow, matrix, isTransparent, packedLight);
        StringDecomposer.m_14346_((String)text, (Style)Style.f_131099_, (FormattedCharSink)font$stringrenderoutput);
        return font$stringrenderoutput.m_92961_(colorBackgroundIn, x);
    }

    private float m_92926_(FormattedCharSequence text, float x, float y, int color, boolean shadow, Matrix4f matrixIn, MultiBufferSource bufferIn, boolean isTransparent, int colorBackgroundIn, int packedLight) {
        StringRenderOutput font$stringrenderoutput = new StringRenderOutput(bufferIn, x, y, color, shadow, matrixIn, isTransparent, packedLight);
        text.m_13731_((FormattedCharSink)font$stringrenderoutput);
        return font$stringrenderoutput.m_92961_(colorBackgroundIn, x);
    }

    void m_92787_(BakedGlyph glyphIn, boolean boldIn, boolean italicIn, float boldOffsetIn, float xIn, float yIn, Matrix4f matrix, VertexConsumer bufferIn, float redIn, float greenIn, float blueIn, float alphaIn, int packedLight) {
        glyphIn.m_5626_(italicIn, xIn, yIn, matrix, bufferIn, redIn, greenIn, blueIn, alphaIn, packedLight);
        if (boldIn) {
            glyphIn.m_5626_(italicIn, xIn + boldOffsetIn, yIn, matrix, bufferIn, redIn, greenIn, blueIn, alphaIn, packedLight);
        }
    }

    public int m_92895_(String text) {
        return Mth.m_14167_(this.f_92714_.m_92353_(text));
    }

    public int m_92852_(FormattedText text) {
        return Mth.m_14167_(this.f_92714_.m_92384_(text));
    }

    public int m_92724_(FormattedCharSequence textIn) {
        return Mth.m_14167_(this.f_92714_.m_92336_(textIn));
    }

    public String m_92837_(String text, int width, boolean fromRight) {
        return fromRight ? this.f_92714_.m_92423_(text, width, Style.f_131099_) : this.f_92714_.m_92410_(text, width, Style.f_131099_);
    }

    public String m_92834_(String text, int width) {
        return this.f_92714_.m_92410_(text, width, Style.f_131099_);
    }

    public FormattedText m_92854_(FormattedText text, int width) {
        return this.f_92714_.m_92389_(text, width, Style.f_131099_);
    }

    public void m_92857_(FormattedText text, int x, int y, int wrapWidth, int textColor) {
        Matrix4f matrix4f = Transformation.m_121093_().m_121104_();
        for (FormattedCharSequence formattedcharsequence : this.m_92923_(text, wrapWidth)) {
            this.m_92726_(formattedcharsequence, x, y, textColor, matrix4f, false);
            y += 9;
        }
    }

    public int m_92920_(String str, int maxLength) {
        return 9 * this.f_92714_.m_92432_(str, maxLength, Style.f_131099_).size();
    }

    public List<FormattedCharSequence> m_92923_(FormattedText text, int width) {
        return Language.m_128107_().m_128112_(this.f_92714_.m_92414_(text, width, Style.f_131099_));
    }

    public boolean m_92718_() {
        return Language.m_128107_().m_6627_();
    }

    public StringSplitter m_92865_() {
        return this.f_92714_;
    }

    class StringRenderOutput
    implements FormattedCharSink {
        final MultiBufferSource f_92937_;
        private final boolean f_92939_;
        private final float f_92940_;
        private final float f_92941_;
        private final float f_92942_;
        private final float f_92943_;
        private final float f_92944_;
        private final Matrix4f f_92945_;
        private final DisplayMode f_314054_;
        private final int f_92947_;
        float f_92948_;
        float f_92949_;
        @Nullable
        private List<BakedGlyph.Effect> f_92950_;
        private Style lastStyle;
        private FontSet lastStyleFont;

        private void m_92964_(BakedGlyph.Effect effectIn) {
            if (this.f_92950_ == null) {
                this.f_92950_ = Lists.newArrayList();
            }
            this.f_92950_.add(effectIn);
        }

        public StringRenderOutput(MultiBufferSource bufferIn, float xIn, float yIn, int colorIn, boolean shadowIn, Matrix4f matrixIn, boolean transparentIn, int packedLightIn) {
            this(bufferIn, xIn, yIn, colorIn, shadowIn, matrixIn, transparentIn ? DisplayMode.SEE_THROUGH : DisplayMode.NORMAL, packedLightIn);
        }

        public StringRenderOutput(MultiBufferSource bufferIn, float xIn, float yIn, int colorIn, boolean shadowIn, Matrix4f matrixIn, DisplayMode modeIn, int packedLightIn) {
            this.f_92937_ = bufferIn;
            this.f_92948_ = xIn;
            this.f_92949_ = yIn;
            this.f_92939_ = shadowIn;
            this.f_92940_ = shadowIn ? 0.25f : 1.0f;
            this.f_92941_ = (float)(colorIn >> 16 & 0xFF) / 255.0f * this.f_92940_;
            this.f_92942_ = (float)(colorIn >> 8 & 0xFF) / 255.0f * this.f_92940_;
            this.f_92943_ = (float)(colorIn & 0xFF) / 255.0f * this.f_92940_;
            this.f_92944_ = (float)(colorIn >> 24 & 0xFF) / 255.0f;
            this.f_92945_ = matrixIn.isIdentity() ? BakedGlyph.MATRIX_IDENTITY : matrixIn;
            this.f_314054_ = modeIn;
            this.f_92947_ = packedLightIn;
        }

        public boolean m_6411_(int indexIn, Style styleIn, int charIn) {
            float f7;
            float f2;
            float f1;
            float f;
            FontSet fontset = this.getFont(styleIn);
            GlyphInfo glyphinfo = fontset.m_95065_(charIn);
            BakedGlyph bakedglyph = styleIn.m_131176_() && charIn != 32 ? fontset.m_95067_(glyphinfo) : fontset.m_95078_(charIn);
            boolean flag = styleIn.m_131154_();
            float f3 = this.f_92944_;
            TextColor textcolor = styleIn.m_131135_();
            if (textcolor != null) {
                int i = textcolor.m_131265_();
                f = (float)(i >> 16 & 0xFF) / 255.0f * this.f_92940_;
                f1 = (float)(i >> 8 & 0xFF) / 255.0f * this.f_92940_;
                f2 = (float)(i & 0xFF) / 255.0f * this.f_92940_;
            } else {
                f = this.f_92941_;
                f1 = this.f_92942_;
                f2 = this.f_92943_;
            }
            if (!(bakedglyph instanceof EmptyGlyph)) {
                float f5 = flag ? glyphinfo.m_5619_() : 0.0f;
                float f4 = this.f_92939_ ? glyphinfo.m_5645_() : 0.0f;
                VertexConsumer vertexconsumer = this.f_92937_.m_6299_(bakedglyph.m_314290_(this.f_314054_));
                Font.this.m_92787_(bakedglyph, flag, styleIn.m_131161_(), f5, this.f_92948_ + f4, this.f_92949_ + f4, this.f_92945_, vertexconsumer, f, f1, f2, f3, this.f_92947_);
            }
            float f6 = glyphinfo.m_83827_(flag);
            float f4 = f7 = this.f_92939_ ? 1.0f : 0.0f;
            if (styleIn.m_131168_()) {
                this.m_92964_(new BakedGlyph.Effect(this.f_92948_ + f7 - 1.0f, this.f_92949_ + f7 + 4.5f, this.f_92948_ + f7 + f6, this.f_92949_ + f7 + 4.5f - 1.0f, 0.01f, f, f1, f2, f3));
            }
            if (styleIn.m_131171_()) {
                this.m_92964_(new BakedGlyph.Effect(this.f_92948_ + f7 - 1.0f, this.f_92949_ + f7 + 9.0f, this.f_92948_ + f7 + f6, this.f_92949_ + f7 + 9.0f - 1.0f, 0.01f, f, f1, f2, f3));
            }
            this.f_92948_ += f6;
            return true;
        }

        public float m_92961_(int colorBackgroundIn, float xIn) {
            if (colorBackgroundIn != 0) {
                float f = (float)(colorBackgroundIn >> 24 & 0xFF) / 255.0f;
                float f1 = (float)(colorBackgroundIn >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(colorBackgroundIn >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(colorBackgroundIn & 0xFF) / 255.0f;
                this.m_92964_(new BakedGlyph.Effect(xIn - 1.0f, this.f_92949_ + 9.0f, this.f_92948_ + 1.0f, this.f_92949_ - 1.0f, 0.01f, f1, f2, f3, f));
            }
            if (this.f_92950_ != null) {
                BakedGlyph bakedglyph = Font.this.m_92863_(Style.f_131100_).m_95064_();
                VertexConsumer vertexconsumer = this.f_92937_.m_6299_(bakedglyph.m_314290_(this.f_314054_));
                for (BakedGlyph.Effect bakedglyph$effect : this.f_92950_) {
                    bakedglyph.m_95220_(bakedglyph$effect, this.f_92945_, vertexconsumer, this.f_92947_);
                }
            }
            return this.f_92948_;
        }

        private FontSet getFont(Style styleIn) {
            if (styleIn == this.lastStyle) {
                return this.lastStyleFont;
            }
            this.lastStyle = styleIn;
            this.lastStyleFont = Font.this.m_92863_(styleIn.m_131192_());
            return this.lastStyleFont;
        }
    }

    public static enum DisplayMode {
        NORMAL,
        SEE_THROUGH,
        POLYGON_OFFSET;

    }
}

