/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_3312 {
    private static final Logger field_25805 = LogManager.getLogger();
    private static final int field_29788 = 1000;
    private static final int field_29789 = 1;
    private static boolean field_14313;
    private final Map<String, class_3313> field_14312 = Maps.newConcurrentMap();
    private final Map<UUID, class_3313> field_14310 = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> field_33860 = Maps.newConcurrentMap();
    private final GameProfileRepository field_14315;
    private final Gson field_14318 = new GsonBuilder().create();
    private final File field_14314;
    private final AtomicLong field_25724 = new AtomicLong();
    @Nullable
    private Executor field_33861;

    public class_3312(GameProfileRepository gameProfileRepository, File file) {
        this.field_14315 = gameProfileRepository;
        this.field_14314 = file;
        Lists.reverse(this.method_14517()).forEach(this::method_30164);
    }

    private void method_30164(class_3313 class_33132) {
        GameProfile gameProfile = class_33132.method_14519();
        class_33132.method_30171(this.method_30169());
        String \u00e2\u02dc\u01922 = gameProfile.getName();
        if (\u00e2\u02dc\u01922 != null) {
            this.field_14312.put(\u00e2\u02dc\u01922.toLowerCase(Locale.ROOT), class_33132);
        }
        if ((\u00e2\u02dc\u0192 = gameProfile.getId()) != null) {
            this.field_14310.put(\u00e2\u02dc\u0192, class_33132);
        }
    }

    private static Optional<GameProfile> method_14509(GameProfileRepository gameProfileRepository, String string) {
        final AtomicReference atomicReference = new AtomicReference();
        ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile gameProfile) {
                atomicReference.set(gameProfile);
            }

            public void onProfileLookupFailed(GameProfile gameProfile, Exception exception) {
                atomicReference.set(null);
            }
        };
        gameProfileRepository.findProfilesByNames(new String[]{string}, Agent.MINECRAFT, \u00e2\u02dc\u01922);
        GameProfile \u00e2\u02dc\u01923 = (GameProfile)atomicReference.get();
        if (!class_3312.method_14514() && \u00e2\u02dc\u01923 == null) {
            UUID uUID = class_1657.method_7271(new GameProfile(null, string));
            return Optional.of(new GameProfile(uUID, string));
        }
        return Optional.ofNullable(\u00e2\u02dc\u01923);
    }

    public static void method_14510(boolean bl) {
        field_14313 = bl;
    }

    private static boolean method_14514() {
        return field_14313;
    }

    public void method_14508(GameProfile gameProfile) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date \u00e2\u02dc\u01922 = calendar.getTime();
        class_3313 \u00e2\u02dc\u01923 = new class_3313(gameProfile, \u00e2\u02dc\u01922);
        this.method_30164(\u00e2\u02dc\u01923);
        this.method_14518();
    }

    private long method_30169() {
        return this.field_25724.incrementAndGet();
    }

    public Optional<GameProfile> method_14515(String string) {
        Optional<GameProfile> \u00e2\u02dc\u01923;
        string2 = string.toLowerCase(Locale.ROOT);
        class_3313 class_33132 = this.field_14312.get(string2);
        boolean \u00e2\u02dc\u01922 = false;
        if (class_33132 != null && new Date().getTime() >= class_33132.field_14319.getTime()) {
            this.field_14310.remove(class_33132.method_14519().getId());
            this.field_14312.remove(class_33132.method_14519().getName().toLowerCase(Locale.ROOT));
            \u00e2\u02dc\u01922 = true;
            class_33132 = null;
        }
        if (class_33132 != null) {
            class_33132.method_30171(this.method_30169());
            \u00e2\u02dc\u01923 = Optional.of(class_33132.method_14519());
        } else {
            String string2;
            \u00e2\u02dc\u01923 = class_3312.method_14509(this.field_14315, string2);
            if (\u00e2\u02dc\u01923.isPresent()) {
                this.method_14508(\u00e2\u02dc\u01923.get());
                \u00e2\u02dc\u01922 = false;
            }
        }
        if (\u00e2\u02dc\u01922) {
            this.method_14518();
        }
        return \u00e2\u02dc\u01923;
    }

    public void method_37156(String string, Consumer<Optional<GameProfile>> consumer) {
        if (this.field_33861 == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completableFuture = this.field_33860.get(string);
        if (completableFuture != null) {
            this.field_33860.put(string, (CompletableFuture<Optional<GameProfile>>)completableFuture.whenCompleteAsync((optional, throwable) -> consumer.accept((Optional<GameProfile>)optional), this.field_33861));
        } else {
            this.field_33860.put(string, (CompletableFuture<Optional<GameProfile>>)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.method_14515(string), class_156.method_18349()).whenCompleteAsync((optional, throwable) -> this.field_33860.remove(string), this.field_33861)).whenCompleteAsync((optional, throwable) -> consumer.accept((Optional<GameProfile>)optional), this.field_33861));
        }
    }

    public Optional<GameProfile> method_14512(UUID uUID) {
        class_3313 class_33132 = this.field_14310.get(uUID);
        if (class_33132 == null) {
            return Optional.empty();
        }
        class_33132.method_30171(this.method_30169());
        return Optional.of(class_33132.method_14519());
    }

    public void method_37157(Executor executor) {
        this.field_33861 = executor;
    }

    private static DateFormat method_30170() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<class_3313> method_14517() {
        ArrayList arrayList = Lists.newArrayList();
        try (BufferedReader \u00e2\u02dc\u019222222 = Files.newReader((File)this.field_14314, (Charset)StandardCharsets.UTF_8);){
            JsonArray \u00e2\u02dc\u01923 = (JsonArray)this.field_14318.fromJson((Reader)\u00e2\u02dc\u019222222, JsonArray.class);
            if (\u00e2\u02dc\u01923 == null) {
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            DateFormat dateFormat = class_3312.method_30170();
            \u00e2\u02dc\u01923.forEach(jsonElement -> class_3312.method_30167(jsonElement, dateFormat).ifPresent(arrayList::add));
            return arrayList;
        }
        catch (FileNotFoundException \u00e2\u02dc\u019222222) {
            return arrayList;
        }
        catch (JsonParseException | IOException throwable) {
            field_25805.warn("Failed to load profile cache {}", (Object)this.field_14314, (Object)throwable);
        }
        return arrayList;
    }

    public void method_14518() {
        JsonArray jsonArray = new JsonArray();
        DateFormat \u00e2\u02dc\u01922 = class_3312.method_30170();
        this.method_14516(1000).forEach(class_33132 -> jsonArray.add(class_3312.method_30165(class_33132, \u00e2\u02dc\u01922)));
        String \u00e2\u02dc\u01923 = this.field_14318.toJson((JsonElement)jsonArray);
        try (BufferedWriter bufferedWriter = Files.newWriter((File)this.field_14314, (Charset)StandardCharsets.UTF_8);){
            bufferedWriter.write(\u00e2\u02dc\u01923);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<class_3313> method_14516(int n) {
        return ImmutableList.copyOf(this.field_14310.values()).stream().sorted(Comparator.comparing(class_3313::method_30172).reversed()).limit(n);
    }

    private static JsonElement method_30165(class_3313 class_33132, DateFormat dateFormat) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", class_33132.method_14519().getName());
        UUID \u00e2\u02dc\u01922 = class_33132.method_14519().getId();
        jsonObject.addProperty("uuid", \u00e2\u02dc\u01922 == null ? "" : \u00e2\u02dc\u01922.toString());
        jsonObject.addProperty("expiresOn", dateFormat.format(class_33132.method_14520()));
        return jsonObject;
    }

    private static Optional<class_3313> method_30167(JsonElement jsonElement, DateFormat dateFormat) {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonElement \u00e2\u02dc\u01922 = jsonObject.get("name");
            JsonElement \u00e2\u02dc\u01923 = jsonObject.get("uuid");
            JsonElement \u00e2\u02dc\u01924 = jsonObject.get("expiresOn");
            if (\u00e2\u02dc\u01922 == null || \u00e2\u02dc\u01923 == null) {
                return Optional.empty();
            }
            String \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.getAsString();
            String \u00e2\u02dc\u01926 = \u00e2\u02dc\u01922.getAsString();
            Date \u00e2\u02dc\u01927 = null;
            if (\u00e2\u02dc\u01924 != null) {
                try {
                    \u00e2\u02dc\u01927 = dateFormat.parse(\u00e2\u02dc\u01924.getAsString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (\u00e2\u02dc\u01926 == null || \u00e2\u02dc\u01925 == null || \u00e2\u02dc\u01927 == null) {
                return Optional.empty();
            }
            try {
                UUID uUID = UUID.fromString(\u00e2\u02dc\u01925);
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
            return Optional.of(new class_3313(new GameProfile(uUID, \u00e2\u02dc\u01926), \u00e2\u02dc\u01927));
        }
        return Optional.empty();
    }

    static class class_3313 {
        private final GameProfile field_14321;
        final Date field_14319;
        private volatile long field_25726;

        class_3313(GameProfile gameProfile, Date date) {
            this.field_14321 = gameProfile;
            this.field_14319 = date;
        }

        public GameProfile method_14519() {
            return this.field_14321;
        }

        public Date method_14520() {
            return this.field_14319;
        }

        public void method_30171(long l) {
            this.field_25726 = l;
        }

        public long method_30172() {
            return this.field_25726;
        }
    }
}

