/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.annotation.Nullable;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_4485;
import net.minecraft.class_4486;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class class_2861
implements AutoCloseable {
    private static final Logger field_20434 = LogManager.getLogger();
    private static final int field_31418 = 4096;
    @VisibleForTesting
    protected static final int field_31417 = 1024;
    private static final int field_31419 = 5;
    private static final int field_31420 = 0;
    private static final ByteBuffer field_20435 = ByteBuffer.allocateDirect(1);
    private static final String field_31421 = ".mcc";
    private static final int field_31422 = 128;
    private static final int field_31423 = 256;
    private static final int field_31424 = 0;
    private final FileChannel field_20436;
    private final Path field_20657;
    final class_4486 field_20437;
    private final ByteBuffer field_20438 = ByteBuffer.allocateDirect(8192);
    private final IntBuffer field_20439;
    private final IntBuffer field_20440;
    @VisibleForTesting
    protected final class_4485 field_20441 = new class_4485();

    public class_2861(File file, File file2, boolean bl) throws IOException {
        this(file.toPath(), file2.toPath(), class_4486.field_20443, bl);
    }

    public class_2861(Path path, Path path2, class_4486 class_44862, boolean bl) throws IOException {
        this.field_20437 = class_44862;
        if (!Files.isDirectory(path2, new LinkOption[0])) {
            throw new IllegalArgumentException("Expected directory, got " + path2.toAbsolutePath());
        }
        this.field_20657 = path2;
        this.field_20439 = this.field_20438.asIntBuffer();
        this.field_20439.limit(1024);
        this.field_20438.position(4096);
        this.field_20440 = this.field_20438.asIntBuffer();
        this.field_20436 = bl ? FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.DSYNC) : FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.READ, StandardOpenOption.WRITE);
        this.field_20441.method_21868(0, 2);
        this.field_20438.position(0);
        int n = this.field_20436.read(this.field_20438, 0L);
        if (n != -1) {
            if (n != 8192) {
                field_20434.warn("Region file {} has truncated header: {}", (Object)path, (Object)n);
            }
            long l = Files.size(path);
            for (int i = 0; i < 1024; ++i) {
                \u00e2\u02dc\u0192 = this.field_20439.get(i);
                if (\u00e2\u02dc\u0192 == 0) continue;
                \u00e2\u02dc\u0192 = class_2861.method_21878(\u00e2\u02dc\u0192);
                \u00e2\u02dc\u0192 = class_2861.method_21871(\u00e2\u02dc\u0192);
                if (\u00e2\u02dc\u0192 < 2) {
                    field_20434.warn("Region file {} has invalid sector at index: {}; sector {} overlaps with header", (Object)path, (Object)i, (Object)\u00e2\u02dc\u0192);
                    this.field_20439.put(i, 0);
                    continue;
                }
                if (\u00e2\u02dc\u0192 == 0) {
                    field_20434.warn("Region file {} has an invalid sector at index: {}; size has to be > 0", (Object)path, (Object)i);
                    this.field_20439.put(i, 0);
                    continue;
                }
                if ((long)\u00e2\u02dc\u0192 * 4096L > l) {
                    field_20434.warn("Region file {} has an invalid sector at index: {}; sector {} is out of bounds", (Object)path, (Object)i, (Object)\u00e2\u02dc\u0192);
                    this.field_20439.put(i, 0);
                    continue;
                }
                this.field_20441.method_21868(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
        }
    }

    private Path method_22413(class_1923 class_19232) {
        String string = "c." + class_19232.field_9181 + "." + class_19232.field_9180 + field_31421;
        return this.field_20657.resolve(string);
    }

    @Nullable
    public synchronized DataInputStream method_21873(class_1923 class_19232) throws IOException {
        int n = this.method_12419(class_19232);
        if (n == 0) {
            return null;
        }
        \u00e2\u02dc\u0192 = class_2861.method_21878(n);
        \u00e2\u02dc\u0192 = class_2861.method_21871(n);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * 4096;
        ByteBuffer \u00e2\u02dc\u01922 = ByteBuffer.allocate(\u00e2\u02dc\u0192);
        this.field_20436.read(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 * 4096);
        \u00e2\u02dc\u01922.flip();
        if (\u00e2\u02dc\u01922.remaining() < 5) {
            field_20434.error("Chunk {} header is truncated: expected {} but read {}", (Object)class_19232, (Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u01922.remaining());
            return null;
        }
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.getInt();
        byte \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.get();
        if (\u00e2\u02dc\u0192 == 0) {
            field_20434.warn("Chunk {} is allocated, but stream is missing", (Object)class_19232);
            return null;
        }
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - 1;
        if (class_2861.method_22407(\u00e2\u02dc\u01923)) {
            if (\u00e2\u02dc\u0192 != 0) {
                field_20434.warn("Chunk has both internal and external streams");
            }
            return this.method_22408(class_19232, class_2861.method_22412(\u00e2\u02dc\u01923));
        }
        if (\u00e2\u02dc\u0192 > \u00e2\u02dc\u01922.remaining()) {
            field_20434.error("Chunk {} stream is truncated: expected {} but read {}", (Object)class_19232, (Object)\u00e2\u02dc\u0192, (Object)\u00e2\u02dc\u01922.remaining());
            return null;
        }
        if (\u00e2\u02dc\u0192 < 0) {
            field_20434.error("Declared size {} of chunk {} is negative", (Object)\u00e2\u02dc\u0192, (Object)class_19232);
            return null;
        }
        return this.method_22409(class_19232, \u00e2\u02dc\u01923, class_2861.method_21876(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192));
    }

    private static int method_31739() {
        return (int)(class_156.method_659() / 1000L);
    }

    private static boolean method_22407(byte by) {
        return (by & 0x80) != 0;
    }

    private static byte method_22412(byte by) {
        return (byte)(by & 0xFFFFFF7F);
    }

    @Nullable
    private DataInputStream method_22409(class_1923 class_19232, byte by, InputStream inputStream) throws IOException {
        class_4486 class_44862 = class_4486.method_21883(by);
        if (class_44862 == null) {
            field_20434.error("Chunk {} has invalid chunk stream version {}", (Object)class_19232, (Object)by);
            return null;
        }
        return new DataInputStream(new BufferedInputStream(class_44862.method_21885(inputStream)));
    }

    @Nullable
    private DataInputStream method_22408(class_1923 class_19232, byte by) throws IOException {
        Path path = this.method_22413(class_19232);
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            field_20434.error("External chunk path {} is not file", (Object)path);
            return null;
        }
        return this.method_22409(class_19232, by, Files.newInputStream(path, new OpenOption[0]));
    }

    private static ByteArrayInputStream method_21876(ByteBuffer byteBuffer, int n) {
        return new ByteArrayInputStream(byteBuffer.array(), byteBuffer.position(), n);
    }

    private int method_21872(int n, int n2) {
        return n << 8 | n2;
    }

    private static int method_21871(int n) {
        return n & 0xFF;
    }

    private static int method_21878(int n) {
        return n >> 8 & 0xFFFFFF;
    }

    private static int method_21880(int n) {
        return (n + 4096 - 1) / 4096;
    }

    public boolean method_21879(class_1923 class_19232) {
        int n = this.method_12419(class_19232);
        if (n == 0) {
            return false;
        }
        \u00e2\u02dc\u0192 = class_2861.method_21878(n);
        \u00e2\u02dc\u0192 = class_2861.method_21871(n);
        ByteBuffer \u00e2\u02dc\u01922 = ByteBuffer.allocate(5);
        try {
            this.field_20436.read(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 * 4096);
            \u00e2\u02dc\u01922.flip();
            if (\u00e2\u02dc\u01922.remaining() != 5) {
                return false;
            }
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.getInt();
            byte by = \u00e2\u02dc\u01922.get();
            if (class_2861.method_22407(by)) {
                if (!class_4486.method_21887(class_2861.method_22412(by))) {
                    return false;
                }
                if (!Files.isRegularFile(this.method_22413(class_19232), new LinkOption[0])) {
                    return false;
                }
            } else {
                if (!class_4486.method_21887(by)) {
                    return false;
                }
                if (\u00e2\u02dc\u0192 == 0) {
                    return false;
                }
                int n2 = \u00e2\u02dc\u0192 - 1;
                if (n2 < 0 || n2 > 4096 * \u00e2\u02dc\u0192) {
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    public DataOutputStream method_21881(class_1923 class_19232) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(this.field_20437.method_21886(new class_2862(class_19232))));
    }

    public void method_26981() throws IOException {
        this.field_20436.force(true);
    }

    public void method_31740(class_1923 class_19232) throws IOException {
        int n = class_2861.method_17909(class_19232);
        \u00e2\u02dc\u0192 = this.field_20439.get(n);
        if (\u00e2\u02dc\u0192 == 0) {
            return;
        }
        this.field_20439.put(n, 0);
        this.field_20440.put(n, class_2861.method_31739());
        this.method_21870();
        Files.deleteIfExists(this.method_22413(class_19232));
        this.field_20441.method_21869(class_2861.method_21878(\u00e2\u02dc\u0192), class_2861.method_21871(\u00e2\u02dc\u0192));
    }

    protected synchronized void method_21874(class_1923 class_19232, ByteBuffer byteBuffer) throws IOException {
        class_4549 \u00e2\u02dc\u01924;
        int \u00e2\u02dc\u01923;
        int \u00e2\u02dc\u01922;
        int n = class_2861.method_17909(class_19232);
        \u00e2\u02dc\u0192 = this.field_20439.get(n);
        \u00e2\u02dc\u0192 = class_2861.method_21878(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = class_2861.method_21871(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = byteBuffer.remaining();
        \u00e2\u02dc\u01922 = class_2861.method_21880(\u00e2\u02dc\u0192);
        if (\u00e2\u02dc\u01922 >= 256) {
            Path path = this.method_22413(class_19232);
            field_20434.warn("Saving oversized chunk {} ({} bytes} to external file {}", (Object)class_19232, (Object)\u00e2\u02dc\u0192, (Object)path);
            \u00e2\u02dc\u01922 = 1;
            \u00e2\u02dc\u01923 = this.field_20441.method_21867(\u00e2\u02dc\u01922);
            \u00e2\u02dc\u01924 = this.method_22410(path, byteBuffer);
            ByteBuffer \u00e2\u02dc\u01925 = this.method_22406();
            this.field_20436.write(\u00e2\u02dc\u01925, \u00e2\u02dc\u01923 * 4096);
        } else {
            \u00e2\u02dc\u01923 = this.field_20441.method_21867(\u00e2\u02dc\u01922);
            \u00e2\u02dc\u01924 = () -> Files.deleteIfExists(this.method_22413(class_19232));
            this.field_20436.write(byteBuffer, \u00e2\u02dc\u01923 * 4096);
        }
        this.field_20439.put(n, this.method_21872(\u00e2\u02dc\u01923, \u00e2\u02dc\u01922));
        this.field_20440.put(n, class_2861.method_31739());
        this.method_21870();
        \u00e2\u02dc\u01924.run();
        if (\u00e2\u02dc\u0192 != 0) {
            this.field_20441.method_21869(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }
    }

    private ByteBuffer method_22406() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(5);
        byteBuffer.putInt(1);
        byteBuffer.put((byte)(this.field_20437.method_21882() | 0x80));
        byteBuffer.flip();
        return byteBuffer;
    }

    private class_4549 method_22410(Path path, ByteBuffer byteBuffer) throws IOException {
        Path path2 = Files.createTempFile(this.field_20657, "tmp", null, new FileAttribute[0]);
        try (FileChannel \u00e2\u02dc\u01922 = FileChannel.open(path2, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            byteBuffer.position(5);
            \u00e2\u02dc\u01922.write(byteBuffer);
        }
        return () -> Files.move(path2, path, StandardCopyOption.REPLACE_EXISTING);
    }

    private void method_21870() throws IOException {
        this.field_20438.position(0);
        this.field_20436.write(this.field_20438, 0L);
    }

    private int method_12419(class_1923 class_19232) {
        return this.field_20439.get(class_2861.method_17909(class_19232));
    }

    public boolean method_12423(class_1923 class_19232) {
        return this.method_12419(class_19232) != 0;
    }

    private static int method_17909(class_1923 class_19232) {
        return class_19232.method_17887() + class_19232.method_17888() * 32;
    }

    @Override
    public void close() throws IOException {
        try {
            this.method_21877();
        }
        finally {
            try {
                this.field_20436.force(true);
            }
            finally {
                this.field_20436.close();
            }
        }
    }

    private void method_21877() throws IOException {
        int n = (int)this.field_20436.size();
        if (n != (\u00e2\u02dc\u0192 = class_2861.method_21880(n) * 4096)) {
            ByteBuffer byteBuffer = field_20435.duplicate();
            byteBuffer.position(0);
            this.field_20436.write(byteBuffer, \u00e2\u02dc\u0192 - 1);
        }
    }

    class class_2862
    extends ByteArrayOutputStream {
        private final class_1923 field_17656;

        public class_2862(class_1923 class_19232) {
            super(8096);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(0);
            super.write(class_2861.this.field_20437.method_21882());
            this.field_17656 = class_19232;
        }

        @Override
        public void close() throws IOException {
            ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, 0, this.count);
            byteBuffer.putInt(0, this.count - 5 + 1);
            class_2861.this.method_21874(this.field_17656, byteBuffer);
        }
    }

    static interface class_4549 {
        public void run() throws IOException;
    }
}

