/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Queues;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.LockSupport;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_2596;
import net.minecraft.class_2666;
import net.minecraft.class_2672;
import net.minecraft.class_2676;
import net.minecraft.class_310;
import net.minecraft.class_3906;
import net.minecraft.class_5949;
import net.minecraft.class_5950;
import net.minecraft.class_5952;
import net.minecraft.class_5965;
import net.optifine.Config;
import net.optifine.util.PacketRunnable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class class_1255<R extends Runnable>
implements class_5952,
class_3906<R>,
Executor {
    private final String field_18318;
    private static final Logger field_5751 = LogManager.getLogger();
    private final Queue<R> field_5750 = Queues.newConcurrentLinkedQueue();
    private int field_18319;

    protected class_1255(String nameIn) {
        this.field_18318 = nameIn;
        class_5950.field_29555.method_34702(this);
    }

    protected abstract R method_16211(Runnable var1);

    protected abstract boolean method_18856(R var1);

    public boolean method_18854() {
        return Thread.currentThread() == this.method_3777();
    }

    protected abstract Thread method_3777();

    protected boolean method_5384() {
        return !this.method_18854();
    }

    public int method_21684() {
        return this.field_5750.size();
    }

    @Override
    public String method_16898() {
        return this.field_18318;
    }

    public <V> CompletableFuture<V> method_5385(Supplier<V> supplier) {
        return this.method_5384() ? CompletableFuture.supplyAsync(supplier, this) : CompletableFuture.completedFuture(supplier.get());
    }

    private CompletableFuture<Void> method_5382(Runnable taskIn) {
        return CompletableFuture.supplyAsync(() -> {
            taskIn.run();
            return null;
        }, this);
    }

    public CompletableFuture<Void> method_20493(Runnable taskIn) {
        if (this.method_5384()) {
            return this.method_5382(taskIn);
        }
        taskIn.run();
        return CompletableFuture.completedFuture(null);
    }

    public void method_19537(Runnable taskIn) {
        if (!this.method_18854()) {
            this.method_5382(taskIn).join();
        } else {
            taskIn.run();
        }
    }

    public void method_18858(R taskIn) {
        this.field_5750.add(taskIn);
        LockSupport.unpark(this.method_3777());
    }

    @Override
    public void execute(Runnable p_execute_1_) {
        if (this.method_5384()) {
            this.method_18858(this.method_16211(p_execute_1_));
        } else {
            p_execute_1_.run();
        }
    }

    protected void method_18855() {
        this.field_5750.clear();
    }

    protected void method_5383() {
        int count = Integer.MAX_VALUE;
        if (Config.isLazyChunkLoading() && this == class_310.method_1551()) {
            count = this.getTaskCount();
        }
        while (this.method_16075() && --count > 0) {
        }
    }

    public boolean method_16075() {
        Runnable r = (Runnable)this.field_5750.peek();
        if (r == null) {
            return false;
        }
        if (this.field_18319 == 0 && !this.method_18856(r)) {
            return false;
        }
        this.method_18859((Runnable)this.field_5750.remove());
        return true;
    }

    public void method_18857(BooleanSupplier isDone) {
        ++this.field_18319;
        try {
            while (!isDone.getAsBoolean()) {
                if (this.method_16075()) continue;
                this.method_20813();
            }
        }
        finally {
            --this.field_18319;
        }
    }

    protected void method_20813() {
        Thread.yield();
        LockSupport.parkNanos("waiting for tasks", 100000L);
    }

    protected void method_18859(R taskIn) {
        block2: {
            try {
                taskIn.run();
            }
            catch (Exception exception) {
                field_5751.fatal("Error executing task on {}", (Object)this.method_16898(), (Object)exception);
                if (!(exception.getCause() instanceof OutOfMemoryError)) break block2;
                OutOfMemoryError oome = (OutOfMemoryError)exception.getCause();
                throw oome;
            }
        }
    }

    @Override
    public List<class_5965> method_34705() {
        return ImmutableList.of((Object)class_5965.method_34776(this.field_18318 + "-pending-tasks", class_5949.field_29551, this::method_21684));
    }

    private int getTaskCount() {
        if (this.field_5750.isEmpty()) {
            return 0;
        }
        Runnable[] rs = this.field_5750.toArray(new Runnable[this.field_5750.size()]);
        double chunkUpdateWeight = this.getChunkUpdateWeight(rs);
        if (chunkUpdateWeight < 5.0) {
            return Integer.MAX_VALUE;
        }
        int queueSize = rs.length;
        int fps = Math.max(Config.getFpsAverage(), 1);
        double weight = queueSize * 10 / fps;
        int count = this.getCount(rs, weight);
        return count;
    }

    private int getCount(R[] rs, double maxWeight) {
        double weight = 0.0;
        for (int i = 0; i < rs.length; ++i) {
            R r = rs[i];
            if (!((weight += this.getChunkUpdateWeight((Runnable)r)) > maxWeight)) continue;
            return i + 1;
        }
        return rs.length;
    }

    private double getChunkUpdateWeight(R[] rs) {
        double weight = 0.0;
        for (int i = 0; i < rs.length; ++i) {
            R r = rs[i];
            weight += this.getChunkUpdateWeight((Runnable)r);
        }
        return weight;
    }

    private double getChunkUpdateWeight(Runnable r) {
        if (r instanceof PacketRunnable) {
            PacketRunnable pr = (PacketRunnable)r;
            class_2596 p = pr.getPacket();
            if (p instanceof class_2672) {
                return 1.0;
            }
            if (p instanceof class_2676) {
                return 0.2;
            }
            if (p instanceof class_2666) {
                return 2.6;
            }
        }
        return 0.0;
    }
}

