/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.blaze3d.platform;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.optifine.util.VideoModeComparator;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;

public final class Monitor {
    private final long f_84936_;
    private final List<VideoMode> f_84937_;
    private VideoMode f_84938_;
    private int f_84939_;
    private int f_84940_;

    public Monitor(long pointerIn) {
        this.f_84936_ = pointerIn;
        this.f_84937_ = Lists.newArrayList();
        this.m_84943_();
    }

    public void m_84943_() {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69583_(), ()Ljava/lang/Boolean;)());
        this.f_84937_.clear();
        GLFWVidMode.Buffer buffer = GLFW.glfwGetVideoModes((long)this.f_84936_);
        GLFWVidMode glCurrentMode = GLFW.glfwGetVideoMode((long)this.f_84936_);
        VideoMode currentMode = new VideoMode(glCurrentMode);
        ArrayList<Object> removedModes = new ArrayList<Object>();
        for (int i = buffer.limit() - 1; i >= 0; --i) {
            buffer.position(i);
            VideoMode videoMode = new VideoMode(buffer);
            if (videoMode.m_85336_() < 8 || videoMode.m_85337_() < 8 || videoMode.m_85338_() < 8) continue;
            if (videoMode.m_85341_() < currentMode.m_85341_()) {
                removedModes.add(videoMode);
                continue;
            }
            this.f_84937_.add(videoMode);
        }
        removedModes.sort(new VideoModeComparator().reversed());
        for (VideoMode videoMode : removedModes) {
            if (Monitor.getVideoMode(this.f_84937_, videoMode.m_85332_(), videoMode.m_85335_()) != null) continue;
            this.f_84937_.add(videoMode);
        }
        this.f_84937_.sort(new VideoModeComparator());
        int[] aint = new int[1];
        int[] nArray = new int[1];
        GLFW.glfwGetMonitorPos((long)this.f_84936_, (int[])aint, (int[])nArray);
        this.f_84939_ = aint[0];
        this.f_84940_ = nArray[0];
        GLFWVidMode glfwvidmode = GLFW.glfwGetVideoMode((long)this.f_84936_);
        this.f_84938_ = new VideoMode(glfwvidmode);
    }

    public VideoMode m_84948_(Optional<VideoMode> optionalVideoMode) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69583_(), ()Ljava/lang/Boolean;)());
        if (optionalVideoMode.isPresent()) {
            VideoMode videomode = optionalVideoMode.get();
            for (VideoMode videomode1 : this.f_84937_) {
                if (!videomode1.equals((Object)videomode)) continue;
                return videomode1;
            }
        }
        return this.m_84950_();
    }

    public int m_84946_(VideoMode modeIn) {
        RenderSystem.m_69393_((Supplier<Boolean>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, m_69583_(), ()Ljava/lang/Boolean;)());
        return this.f_84937_.indexOf(modeIn);
    }

    public VideoMode m_84950_() {
        return this.f_84938_;
    }

    public int m_84951_() {
        return this.f_84939_;
    }

    public int m_84952_() {
        return this.f_84940_;
    }

    public VideoMode m_84944_(int index) {
        return this.f_84937_.get(index);
    }

    public int m_84953_() {
        return this.f_84937_.size();
    }

    public long m_84954_() {
        return this.f_84936_;
    }

    public String toString() {
        return String.format("Monitor[%s %sx%s %s]", this.f_84936_, this.f_84939_, this.f_84940_, this.f_84938_);
    }

    public static VideoMode getVideoMode(List<VideoMode> list, int width, int height) {
        for (VideoMode vm : list) {
            if (vm.m_85332_() != width || vm.m_85335_() != height) continue;
            return vm;
        }
        return null;
    }
}

