/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.indigo.renderer.mesh;

import com.google.common.base.Preconditions;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.impl.client.indigo.renderer.RenderMaterialImpl;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.GeometryHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.helper.NormalHelper;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.EncodingFormat;
import net.fabricmc.fabric.impl.client.indigo.renderer.mesh.MutableQuadViewImpl;
import net.minecraft.class_1160;
import net.minecraft.class_2350;

public class QuadViewImpl
implements QuadView {
    protected class_2350 nominalFace;
    protected boolean isGeometryInvalid = true;
    protected final class_1160 faceNormal = new class_1160();
    private boolean shade = true;
    protected int[] data;
    protected int baseIndex = 0;

    final void load(int[] data, int baseIndex) {
        this.data = data;
        this.baseIndex = baseIndex;
        this.load();
    }

    public final void load() {
        this.isGeometryInvalid = false;
        this.nominalFace = this.lightFace();
        NormalHelper.computeFaceNormal(this.faceNormal, this);
    }

    public int[] data() {
        return this.data;
    }

    public int normalFlags() {
        return EncodingFormat.normalFlags(this.data[this.baseIndex + 0]);
    }

    public boolean hasVertexNormals() {
        return this.normalFlags() != 0;
    }

    public int geometryFlags() {
        this.computeGeometry();
        return EncodingFormat.geometryFlags(this.data[this.baseIndex + 0]);
    }

    protected void computeGeometry() {
        if (this.isGeometryInvalid) {
            this.isGeometryInvalid = false;
            NormalHelper.computeFaceNormal(this.faceNormal, this);
            this.data[this.baseIndex + 0] = EncodingFormat.lightFace(this.data[this.baseIndex + 0], GeometryHelper.lightFace(this));
            this.data[this.baseIndex + 0] = EncodingFormat.geometryFlags(this.data[this.baseIndex + 0], GeometryHelper.computeShapeFlags(this));
        }
    }

    public final void toVanilla(int textureIndex, int[] target, int targetIndex, boolean isItem) {
        System.arraycopy(this.data, this.baseIndex + EncodingFormat.VERTEX_X, target, targetIndex, EncodingFormat.QUAD_STRIDE);
    }

    public final RenderMaterialImpl.Value material() {
        return EncodingFormat.material(this.data[this.baseIndex + 0]);
    }

    public final int colorIndex() {
        return this.data[this.baseIndex + 1];
    }

    public final int tag() {
        return this.data[this.baseIndex + 2];
    }

    public final class_2350 lightFace() {
        this.computeGeometry();
        return EncodingFormat.lightFace(this.data[this.baseIndex + 0]);
    }

    public final class_2350 cullFace() {
        return EncodingFormat.cullFace(this.data[this.baseIndex + 0]);
    }

    public final class_2350 nominalFace() {
        return this.nominalFace;
    }

    public final class_1160 faceNormal() {
        this.computeGeometry();
        return this.faceNormal;
    }

    public void copyTo(MutableQuadView target) {
        this.computeGeometry();
        MutableQuadViewImpl quad = (MutableQuadViewImpl)target;
        System.arraycopy(this.data, this.baseIndex + 1, quad.data, quad.baseIndex + 1, EncodingFormat.TOTAL_STRIDE - 1);
        quad.faceNormal.method_4949(this.faceNormal.method_4943(), this.faceNormal.method_4945(), this.faceNormal.method_4947());
        quad.nominalFace = this.nominalFace;
        quad.isGeometryInvalid = false;
    }

    public class_1160 copyPos(int vertexIndex, class_1160 target) {
        if (target == null) {
            target = new class_1160();
        }
        int index = this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X;
        target.method_4949(Float.intBitsToFloat(this.data[index]), Float.intBitsToFloat(this.data[index + 1]), Float.intBitsToFloat(this.data[index + 2]));
        return target;
    }

    public float posByIndex(int vertexIndex, int coordinateIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X + coordinateIndex]);
    }

    public float x(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_X]);
    }

    public float y(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_Y]);
    }

    public float z(int vertexIndex) {
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_Z]);
    }

    public boolean hasNormal(int vertexIndex) {
        return (this.normalFlags() & 1 << vertexIndex) != 0;
    }

    protected final int normalIndex(int vertexIndex) {
        return this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_NORMAL;
    }

    public class_1160 copyNormal(int vertexIndex, class_1160 target) {
        if (this.hasNormal(vertexIndex)) {
            if (target == null) {
                target = new class_1160();
            }
            int normal = this.data[this.normalIndex(vertexIndex)];
            target.method_4949(NormalHelper.getPackedNormalComponent(normal, 0), NormalHelper.getPackedNormalComponent(normal, 1), NormalHelper.getPackedNormalComponent(normal, 2));
            return target;
        }
        return null;
    }

    public float normalX(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormalHelper.getPackedNormalComponent(this.data[this.normalIndex(vertexIndex)], 0) : Float.NaN;
    }

    public float normalY(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormalHelper.getPackedNormalComponent(this.data[this.normalIndex(vertexIndex)], 1) : Float.NaN;
    }

    public float normalZ(int vertexIndex) {
        return this.hasNormal(vertexIndex) ? NormalHelper.getPackedNormalComponent(this.data[this.normalIndex(vertexIndex)], 2) : Float.NaN;
    }

    public int lightmap(int vertexIndex) {
        return this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_LIGHTMAP];
    }

    public int spriteColor(int vertexIndex, int spriteIndex) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        return this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_COLOR];
    }

    public float spriteU(int vertexIndex, int spriteIndex) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_U]);
    }

    public float spriteV(int vertexIndex, int spriteIndex) {
        Preconditions.checkArgument((spriteIndex == 0 ? 1 : 0) != 0, (String)"Unsupported sprite index: %s", (int)spriteIndex);
        return Float.intBitsToFloat(this.data[this.baseIndex + vertexIndex * EncodingFormat.VERTEX_STRIDE + EncodingFormat.VERTEX_V]);
    }

    public int vertexStart() {
        return this.baseIndex + 3;
    }

    public boolean hasShade() {
        return this.shade && !this.material().disableDiffuse(0);
    }

    public void shade(boolean shade) {
        this.shade = shade;
    }
}

