/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class ModSearch {
    public static boolean validSearchQuery(String query) {
        return query != null && !query.isEmpty();
    }

    public static List<Mod> search(ModsScreen screen, String query, List<Mod> candidates) {
        if (!ModSearch.validSearchQuery(query)) {
            return candidates;
        }
        return candidates.stream().filter(modContainer -> ModSearch.passesFilters(screen, modContainer, query.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    private static boolean passesFilters(ModsScreen screen, Mod mod, String query) {
        String modId = mod.getId();
        if (mod.getName().toLowerCase(Locale.ROOT).contains(query) || modId.toLowerCase(Locale.ROOT).contains(query) || ModSearch.authorMatches(mod, query) || mod.getBadges().contains((Object)Mod.Badge.LIBRARY) && "api library".contains(query) || "patchwork forge".contains(query) && mod.getBadges().contains((Object)Mod.Badge.PATCHWORK_FORGE) || "deprecated".contains(query) && mod.getBadges().contains((Object)Mod.Badge.DEPRECATED) || "clientside client-side".contains(query) && mod.getBadges().contains((Object)Mod.Badge.CLIENT) || "configurations configs configures configurable".contains(query) && screen.getModHasConfigScreen().get(modId).booleanValue()) {
            return true;
        }
        if (ModMenu.PARENT_MAP.keySet().contains(mod)) {
            for (Mod child : ModMenu.PARENT_MAP.get((Object)mod)) {
                if (!ModSearch.passesFilters(screen, child, query)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean authorMatches(Mod mod, String query) {
        return mod.getAuthors().stream().map(s -> s.toLowerCase(Locale.ROOT)).anyMatch(s -> s.contains(query.toLowerCase(Locale.ROOT)));
    }
}

