/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.value.serializer;

import de.siphalor.tweed.config.ConfigReadException;
import de.siphalor.tweed.config.value.serializer.ConfigValueSerializer;
import de.siphalor.tweed.data.DataContainer;
import de.siphalor.tweed.data.DataList;
import de.siphalor.tweed.data.DataValue;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_2540;

public class ListSerializer<E, L extends List<E>>
extends ConfigValueSerializer<L> {
    ConfigValueSerializer<E> valueSerializer;
    Supplier<L> listSupplier;

    public ListSerializer(ConfigValueSerializer<E> elementSerializer, Supplier<L> listSupplier) {
        this.valueSerializer = elementSerializer;
        this.listSupplier = listSupplier;
    }

    @Override
    public L read(DataValue<?> data) throws ConfigReadException {
        List list = (List)this.listSupplier.get();
        if (data.isList()) {
            DataList<?> dataList = data.asList();
            for (DataValue dataValue : dataList) {
                list.add(this.valueSerializer.read(dataValue));
            }
        }
        return (L)list;
    }

    @Override
    public <Key> void write(DataContainer<?, Key> dataContainer, Key key, L value) {
        DataList<?> dataList = dataContainer.addList(key);
        int i = 0;
        for (Object element : value) {
            this.valueSerializer.write(dataList, i, element);
        }
    }

    @Override
    public L read(class_2540 packetByteBuf) {
        int l = packetByteBuf.method_10816();
        List list = (List)this.listSupplier.get();
        for (int i = 0; i < l; ++i) {
            list.add(this.valueSerializer.read(packetByteBuf));
        }
        return (L)list;
    }

    @Override
    public void write(class_2540 packetByteBuf, L value) {
        packetByteBuf.method_10804(value.size());
        for (Object element : value) {
            this.valueSerializer.write(packetByteBuf, element);
        }
    }

    @Override
    public String asString(L value) {
        StringBuilder stringBuilder = new StringBuilder("[ ");
        for (Object element : value) {
            stringBuilder.append(this.valueSerializer.asString(element)).append(", ");
        }
        return stringBuilder.append(" ]").toString();
    }

    @Override
    public Class<L> getType() {
        return ((List)this.listSupplier.get()).getClass();
    }
}

