/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.tweed.config.constraints;

import de.siphalor.tweed.config.constraints.AnnotationConstraint;
import de.siphalor.tweed.config.constraints.ConstraintException;
import de.siphalor.tweed.config.entry.ValueConfigEntry;
import de.siphalor.tweed.util.NumberUtil;
import org.apache.commons.lang3.StringUtils;

public class RangeConstraint<T extends Number>
implements AnnotationConstraint<T> {
    private boolean autoCorrect;
    protected T min;
    protected T max;

    public RangeConstraint() {
        this(false);
    }

    public RangeConstraint(boolean autoCorrect) {
        this.autoCorrect = autoCorrect;
    }

    public RangeConstraint<T> between(T min, T max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public RangeConstraint<T> greaterThan(T min) {
        this.min = min;
        this.max = null;
        return this;
    }

    public RangeConstraint<T> smallerThan(T max) {
        this.min = null;
        this.max = max;
        return this;
    }

    public RangeConstraint<T> everything() {
        this.min = null;
        this.max = null;
        return this;
    }

    public T getMin() {
        return this.min;
    }

    public T getMax() {
        return this.max;
    }

    public boolean hasRealBounds() {
        return this.min != null && this.max != null;
    }

    @Override
    public void apply(T value, ValueConfigEntry<T> configEntry) throws ConstraintException {
        if (this.min != null && ((Number)value).doubleValue() < ((Number)this.min).doubleValue()) {
            if (this.autoCorrect) {
                configEntry.setValue(this.min);
            }
            throw new ConstraintException(configEntry.getValue() + " is smaller than " + this.min, !this.autoCorrect);
        }
        if (this.max != null && ((Number)value).doubleValue() > ((Number)this.max).doubleValue()) {
            if (this.autoCorrect) {
                configEntry.setValue(this.max);
            }
            throw new ConstraintException(configEntry.getValue() + " is greater than" + this.max, !this.autoCorrect);
        }
    }

    @Override
    public String getDescription() {
        if (this.min == null) {
            if (this.max == null) {
                return "Any numerical value";
            }
            return "Must be less or equal to " + this.max;
        }
        if (this.max == null) {
            return "Must be greater or equal to " + this.min;
        }
        return "Must be inclusively between " + this.min + " and " + this.max;
    }

    public T clampValue(T value) {
        if (((Number)value).doubleValue() > ((Number)this.min).doubleValue()) {
            return ((Number)value).doubleValue() > ((Number)this.max).doubleValue() ? this.max : value;
        }
        return this.min;
    }

    @Override
    public void fromAnnotationParam(String param, Class<?> valueType) {
        String[] parts;
        if (param.endsWith("!")) {
            this.autoCorrect = true;
            param = param.substring(0, param.length() - 1);
        }
        if ((parts = StringUtils.splitByWholeSeparator((String)param, (String)"..", (int)2)).length == 0) {
            throw new RuntimeException("Invalid value \"" + param + "\" for number range constraint");
        }
        if (parts[0].isEmpty()) {
            if (parts.length < 2 || parts[1].isEmpty()) {
                this.everything();
            } else {
                this.smallerThan((Number)NumberUtil.parse(parts[1], valueType));
            }
        } else if (parts.length < 2 || parts[1].isEmpty()) {
            this.greaterThan((Number)NumberUtil.parse(parts[0], valueType));
        } else {
            this.between((Number)NumberUtil.parse(parts[0], valueType), (Number)NumberUtil.parse(parts[1], valueType));
        }
    }
}

