/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.mods.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1074;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import xaero.common.AXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.settings.ModSettings;
import xaero.map.WorldMap;
import xaero.map.gui.CursorBox;
import xaero.map.gui.GuiDropDown;
import xaero.map.gui.GuiMap;
import xaero.map.gui.GuiTexturedButton;
import xaero.map.gui.IDropDownCallback;
import xaero.map.misc.Misc;
import xaero.map.mods.SupportMods;
import xaero.map.mods.gui.Waypoint;
import xaero.map.mods.gui.WaypointMenuElement;
import xaero.map.mods.gui.WaypointMenuHitbox;
import xaero.map.mods.gui.WaypointMenuScroll;

public class WaypointMenuRenderer {
    private static final int WAYPOINT_MENU_RIGHT_PADDING = 27;
    public static final int MAX_WAYPOINT_MENU_SIZE = 10;
    public static final int MIN_WAYPOINT_MENU_SIZE = 2;
    private final WaypointMenuScroll scrollUp = new WaypointMenuScroll("gui.xaero_wm_up", "\u25b3", 1);
    private final WaypointMenuScroll scrollDown = new WaypointMenuScroll("gui.xaero_wm_down", "\u25bd", -1);
    private final WaypointMenuHitbox extraHitbox = new WaypointMenuHitbox(-150, 0, 177, 0);
    private class_310 mc = class_310.method_1551();

    public void onMapInit(GuiMap screen, List<GuiDropDown> dropdowns, class_310 mc, int width, int height, WaypointWorld waypointWorld, AXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        if (screen.waypointMenu) {
            GuiDropDown setsDropdown;
            boolean canCreate = SupportMods.xaeroMinimap.compatibilityVersion >= 6;
            GuiWaypointSets sets = waypointWorld != null ? new GuiWaypointSets(canCreate, waypointWorld) : null;
            IDropDownCallback setsDropdownCallback = null;
            if (sets != null) {
                setsDropdownCallback = (menu, selected) -> {
                    if (canCreate && selected == menu.size() - 1) {
                        GuiNewSet guiNewSet = new GuiNewSet(modMain, minimapSession, (class_437)screen, (class_437)screen, waypointWorld);
                        class_310.method_1551().method_1507((class_437)guiNewSet);
                        return false;
                    }
                    sets.setCurrentSet(selected);
                    waypointWorld.setCurrent(sets.getCurrentSetKey());
                    minimapSession.getWaypointsManager().updateWaypoints();
                    try {
                        modMain.getSettings().saveWaypoints(waypointWorld);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return true;
                };
            }
            GuiDropDown guiDropDown = setsDropdown = sets == null ? null : new GuiDropDown(sets.getOptions(), width - 173, height - 56, 151, sets.getCurrentSet(), true, setsDropdownCallback, true);
            if (setsDropdown != null) {
                dropdowns.add(setsDropdown);
            }
            screen.addButton(new GuiTexturedButton(width - 173, height - 20, 20, 20, 229, 0, 16, 16, WorldMap.guiTextures, b -> this.onFullMenuButton(b, screen), new CursorBox(class_1074.method_4662((String)"gui.xaero_box_full_waypoints_menu", (Object[])new Object[]{Misc.getKeyName(ModSettings.keyWaypoints)}), "", true)));
            screen.addButton(new GuiTexturedButton(width - 153, height - 20, 20, 20, !modMain.getSettings().renderAllSets ? 81 : 97, 16, 16, 16, WorldMap.guiTextures, b -> this.onRenderAllSetsButton(b, screen, width, height), new CursorBox(class_1074.method_4662((String)(!modMain.getSettings().renderAllSets ? "gui.xaero_box_rendering_current_set" : "gui.xaero_box_rendering_all_sets"), (Object[])new Object[]{Misc.getKeyName(ModSettings.keyAllSets)}), "", true)));
            screen.addButton(new GuiTexturedButton(width - 133, height - 20, 20, 20, WorldMap.settings.showDisabledWaypoints ? 133 : 149, 16, 16, 16, WorldMap.guiTextures, b -> this.onShowDisabledButton(b, screen, width, height), new CursorBox(WorldMap.settings.showDisabledWaypoints ? "gui.xaero_box_showing_disabled" : "gui.xaero_box_hiding_disabled", "", true)));
            screen.addButton(new GuiTexturedButton(width - 113, height - 20, 20, 20, WorldMap.settings.closeWaypointsWhenHopping ? 181 : 197, 16, 16, 16, WorldMap.guiTextures, b -> this.onCloseMenuWhenHoppingButton(b, screen, width, height), new CursorBox(WorldMap.settings.closeWaypointsWhenHopping ? "gui.xaero_box_closing_menu_when_hopping" : "gui.xaero_box_not_closing_menu_when_hopping", "", true)));
        }
    }

    public WaypointMenuElement renderWaypointsMenu(class_4587 matrixStack, GuiMap gui, ArrayList<Waypoint> sideWaypoints, double scale, int width, int height, int offset, int mouseX, int mouseY, boolean leftMousePressed, boolean leftMouseClicked, class_310 mc) {
        int menuStartPos;
        WaypointMenuElement viewed = null;
        int yPos = menuStartPos = WaypointMenuRenderer.menuStartPos(height);
        int elementCount = WaypointMenuRenderer.getMenuElementCount(yPos);
        viewed = this.renderWaypointMenuElement(matrixStack, this.scrollDown, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset > 0, mc);
        yPos -= 8;
        for (int i = offset; i < sideWaypoints.size(); ++i) {
            viewed = this.renderWaypointMenuElement(matrixStack, sideWaypoints.get(i), width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
            yPos -= 8;
            if (i - offset == elementCount - 1) break;
        }
        viewed = this.renderWaypointMenuElement(matrixStack, this.scrollUp, width, yPos -= 8, mouseX, mouseY, viewed, leftMousePressed, gui, offset < sideWaypoints.size() - elementCount, mc);
        yPos -= 8;
        if (viewed != null && leftMouseClicked) {
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15015, (float)1.0f));
        }
        if (leftMousePressed && viewed instanceof WaypointMenuScroll) {
            int direction = ((WaypointMenuScroll)viewed).scroll();
            gui.waypointMenuOffset += direction;
        }
        if (viewed == null) {
            this.extraHitbox.setH(menuStartPos - yPos);
            this.extraHitbox.setY(yPos - menuStartPos);
            viewed = this.renderWaypointMenuElement(matrixStack, this.extraHitbox, width, menuStartPos, mouseX, mouseY, viewed, leftMousePressed, gui, true, mc);
        }
        return viewed;
    }

    public static int menuStartPos(int height) {
        return height - 59;
    }

    public static int getMenuElementCount(int menuStartPos) {
        return Math.min(10, Math.max(2, (menuStartPos - 34) / 16 - 2));
    }

    private WaypointMenuElement renderWaypointMenuElement(class_4587 matrixStack, WaypointMenuElement element, int width, int yPos, int mouseX, int mouseY, WaypointMenuElement viewed, boolean leftMousePressed, class_437 gui, boolean enabled, class_310 mc) {
        boolean hovered;
        int xPos = width - 27;
        boolean bl = hovered = viewed == null && element.isMouseOverElement(xPos, yPos, mouseX, mouseY, mc);
        if (hovered) {
            viewed = element;
        }
        element.renderInMenu(matrixStack, gui, xPos, yPos, mouseX, mouseY, 1.0, enabled, hovered, mc, leftMousePressed);
        return viewed;
    }

    public void onMapMouseRelease(double par1, double par2, int par3) {
        this.releaseScroll();
    }

    private void releaseScroll() {
        this.scrollUp.onMouseRelease();
        this.scrollDown.onMouseRelease();
    }

    private void onFullMenuButton(class_4185 b, GuiMap screen) {
        SupportMods.xaeroMinimap.openWaypointsMenu(this.mc, screen);
    }

    private void onRenderAllSetsButton(class_4185 b, GuiMap screen, int width, int height) {
        SupportMods.xaeroMinimap.handleMinimapKeyBinding(ModSettings.keyAllSets, screen);
    }

    private void onShowDisabledButton(class_4185 b, GuiMap screen, int width, int height) {
        WorldMap.settings.showDisabledWaypoints = !WorldMap.settings.showDisabledWaypoints;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        screen.method_25423(this.mc, width, height);
    }

    private void onCloseMenuWhenHoppingButton(class_4185 b, GuiMap screen, int width, int height) {
        WorldMap.settings.closeWaypointsWhenHopping = !WorldMap.settings.closeWaypointsWhenHopping;
        try {
            WorldMap.settings.saveSettings();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        screen.method_25423(this.mc, width, height);
    }
}

