/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.core;

import java.lang.reflect.Field;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_742;
import xaero.map.WorldMap;
import xaero.map.WorldMapSession;
import xaero.map.core.IWorldMapClientPlayNetHandler;
import xaero.map.mixin.MixinChunkDeltaUpdateS2CPacketAccessor;
import xaero.map.patreon.Patreon;

public class XaeroWorldMapCore {
    public static Field chunkCleanField = null;
    public static WorldMapSession currentSession;

    public static void ensureField() {
        if (chunkCleanField == null) {
            try {
                chunkCleanField = class_2818.class.getDeclaredField("xaero_wm_chunkClean");
            }
            catch (NoSuchFieldException | SecurityException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void chunkUpdateCallback(int chunkX, int chunkZ) {
        XaeroWorldMapCore.ensureField();
        class_638 world = class_310.method_1551().field_1687;
        if (world != null) {
            try {
                for (int x = chunkX - 1; x < chunkX + 2; ++x) {
                    for (int z = chunkZ - 1; z < chunkZ + 2; ++z) {
                        class_2818 chunk = world.method_8497(x, z);
                        if (chunk == null) continue;
                        chunkCleanField.set(chunk, false);
                    }
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void onChunkData(class_2672 packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.method_11523(), packetIn.method_11524());
    }

    public static void onBlockChange(class_2626 packetIn) {
        XaeroWorldMapCore.chunkUpdateCallback(packetIn.method_11309().method_10263() >> 4, packetIn.method_11309().method_10260() >> 4);
    }

    public static void onMultiBlockChange(class_2637 packetIn) {
        MixinChunkDeltaUpdateS2CPacketAccessor packetAccess = (MixinChunkDeltaUpdateS2CPacketAccessor)packetIn;
        XaeroWorldMapCore.chunkUpdateCallback(packetAccess.getSectionPos().method_10263(), packetAccess.getSectionPos().method_10260());
    }

    public static class_2960 getPlayerCape(class_742 player) {
        return Patreon.getPlayerCape(WorldMap.fileLayoutID, player);
    }

    public static Boolean isWearing(class_1657 player, class_1664 part) {
        if (part != class_1664.field_7559 || !(player instanceof class_742)) {
            return null;
        }
        return Patreon.isWearingCape(WorldMap.fileLayoutID, (class_742)player);
    }

    public static void onPlayNetHandler(class_634 netHandler) {
        try {
            WorldMapSession worldmapSession;
            IWorldMapClientPlayNetHandler netHandlerAccess = (IWorldMapClientPlayNetHandler)netHandler;
            if (netHandlerAccess.getXaero_worldmapSession() != null) {
                return;
            }
            if (currentSession != null) {
                System.out.println("Previous world map session still active. Probably using MenuMobs. Forcing it to end...");
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            currentSession = worldmapSession = new WorldMapSession();
            worldmapSession.init();
            netHandlerAccess.setXaero_worldmapSession(worldmapSession);
            WorldMap.settings.updateRegionCacheHashCode();
        }
        catch (Throwable e) {
            if (currentSession != null) {
                XaeroWorldMapCore.cleanupCurrentSession();
            }
            RuntimeException wrappedException = new RuntimeException("Exception initializing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
            class_310.method_1551().field_1687.method_8525();
        }
    }

    private static void cleanupCurrentSession() {
        try {
            currentSession.cleanup();
        }
        catch (Throwable supressed) {
            supressed.printStackTrace();
        }
        finally {
            currentSession = null;
        }
    }

    public static void onPlayNetHandlerCleanup(class_634 netHandler) {
        try {
            WorldMapSession netHandlerSession = ((IWorldMapClientPlayNetHandler)netHandler).getXaero_worldmapSession();
            if (netHandlerSession == null) {
                return;
            }
            try {
                netHandlerSession.cleanup();
            }
            finally {
                if (netHandlerSession == currentSession) {
                    currentSession = null;
                }
                ((IWorldMapClientPlayNetHandler)netHandler).setXaero_worldmapSession(null);
            }
        }
        catch (Throwable e) {
            RuntimeException wrappedException = new RuntimeException("Exception finalizing Xaero's World Map! ", e);
            WorldMap.crashHandler.setCrashedBy(wrappedException);
        }
    }
}

