/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory.sort;

import de.siphalor.tweed.tailor.DropdownMaterial;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;

public abstract class SortMode
implements DropdownMaterial<SortMode> {
    private static final Map<String, SortMode> SORT_MODES = new HashMap<String, SortMode>();
    private final String name;
    public static final SortMode NONE = SortMode.register("none", new SortMode("none"){

        @Override
        public Integer[] sort(Integer[] sortIds, class_1799[] stacks) {
            return sortIds;
        }
    });
    public static final SortMode ALPHABET = SortMode.register("alphabet", new SortMode("alphabet"){
        String[] strings;
        class_1799[] stacks;

        @Override
        public Integer[] sort(Integer[] sortIds, class_1799[] stacks) {
            this.stacks = stacks;
            this.strings = (String[])Arrays.stream(sortIds).map(id -> {
                class_1799 itemStack = stacks[id];
                if (itemStack.method_7960()) {
                    return "";
                }
                return class_1074.method_4662((String)itemStack.method_7964().getString(), (Object[])new Object[0]);
            }).toArray(String[]::new);
            Arrays.sort(sortIds, (a, b) -> {
                if (this.strings[a].equals("")) {
                    if (this.strings[b].equals("")) {
                        return 0;
                    }
                    return 1;
                }
                if (this.strings[b].equals("")) {
                    return -1;
                }
                int comp = this.strings[a].compareToIgnoreCase(this.strings[b]);
                if (comp == 0) {
                    return Integer.compare(stacks[b].method_7947(), stacks[a].method_7947());
                }
                return comp;
            });
            return sortIds;
        }
    });
    public static final SortMode QUANTITY = SortMode.register("quantity", new SortMode("quantity"){

        @Override
        public Integer[] sort(Integer[] sortIds, class_1799[] stacks) {
            HashMap<class_1792, Integer> itemToAmountMap = new HashMap<class_1792, Integer>();
            for (class_1799 stack : stacks) {
                if (stack.method_7960()) continue;
                if (!itemToAmountMap.containsKey(stack.method_7909())) {
                    itemToAmountMap.put(stack.method_7909(), stack.method_7947());
                    continue;
                }
                itemToAmountMap.put(stack.method_7909(), (Integer)itemToAmountMap.get(stack.method_7909()) + stack.method_7947());
            }
            Arrays.sort(sortIds, (a, b) -> {
                class_1799 stack = stacks[a];
                class_1799 stack2 = stacks[b];
                if (stack.method_7960()) {
                    return stack2.method_7960() ? 0 : 1;
                }
                if (stack2.method_7960()) {
                    return -1;
                }
                Integer amountA = (Integer)itemToAmountMap.get(stack.method_7909());
                Integer amountB = (Integer)itemToAmountMap.get(stack2.method_7909());
                return Integer.compare(amountB, amountA);
            });
            return sortIds;
        }
    });
    public static final SortMode RAW_ID = SortMode.register("raw_id", new SortMode("raw_id"){

        @Override
        public Integer[] sort(Integer[] sortIds, class_1799[] stacks) {
            Integer[] rawIds = (Integer[])Arrays.stream(stacks).map(stack -> stack.method_7960() ? Integer.MAX_VALUE : class_2378.field_11142.method_10206((Object)stack.method_7909())).toArray(Integer[]::new);
            Arrays.sort(sortIds, (a, b) -> {
                int result = Integer.compare(rawIds[a], rawIds[b]);
                if (result == 0) {
                    if (stacks[b].method_7963()) {
                        return Integer.compare(stacks[a].method_7919(), stacks[b].method_7919());
                    }
                    return Integer.compare(stacks[b].method_7947(), stacks[a].method_7947());
                }
                return result;
            });
            return sortIds;
        }
    });

    public static <T extends SortMode> T register(String name, T sortMode) {
        SORT_MODES.put(name, sortMode);
        return sortMode;
    }

    public static void unregister(String name) {
        SORT_MODES.remove(name);
    }

    protected SortMode(String name) {
        this.name = name;
    }

    public abstract Integer[] sort(Integer[] var1, class_1799[] var2);

    public DropdownMaterial<SortMode> valueOf(String s) {
        return SORT_MODES.get(s);
    }

    public Collection<SortMode> values() {
        return SORT_MODES.values();
    }

    public String name() {
        return this.name;
    }

    public String getTranslationKey() {
        return "mousewheelie.sortmode." + this.name.toLowerCase(Locale.ENGLISH);
    }
}

