/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.mousewheelie.client.inventory;

import de.siphalor.mousewheelie.MWConfig;
import de.siphalor.mousewheelie.client.inventory.CreativeContainerScreenHelper;
import de.siphalor.mousewheelie.client.util.accessors.ISlot;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_485;

@Environment(value=EnvType.CLIENT)
public class ContainerScreenHelper<T extends class_465<?>> {
    protected final T screen;
    protected final ClickHandler clickHandler;
    public static int INVALID_SCOPE = Integer.MAX_VALUE;

    protected ContainerScreenHelper(T screen, ClickHandler clickHandler) {
        this.screen = screen;
        this.clickHandler = clickHandler;
    }

    public static <T extends class_465<?>> ContainerScreenHelper<T> of(T screen, ClickHandler clickHandler) {
        if (screen instanceof class_481) {
            return new CreativeContainerScreenHelper<class_481>((class_481)screen, clickHandler);
        }
        return new ContainerScreenHelper<T>(screen, clickHandler);
    }

    public void scroll(class_1735 referenceSlot, boolean scrollUp) {
        boolean shallSend;
        if (MWConfig.scrolling.directionalScrolling) {
            shallSend = this.shallChangeInventory(referenceSlot, scrollUp);
        } else {
            shallSend = !scrollUp;
            scrollUp = false;
        }
        if (shallSend) {
            if (!referenceSlot.method_7680(class_1799.field_8037)) {
                this.sendStack(referenceSlot);
            }
            if (class_437.method_25441()) {
                this.sendAllOfAKind(referenceSlot);
            } else if (class_437.method_25442()) {
                this.sendStack(referenceSlot);
            } else {
                this.sendSingleItem(referenceSlot);
            }
        } else {
            class_1799 referenceStack = referenceSlot.method_7677().method_7972();
            int referenceScope = this.getScope(referenceSlot);
            if (class_437.method_25442() || class_437.method_25441()) {
                for (class_1735 slot : this.screen.method_17577().field_7761) {
                    if (this.getScope(slot) == referenceScope || !slot.method_7677().method_7962(referenceStack)) continue;
                    this.sendStack(slot);
                    if (class_437.method_25441()) continue;
                    break;
                }
            } else {
                class_1735 moveSlot = null;
                int stackSize = Integer.MAX_VALUE;
                for (class_1735 slot : this.screen.method_17577().field_7761) {
                    if (this.getScope(slot) == referenceScope || this.getScope(slot) <= 0 != scrollUp || !slot.method_7677().method_7962(referenceStack) || slot.method_7677().method_7947() >= stackSize) continue;
                    stackSize = slot.method_7677().method_7947();
                    moveSlot = slot;
                    if (stackSize != 1) continue;
                    break;
                }
                if (moveSlot != null) {
                    this.sendSingleItem(moveSlot);
                }
            }
        }
    }

    public boolean shallChangeInventory(class_1735 slot, boolean scrollUp) {
        return this.getScope(slot) <= 0 == scrollUp;
    }

    public boolean isHotbarSlot(class_1735 slot) {
        return ((ISlot)slot).mouseWheelie_getInvSlot() < 9;
    }

    public int getScope(class_1735 slot) {
        if (slot.field_7871 == null || ((ISlot)slot).mouseWheelie_getInvSlot() >= slot.field_7871.method_5439() || !slot.method_7680(class_1799.field_8037)) {
            return INVALID_SCOPE;
        }
        if (this.screen instanceof class_485) {
            if (slot.field_7871 instanceof class_1661) {
                if (this.isHotbarSlot(slot)) {
                    return 0;
                }
                if (((ISlot)slot).mouseWheelie_getInvSlot() == 40) {
                    return -1;
                }
                return 1;
            }
            return 2;
        }
        if (slot.field_7871 instanceof class_1661) {
            if (MWConfig.general.hotbarScope && this.isHotbarSlot(slot)) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    public void runInScope(int scope, Consumer<class_1735> slotConsumer) {
        for (class_1735 slot : this.screen.method_17577().field_7761) {
            if (this.getScope(slot) != scope) continue;
            slotConsumer.accept(slot);
        }
    }

    public void sendSingleItem(class_1735 slot) {
        this.clickHandler.handleClick(slot, 0, class_1713.field_7790);
        this.clickHandler.handleClick(slot, 1, class_1713.field_7790);
        this.clickHandler.handleClick(slot, 0, class_1713.field_7794);
        this.clickHandler.handleClick(slot, 0, class_1713.field_7790);
    }

    public void sendStack(class_1735 slot) {
        this.clickHandler.handleClick(slot, 0, class_1713.field_7794);
    }

    public void sendAllOfAKind(class_1735 referenceSlot) {
        class_1799 referenceStack = referenceSlot.method_7677().method_7972();
        this.runInScope(this.getScope(referenceSlot), slot -> {
            if (slot.method_7677().method_7962(referenceStack)) {
                this.sendStack((class_1735)slot);
            }
        });
    }

    public void sendAllFrom(class_1735 referenceSlot) {
        this.runInScope(this.getScope(referenceSlot), this::sendStack);
    }

    public void dropStack(class_1735 slot) {
        this.clickHandler.handleClick(slot, 1, class_1713.field_7795);
    }

    public void dropAllOfAKind(class_1735 referenceSlot) {
        class_1799 referenceStack = referenceSlot.method_7677().method_7972();
        this.runInScope(this.getScope(referenceSlot), slot -> {
            if (slot.method_7677().method_7962(referenceStack)) {
                this.dropStack((class_1735)slot);
            }
        });
    }

    public void dropAllFrom(class_1735 referenceSlot) {
        class_1799 referenceStack = referenceSlot.method_7677().method_7972();
        this.runInScope(this.getScope(referenceSlot), this::dropStack);
    }

    public static interface ClickHandler {
        public void handleClick(class_1735 var1, int var2, class_1713 var3);
    }
}

