/*
 * Decompiled with CFR 0.152.
 */
package me.modmuss50.optifabric.patcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import me.modmuss50.optifabric.patcher.LambdaRebuilder;
import me.modmuss50.optifabric.patcher.MethodComparison;
import net.fabricmc.loader.launch.common.FabricLauncherBase;
import net.fabricmc.tinyremapper.IMappingProvider;
import org.apache.commons.lang3.tuple.Pair;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class StaticFuzzer
extends LambdaRebuilder {
    public StaticFuzzer() throws IOException {
        super(FabricLauncherBase.minecraftJar.toFile());
    }

    public byte[] apply(byte[] in) throws IOException {
        ClassReader reader = new ClassReader(in);
        ClassNode optifine = new ClassNode();
        reader.accept((ClassVisitor)optifine, 0);
        this.findLambdas(optifine);
        HashMap<String, Object> remapped = new HashMap<String, Object>();
        for (Map.Entry entry : this.fuzzes.entrySet()) {
            IMappingProvider.Member lambda = (IMappingProvider.Member)entry.getKey();
            Pair remap = (Pair)entry.getValue();
            assert (lambda.owner.equals(reader.getClassName()));
            remapped.put(lambda.name.concat(lambda.desc), remap.getLeft());
        }
        if (remapped.isEmpty()) {
            assert (this.fuzzes.isEmpty());
            return in;
        }
        this.fuzzes.clear();
        for (MethodNode method : optifine.methods) {
            String remap = (String)remapped.get(method.name.concat(method.desc));
            if (remap != null) {
                method.name = remap;
            }
            block6: for (AbstractInsnNode insn : method.instructions) {
                switch (insn.getType()) {
                    case 5: {
                        MethodInsnNode minsn = (MethodInsnNode)insn;
                        if (!optifine.name.equals(minsn.owner) || (remap = (String)remapped.get(minsn.name.concat(minsn.desc))) == null) break;
                        minsn.name = remap;
                        break;
                    }
                    case 6: {
                        InvokeDynamicInsnNode dinsn = (InvokeDynamicInsnNode)insn;
                        if (!MethodComparison.isJavaLambdaMetafactory(dinsn.bsm)) break;
                        Handle lambda = (Handle)dinsn.bsmArgs[1];
                        if (!optifine.name.equals(lambda.getOwner()) || (remap = (String)remapped.get(lambda.getName().concat(lambda.getDesc()))) == null) continue block6;
                        dinsn.bsmArgs[1] = new Handle(lambda.getTag(), lambda.getOwner(), remap, lambda.getDesc(), lambda.isInterface());
                        break;
                    }
                }
            }
        }
        ClassWriter writer = new ClassWriter(reader, 0);
        optifine.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    @Override
    protected String remapName(String owner, String name, String desc) {
        return name;
    }
}

