/*
 * Decompiled with CFR 0.152.
 */
package de.siphalor.amecs.impl;

import de.siphalor.amecs.api.KeyBindingUtils;
import de.siphalor.amecs.api.KeyModifier;
import de.siphalor.amecs.api.PriorityKeyBinding;
import de.siphalor.amecs.impl.AmecsAPI;
import de.siphalor.amecs.impl.duck.IKeyBinding;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;

@Environment(value=EnvType.CLIENT)
public class KeyBindingManager {
    public static Map<class_3675.class_306, ConcurrentLinkedQueue<class_304>> keysById = new HashMap<class_3675.class_306, ConcurrentLinkedQueue<class_304>>();

    public static void register(class_304 keyBinding) {
        class_3675.class_306 keyCode = ((IKeyBinding)keyBinding).amecs$getKeyCode();
        if (keysById.containsKey(keyCode)) {
            keysById.get(keyCode).add(keyBinding);
        } else {
            keysById.put(keyCode, new ConcurrentLinkedQueue<class_304>(Collections.singleton(keyBinding)));
        }
    }

    public static Stream<class_304> getMatchingKeyBindings(class_3675.class_306 keyCode) {
        Queue keyBindingQueue = keysById.get(keyCode);
        if (keyBindingQueue == null) {
            return Stream.empty();
        }
        Stream<class_304> result = keyBindingQueue.stream().filter(keyBinding -> ((IKeyBinding)keyBinding).amecs$getKeyModifiers().isPressed());
        Set keyBindings = result.collect(Collectors.toSet());
        if (keyBindings.isEmpty()) {
            return keysById.get(keyCode).stream().filter(keyBinding -> ((IKeyBinding)keyBinding).amecs$getKeyModifiers().isUnset());
        }
        return keyBindings.stream();
    }

    public static void onKeyPressed(class_3675.class_306 keyCode) {
        KeyBindingManager.getMatchingKeyBindings(keyCode).filter(keyBinding -> !(keyBinding instanceof PriorityKeyBinding)).forEach(keyBinding -> ((IKeyBinding)keyBinding).amecs$setTimesPressed(((IKeyBinding)keyBinding).amecs$getTimesPressed() + 1));
    }

    public static void updatePressedStates() {
        Collection keyBindings = keysById.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        for (class_304 keyBinding : keyBindings) {
            boolean pressed = !keyBinding.method_1415() && ((IKeyBinding)keyBinding).amecs$getKeyCode().method_1442() == class_3675.class_307.field_1668 && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)((IKeyBinding)keyBinding).amecs$getKeyCode().method_1444());
            keyBinding.method_23481(pressed);
        }
    }

    public static void updateKeysByCode() {
        keysById.clear();
        KeyBindingUtils.getIdToKeyBindingMap().values().forEach(KeyBindingManager::register);
    }

    public static void unpressAll() {
        KeyBindingUtils.getIdToKeyBindingMap().values().forEach(keyBinding -> keyBinding.method_23481(false));
    }

    public static boolean onKeyPressedPriority(class_3675.class_306 keyCode) {
        Set keyBindings = KeyBindingManager.getMatchingKeyBindings(keyCode).filter(keyBinding -> keyBinding instanceof PriorityKeyBinding).collect(Collectors.toSet());
        for (class_304 keyBinding2 : keyBindings) {
            if (!((PriorityKeyBinding)keyBinding2).onPressedPriority()) continue;
            return true;
        }
        return false;
    }

    public static void setKeyPressed(class_3675.class_306 keyCode, boolean pressed) {
        AmecsAPI.CURRENT_MODIFIERS.set(KeyModifier.fromKeyCode(keyCode.method_1444()), pressed);
        KeyBindingManager.getMatchingKeyBindings(keyCode).forEach(keyBinding -> keyBinding.method_23481(pressed));
    }
}

